/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.db;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.framework.session.ISessionManager;
import com.kingdee.bos.framework.session.SessionInfo;
import com.kingdee.bos.framework.session.SessionManager;
import com.kingdee.bos.framework.session.SessionNotFoundException;
import com.kingdee.bos.rpcwrapper.ServerSessionContainer;
import com.kingdee.bos.sql.shell.Repository;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

abstract class BOSRepository
implements Repository {
    private static Logger logger = Logger.getLogger(BOSRepository.class);
    public static final String ACCESS_TIME = "repo_access_time";
    protected Context ctx = null;
    protected int operation = 0;

    BOSRepository(Context ctx) {
        this.ctx = ctx;
    }

    boolean setContext(Context ctx) {
        if (this.ctx == null) {
            this.ctx = ctx;
            return true;
        }
        return false;
    }

    public void setOperation(int oprt) {
        this.operation |= oprt;
    }

    public void reset() {
        this.ctx = null;
        this.operation = 0;
    }

    void markAccessTime() {
        SessionInfo session;
        Context context = this.ctx;
        if (context != null && Repository.Responsibility.Command.equals(this.getResponsibility()) && (this.operation & 2) == 2 && (session = BOSRepository.getSessionInfo(context)) != null) {
            BOSRepository.getSessionInfo(context).put((Object)ACCESS_TIME, (Object)this.getTime());
        }
    }

    long getAccessTime() {
        return BOSRepository.getAccessTime(this.ctx);
    }

    static long getAccessTime(Context context) {
        long time = Long.MIN_VALUE;
        if (context != null) {
            SessionInfo session = BOSRepository.getSessionInfo(context);
            if (session != null) {
                Long t = (Long)session.get((Object)ACCESS_TIME);
                if (t != null) {
                    time = t;
                }
            } else {
                time = Long.MAX_VALUE;
            }
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getTime() {
        Context context = this.ctx;
        if (context != null) {
            ResultSet set;
            Statement stmt;
            Connection conn;
            block5: {
                long l;
                conn = null;
                stmt = null;
                set = null;
                try {
                    conn = EJBFactory.getConnection(context);
                    stmt = conn.createStatement();
                    set = stmt.executeQuery("SELECT NOW()");
                    if (!set.next()) break block5;
                    Timestamp time = set.getTimestamp(1);
                    l = time.getTime();
                }
                catch (Exception e) {
                    try {
                        logger.error((Object)"get sys date error.", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(set, (Statement)stmt, (Connection)conn);
                        throw throwable;
                    }
                    SQLUtils.cleanup((ResultSet)set, (Statement)stmt, (Connection)conn);
                }
                SQLUtils.cleanup((ResultSet)set, (Statement)stmt, (Connection)conn);
                return l;
            }
            SQLUtils.cleanup((ResultSet)set, (Statement)stmt, (Connection)conn);
        }
        return Long.MAX_VALUE;
    }

    private static SessionInfo getSessionInfo(Context ctx) {
        String sessionid = null;
        if (ServerSessionContainer.getCurrentSession() != null) {
            sessionid = (String)ServerSessionContainer.getCurrentSession().get((Object)"bos_sessionid");
        }
        if (sessionid != null) {
            ISessionManager sessionManager = SessionManager.getInstance();
            try {
                return sessionManager.getSessionWithException(sessionid);
            }
            catch (SessionNotFoundException sessionNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }
}

