/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.db;

import com.kingdee.bos.db.TableInfo;
import com.kingdee.bos.db.TableManager;
import com.kingdee.bos.sql.dom.stmt.SqlCreateTableStmt;
import com.kingdee.bos.sql.dom.stmt.SqlStmt;
import com.kingdee.bos.sql.formater.FormaterFactory;
import com.kingdee.bos.sql.formater.SQLFormater;
import com.kingdee.bos.sql.parser.Lexer;
import com.kingdee.bos.sql.parser.SqlParser;
import com.kingdee.bos.sql.util.UUTN;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class DB2TableManager
extends TableManager {
    protected DB2TableManager(String ais) {
        super(ais);
    }

    protected DB2TableManager(Connection conn) {
        super(conn);
    }

    @Override
    protected String getManagerName() {
        return "DB2Tmgr_";
    }

    @Override
    public void analyzeTable(Connection conn, String tableName) throws SQLException {
        String schema = "DB2ADMIN";
        String sql = "/*ksql_internal*/ SELECT USERNAME FROM KSQL_ENV";
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        if (rs.next()) {
            schema = rs.getString(1);
        }
        rs.close();
        if (tableName != null && tableName.startsWith("GZT")) {
            sql = "/*dialect*/CALL SYSPROC.ADMIN_CMD('runstats on table  SESSION." + tableName + " on key columns and indexes all')";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("TempTable analyzeTable, AIS:" + this.ais + ", PREFIX:" + this.tempTablePrefix + "\nSQL: " + sql));
            }
        } else {
            sql = "/*dialect*/CALL SYSPROC.ADMIN_CMD('runstats on table " + schema + "." + tableName + " on key columns and indexes all')";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("TempTable analyzeTable, AIS:" + this.ais + ", PREFIX:" + this.tempTablePrefix + "\nSQL: " + sql));
            }
        }
        stmt.execute(sql);
        stmt.close();
    }

    @Override
    public void truncateTable(String tableName) throws Exception {
        if (tableName == null || tableName.length() == 0) {
            throw new IllegalArgumentException("tableName: " + tableName);
        }
        String sql = "/*dialect*/alter table " + tableName + " activate not logged initially with empty table";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("TempTable truncateTable, AIS:" + this.ais + ", PREFIX:" + this.tempTablePrefix + "\nSQL: " + sql));
        }
        this.executeSQL(sql);
    }

    @Override
    void createTable(SqlCreateTableStmt stmt) throws Exception {
        SQLFormater formater = FormaterFactory.getFormater((int)this.dbType);
        formater.setOptions(this.formatOptions);
        formater.formatStmt((SqlStmt)stmt);
        String sql = "/*dialect*/" + formater.getBuffer().toString() + " not logged initially";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("TempTable createTable, AIS:" + this.ais + ", PREFIX:" + this.tempTablePrefix + "\nSQL: " + sql));
        }
        try {
            this.executeSQL(sql);
        }
        catch (Throwable ex) {
            throw new Exception(ex);
        }
    }

    @Override
    public void createTable(String sql, Connection cn) throws Exception {
        Lexer lexer = new Lexer(sql);
        SqlParser parser2 = new SqlParser(lexer);
        Collection col = parser2.parseStmtList();
        SqlCreateTableStmt stmt = (SqlCreateTableStmt)col.iterator().next();
        SQLFormater formater = FormaterFactory.getFormater((int)this.dbType);
        formater.setOptions(this.formatOptions);
        formater.formatStmt((SqlStmt)stmt);
        String sql2 = "/*dialect*/" + formater.getBuffer().toString() + " not logged initially";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("TempTable createTable, AIS:" + this.ais + ", PREFIX:" + this.tempTablePrefix + "\nSQL: " + sql2));
        }
        try {
            this.executeSQL(sql2, cn);
        }
        catch (Throwable ex) {
            throw new Exception(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createTempTableImage(Connection orgConnection, String tablename) throws SQLException {
        Connection conn = this.ais != null ? DB2TableManager.getConnection(this.ais) : this.testConnection;
        TableInfo tableInfo = this.getTableInfo(tablename);
        String newTableName = null;
        if (tableInfo != null) {
            TableInfo[] infos = super.getTableInfosByState(0);
            for (int i = 0; i < infos.length; ++i) {
                TableInfo aTableInfo;
                TableInfo tableInfo2 = aTableInfo = infos[i];
                synchronized (tableInfo2) {
                    if (tableInfo.tableFields.equals(aTableInfo.tableFields)) {
                        aTableInfo.setState(1);
                        newTableName = aTableInfo.tableName;
                    }
                    continue;
                }
            }
        }
        boolean oldAuto = conn.getAutoCommit();
        conn.setAutoCommit(false);
        int oldIsolation = conn.getTransactionIsolation();
        Statement stmt = null;
        try {
            conn.setTransactionIsolation(1);
            stmt = conn.createStatement();
            if (newTableName == null) {
                newTableName = this.getTableName("TempTable -createTempTableImage");
                stmt.execute("/*dialect*/CREATE TABLE " + newTableName + " AS (SELECT * FROM " + tablename + ") WITH NO DATA");
                stmt.execute("/*dialect*/alter table " + newTableName + " ACTIVATE NOT LOGGED INITIALLY");
                stmt.execute("INSERT INTO " + newTableName + " SELECT * FROM " + tablename);
            } else {
                stmt.execute("insert into " + newTableName + " select * from " + tablename);
            }
        }
        finally {
            conn.commit();
            conn.setTransactionIsolation(oldIsolation);
            conn.setAutoCommit(oldAuto);
            SQLUtils.cleanup((Statement)stmt);
        }
        return newTableName;
    }

    @Override
    String createDBSystemTempTable_Session(String sql, Connection cn) throws Exception {
        String tableName;
        Lexer lexer = new Lexer(sql);
        SqlParser parser2 = new SqlParser(lexer);
        Collection col = parser2.parseStmtList();
        Object obj = col.iterator().next();
        if (!(obj instanceof SqlCreateTableStmt)) {
            throw new IllegalAccessException("Error! SQL is not a create table sql. SQL: " + sql);
        }
        SqlCreateTableStmt stmt = (SqlCreateTableStmt)obj;
        stmt.name = tableName = new UUTN(true, "GZT").toString();
        SQLFormater formater = FormaterFactory.getFormater((int)this.dbType);
        formater.setOptions(this.formatOptions);
        formater.formatStmt((SqlStmt)stmt);
        String sql2 = formater.getBuffer().toString();
        sql2 = sql2.replaceFirst("CREATE TABLE ", "DECLARE GLOBAL TEMPORARY TABLE SESSION.");
        sql2 = "/*dialect*/" + sql2 + " WITH REPLACE ON COMMIT PRESERVE ROWS NOT LOGGED";
        try {
            this.executeSQL(sql2, cn);
        }
        catch (Exception ex) {
            logger.error((Object)("Create DB2 System TempTable Error. Org-Sql: [" + sql + "] Sql: [" + sql2 + "]"));
            throw ex;
        }
        this.DBSystemTempTableIndexMap.put(tableName, Collections.synchronizedSet(new HashSet()));
        return tableName;
    }

    @Override
    String createDBSystemTempTableIndex(String tableName, String columns, boolean isUnique, boolean isClustered, Connection cn) throws Exception {
        columns = columns.trim();
        String indexName = this.createIndexName();
        String sql = null;
        sql = isUnique ? "CREATE UNIQUE INDEX SESSION." + indexName + " ON SESSION." + tableName + " (" + columns + ")" : "CREATE INDEX SESSION." + indexName + " ON SESSION." + tableName + " (" + columns + ")";
        sql = "/*dialect*/" + sql;
        try {
            this.executeSQL(sql, cn);
        }
        catch (Exception ex) {
            logger.error((Object)("Create DBSystemTempTableIndex Error! tableName:[" + tableName + "], columns:[" + columns + "]"), (Throwable)ex);
            throw ex;
        }
        Set<String> indexMap = (Set<String>)this.DBSystemTempTableIndexMap.get(tableName);
        if (indexMap == null) {
            indexMap = Collections.synchronizedSet(new HashSet());
            this.DBSystemTempTableIndexMap.put(tableName, indexMap);
        }
        indexMap.add(indexName);
        return indexName;
    }

    @Override
    void releaseDBSystemTempTable(String tableName, Connection cn) throws Exception {
        try {
            this.executeSQL("/*dialect*/DROP TABLE SESSION." + tableName, cn);
        }
        catch (Exception ex) {
            logger.warn((Object)("releaseDBSystemTempTable failed. Cause: " + ex.getMessage()));
        }
    }
}

