/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.db;

import com.kingdee.bos.db.TableInfo;
import com.kingdee.bos.db.TableManager;
import com.kingdee.bos.sql.dom.stmt.SqlCreateTableStmt;
import com.kingdee.bos.sql.dom.stmt.SqlStmt;
import com.kingdee.bos.sql.formater.FormaterFactory;
import com.kingdee.bos.sql.formater.SQLFormater;
import com.kingdee.bos.sql.parser.Lexer;
import com.kingdee.bos.sql.parser.SqlParser;
import com.kingdee.bos.sql.util.UUTN;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class MSSQLServerTableManager
extends TableManager {
    protected MSSQLServerTableManager(String ais) {
        super(ais);
    }

    protected MSSQLServerTableManager(Connection conn) {
        super(conn);
    }

    @Override
    protected String getManagerName() {
        return "MsSQLTmgr_";
    }

    @Override
    public void analyzeTable(Connection conn, String tableName) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createTempTableImage(Connection orgConnection, String tablename) throws SQLException {
        Connection conn = this.ais != null ? MSSQLServerTableManager.getConnection(this.ais) : this.testConnection;
        TableInfo tableInfo = this.getTableInfo(tablename);
        String newTableName = null;
        if (tableInfo != null) {
            TableInfo[] infos = super.getTableInfosByState(0);
            for (int i = 0; i < infos.length; ++i) {
                TableInfo aTableInfo;
                TableInfo tableInfo2 = aTableInfo = infos[i];
                synchronized (tableInfo2) {
                    if (tableInfo.tableFields.equals(aTableInfo.tableFields)) {
                        aTableInfo.setState(1);
                        newTableName = aTableInfo.tableName;
                    }
                    continue;
                }
            }
        }
        boolean oldAuto = conn.getAutoCommit();
        conn.setAutoCommit(false);
        int oldIsolation = conn.getTransactionIsolation();
        Statement stmt = null;
        try {
            conn.setTransactionIsolation(1);
            stmt = conn.createStatement();
            if (newTableName == null) {
                newTableName = this.getTableName("TempTable -createTempTableImage");
                stmt.execute("/*dialect*/CREATE TABLE " + newTableName + " AS (SELECT * FROM " + tablename + ") WITH NO DATA");
                stmt.execute("/*dialect*/alter table " + newTableName + " ACTIVATE NOT LOGGED INITIALLY");
                stmt.execute("INSERT INTO " + newTableName + " SELECT * FROM " + tablename);
            } else {
                stmt.execute("insert into " + newTableName + " select * from " + tablename);
            }
        }
        finally {
            conn.commit();
            conn.setTransactionIsolation(oldIsolation);
            conn.setAutoCommit(oldAuto);
            SQLUtils.cleanup((Statement)stmt);
        }
        return newTableName;
    }

    @Override
    String createDBSystemTempTable_Session(String sql, Connection cn) throws Exception {
        String tableName;
        Lexer lexer = new Lexer(sql);
        SqlParser parser2 = new SqlParser(lexer);
        Collection col = parser2.parseStmtList();
        Object obj = col.iterator().next();
        if (!(obj instanceof SqlCreateTableStmt)) {
            throw new IllegalAccessException("Error! SQL is not a create table sql. SQL: " + sql);
        }
        SqlCreateTableStmt stmt = (SqlCreateTableStmt)obj;
        stmt.name = tableName = new UUTN(true, "#VT").toString();
        SQLFormater formater = FormaterFactory.getFormater((int)this.dbType);
        formater.setOptions(this.formatOptions);
        formater.formatStmt((SqlStmt)stmt);
        String sql2 = formater.getBuffer().toString();
        sql2 = "/*dialect*/" + sql2;
        try {
            this.executeSQL(sql2, cn);
        }
        catch (Exception ex) {
            logger.error((Object)("Create MsSQLServer DB System TempTable Error. Org-Sql: [" + sql + "] Sql: [" + sql2 + "]"));
            throw ex;
        }
        this.DBSystemTempTableIndexMap.put(tableName, Collections.synchronizedSet(new HashSet()));
        return tableName;
    }

    @Override
    String createDBSystemTempTableIndex(String tableName, String columns, boolean isUnique, boolean isClustered, Connection cn) throws Exception {
        columns = columns.trim();
        String indexName = this.createIndexName();
        String sql = null;
        sql = isUnique ? "CREATE UNIQUE INDEX " + indexName + " ON " + tableName + " (" + columns + ")" : (isClustered ? "CREATE CLUSTERED INDEX " + indexName + " ON " + tableName + " (" + columns + ")" : "CREATE INDEX " + indexName + " ON " + tableName + " (" + columns + ")");
        sql = "/*dialect*/" + sql;
        try {
            this.executeSQL(sql, cn);
        }
        catch (Exception ex) {
            logger.error((Object)("Create Index Error! tableName:[" + tableName + "], columns:[" + columns + "]"), (Throwable)ex);
            throw ex;
        }
        Set<String> indexMap = (Set<String>)this.DBSystemTempTableIndexMap.get(tableName);
        if (indexMap == null) {
            indexMap = Collections.synchronizedSet(new HashSet());
            this.DBSystemTempTableIndexMap.put(tableName, indexMap);
        }
        indexMap.add(indexName);
        return indexName;
    }

    @Override
    void dropDBSystemTempTableIndex(String tableName, String indexName, Connection cn) {
        try {
            String sql = "drop index " + tableName + "." + indexName;
            sql = "/*dialect*/" + sql;
            this.executeSQL(sql, cn);
        }
        catch (Exception ex) {
            logger.warn((Object)("dropDBSystemTempTableIndex[" + indexName + "] on table [" + tableName + "] failed. Cause: " + ex.getMessage()));
        }
    }

    @Override
    public boolean isSqlServer() {
        return true;
    }
}

