/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.db;

import com.kingdee.bos.db.TableManager;
import com.kingdee.bos.sql.dom.stmt.SqlCreateTableStmt;
import com.kingdee.bos.sql.dom.stmt.SqlStmt;
import com.kingdee.bos.sql.formater.FormaterFactory;
import com.kingdee.bos.sql.formater.SQLFormater;
import com.kingdee.bos.sql.parser.Lexer;
import com.kingdee.bos.sql.parser.SqlParser;
import com.kingdee.bos.sql.util.UUTN;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class MySqlTableManager
extends TableManager {
    protected MySqlTableManager(String ais) {
        super(ais);
    }

    protected MySqlTableManager(Connection conn) {
        super(conn);
    }

    @Override
    public void analyzeTable(Connection conn, String tableName) throws SQLException {
    }

    @Override
    protected String getManagerName() {
        return "MySQLTmgr_";
    }

    @Override
    String createDBSystemTempTable_Session(String sql, Connection cn) throws Exception {
        String tableName;
        Lexer lexer = new Lexer(sql);
        SqlParser parser2 = new SqlParser(lexer);
        Collection col = parser2.parseStmtList();
        Object obj = col.iterator().next();
        if (!(obj instanceof SqlCreateTableStmt)) {
            throw new IllegalAccessException("Error! SQL is not a create table sql. SQL: " + sql);
        }
        SqlCreateTableStmt stmt = (SqlCreateTableStmt)obj;
        stmt.name = tableName = new UUTN(false).toString();
        SQLFormater formater = FormaterFactory.getFormater((int)this.dbType);
        formater.setOptions(this.formatOptions);
        formater.formatStmt((SqlStmt)stmt);
        String sql2 = formater.getBuffer().toString();
        sql2 = sql2.replaceFirst("CREATE TABLE", "CREATE TEMPORARY TABLE");
        sql2 = "/*dialect*/" + sql2;
        try {
            this.executeSQL(sql2, cn);
        }
        catch (Exception ex) {
            logger.error((Object)("Create MySQL System TempTable Error. Org-Sql: [" + sql + "] Sql: [" + sql2 + "]"));
            throw ex;
        }
        this.DBSystemTempTableIndexMap.put(tableName, Collections.synchronizedSet(new HashSet()));
        return tableName;
    }

    @Override
    void dropDBSystemTempTableIndex(String tableName, String indexName, Connection cn) {
        try {
            String sql = "drop index " + indexName + " on " + tableName;
            sql = "/*dialect*/" + sql;
            this.executeSQL(sql, cn);
        }
        catch (Exception ex) {
            logger.warn((Object)("dropDBSystemTempTableIndex[" + indexName + "] on table [" + tableName + "] failed. Cause: " + ex.getMessage()));
        }
    }
}

