/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.db;

import com.kingdee.bos.db.TableManager;
import com.kingdee.bos.sql.dom.stmt.SqlCreateTableStmt;
import com.kingdee.bos.sql.dom.stmt.SqlStmt;
import com.kingdee.bos.sql.formater.FormaterFactory;
import com.kingdee.bos.sql.formater.SQLFormater;
import com.kingdee.bos.sql.parser.Lexer;
import com.kingdee.bos.sql.parser.SqlParser;
import com.kingdee.bos.sql.util.UUTN;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class PostgresTableManager
extends TableManager {
    public PostgresTableManager(Connection conn) {
        super(conn);
    }

    public PostgresTableManager(String ais) {
        super(ais);
    }

    @Override
    protected String getManagerName() {
        return "PostgresTmgr_";
    }

    @Override
    protected String generateTableName() {
        String tableName = new UUTN(false).toString() + "_" + System.currentTimeMillis();
        return tableName;
    }

    @Override
    public void analyzeTable(Connection conn, String tableName) throws SQLException {
    }

    @Override
    public boolean isPostgres() {
        return true;
    }

    @Override
    String createDBSystemTempTable_Session(String sql, Connection cn) throws Exception {
        String tableName;
        Lexer lexer = new Lexer(sql);
        SqlParser parser2 = new SqlParser(lexer);
        Collection col = parser2.parseStmtList();
        Object obj = col.iterator().next();
        if (!(obj instanceof SqlCreateTableStmt)) {
            throw new IllegalAccessException("Error! SQL is not a create table sql. SQL: " + sql);
        }
        SqlCreateTableStmt stmt = (SqlCreateTableStmt)obj;
        stmt.name = tableName = new UUTN(false, "GZT").toString();
        SQLFormater formater = FormaterFactory.getFormater((int)this.dbType);
        boolean isNologging = false;
        if (this.formatOptions != null) {
            isNologging = this.formatOptions.isNologging();
            this.formatOptions.setNologging(false);
        }
        formater.setOptions(this.formatOptions);
        formater.formatStmt((SqlStmt)stmt);
        String sql2 = formater.getBuffer().toString();
        sql2 = sql2.replaceFirst("CREATE TABLE", "CREATE TEMPORARY TABLE");
        sql2 = "/*dialect*/" + sql2 + " ";
        if (this.formatOptions != null) {
            this.formatOptions.setNologging(isNologging);
        }
        try {
            this.executeSQL(sql2, cn);
        }
        catch (Exception ex) {
            logger.error((Object)("Create postgres DB System TempTable Error. Org-Sql: [" + sql + "] Sql: [" + sql2 + "]"));
            throw ex;
        }
        this.DBSystemTempTableIndexMap.put(tableName, Collections.synchronizedSet(new HashSet()));
        return tableName;
    }
}

