/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.db;

import com.kingdee.bos.Context;
import com.kingdee.bos.db.BOSRepository;
import com.kingdee.bos.db.CommandRepository;
import com.kingdee.bos.db.QueryRepository;
import com.kingdee.bos.db.RWSplitingManager;
import com.kingdee.bos.framework.DeployInfoManagerFactory;
import com.kingdee.bos.framework.config.SolutionDeployInfo;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.shell.KSQLSettingFactory;
import com.kingdee.bos.sql.shell.Repository;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class RepositoryFactory {
    private static final Logger logger = Logger.getLogger(RepositoryFactory.class);
    private static final Logger trace = Logger.getLogger((String)"RepositoryLogger");

    public static Repository getQueryRepository(Context ctx) {
        Repository repo = RepositoryFactory.getCurrentRepository();
        if (repo != null && repo.getResponsibility().isQuery()) {
            BOSRepository r;
            boolean first;
            if (repo instanceof BOSRepository && (first = (r = (BOSRepository)repo).setContext(ctx)) && !RepositoryFactory.canQueryRepositoryUsed(repo, ctx, r.getAccessTime())) {
                return null;
            }
            return repo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canQueryRepositoryUsed(Repository repo, Context ctx, long access) {
        if (!repo.getResponsibility().isMandatory()) {
            long syn;
            repo = RepositoryFactory.resetRepository();
            try {
                syn = new SynchronizedTimeGetter().getTime(ctx);
            }
            finally {
                KSQLSettingFactory.getInstance().setCurrentRepository(repo);
            }
            if (syn < access) {
                RepositoryFactory.resetRepository();
                return false;
            }
        }
        return true;
    }

    public static boolean isBindQueryRepository(Context ctx) {
        Repository repo = RepositoryFactory.getCurrentRepository();
        if (repo != null) {
            BOSRepository r;
            boolean first;
            boolean isQuery = repo.getResponsibility().isQuery();
            if (repo instanceof BOSRepository && (first = (r = (BOSRepository)repo).setContext(ctx)) && isQuery) {
                return RepositoryFactory.canQueryRepositoryUsed(repo, ctx, r.getAccessTime());
            }
            return isQuery;
        }
        return false;
    }

    public static Repository resetRepository() {
        Repository repo = KSQLSettingFactory.getInstance().setCurrentRepository(null);
        return repo;
    }

    public static Repository getCurrentRepository() {
        return KSQLSettingFactory.getInstance().getCurrentRepository();
    }

    public static void setCurrentRepository(Repository repo) {
        KSQLSettingFactory.getInstance().setCurrentRepository(repo);
    }

    public static void setCurrentRepository(Repository.Responsibility res) {
        BOSRepository repo = null;
        repo = res.isQuery() ? new QueryRepository(null, res) : new CommandRepository(null);
        KSQLSettingFactory.getInstance().setCurrentRepository((Repository)repo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Exception> T noShift(Work<T, E> work) throws E {
        Repository repo = RepositoryFactory.resetRepository();
        try {
            T t = work.run();
            return t;
        }
        finally {
            KSQLSettingFactory.getInstance().setCurrentRepository(repo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void noShift(Runnable work) {
        Repository repo = RepositoryFactory.resetRepository();
        try {
            work.run();
        }
        finally {
            KSQLSettingFactory.getInstance().setCurrentRepository(repo);
        }
    }

    public static void markAccessTime() {
        Repository repo = RepositoryFactory.getCurrentRepository();
        if (repo != null && repo instanceof BOSRepository) {
            ((BOSRepository)repo).markAccessTime();
        }
    }

    public static Logger getLogger() {
        return trace;
    }

    public static interface Work<T, E extends Exception> {
        public T run() throws E;
    }

    static class SynchronizedTimeGetter {
        SynchronizedTimeGetter() {
        }

        void get() {
            SolutionDeployInfo slnDeployInfo = DeployInfoManagerFactory.getDeployInfoManager().getSolutionDeployInfo("eas");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long getTime(Context ctx) {
            if (ctx != null) {
                String main = RWSplitingManager.getMainSlaver(ctx);
                if (main == null) {
                    return Long.MIN_VALUE;
                }
                Context context = new Context(null, "eas", main, null);
                Connection conn = null;
                Statement stmt = null;
                ResultSet set = null;
                try {
                    conn = EJBFactory.getConnection(context);
                    stmt = conn.createStatement();
                    stmt.setQueryTimeout(1);
                    set = stmt.executeQuery("SELECT max(SYNTIME) FROM SCN_SYN_LOG ");
                    if (set.next()) {
                        Timestamp time = set.getTimestamp(1);
                        long l = time.getTime();
                        SQLUtils.cleanup((ResultSet)set, (Statement)stmt, (Connection)conn);
                        return l;
                    }
                    SQLUtils.cleanup((ResultSet)set, (Statement)stmt, (Connection)conn);
                }
                catch (Exception e) {
                    logger.error((Object)"get Synchronized date error.", (Throwable)e);
                }
                finally {
                    SQLUtils.cleanup(set, (Statement)stmt, (Connection)conn);
                }
            }
            return Long.MIN_VALUE;
        }
    }
}

