/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.db;

import com.kingdee.bos.dao.query.server.IQueryDataAccess;
import com.kingdee.bos.sql.shell.Repository;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

final class ResponsibilityManager {
    private static final Logger logger = Logger.getLogger(ResponsibilityManager.class);
    static final String DEFAULT = "default";
    static final String READ = "read";
    static final String WRITE = "write";
    static final String CONFIG_DIR = "eas.properties.dir";
    static final String FILE_NAME = "rwconfig.properties";
    private static final List<Item> commands = new ArrayList<Item>();
    private static final List<Item> queries = new ArrayList<Item>();
    private static final List<Item> mandatories = new ArrayList<Item>();

    ResponsibilityManager() {
    }

    static Repository.Responsibility getResponsibility(Class<?> clazz, Method method) {
        boolean isQuery;
        Repository.Responsibility res = null;
        boolean bl = isQuery = clazz != null && IQueryDataAccess.class.isAssignableFrom(clazz);
        if (isQuery) {
            res = Repository.Responsibility.Query;
        }
        String methodName = method == null ? null : method.getName();
        String className = clazz == null ? null : clazz.getName();
        return ResponsibilityManager.getResponsibility(className, methodName, res);
    }

    static Repository.Responsibility getResponsibility(String className, String methodName, Repository.Responsibility processed) {
        if (className.contains("bos.workflow") || className.contains("cp.wfs") || className.contains("base.message") || className.contains("base.log")) {
            return Repository.Responsibility.Command;
        }
        boolean isCommand = processed != null && processed.isCommand();
        for (Item i : commands) {
            isCommand = isCommand || i.classMatchs(className) && i.methodMatchs(methodName);
        }
        if (isCommand) {
            return Repository.Responsibility.Command;
        }
        boolean isMandatory = processed != null && processed.isMandatory();
        for (Item i : mandatories) {
            isMandatory = isMandatory || i.classMatchs(className) && i.methodMatchs(methodName);
        }
        if (isMandatory) {
            return Repository.Responsibility.Mandatory;
        }
        boolean isQuery = processed != null && processed.isQuery();
        isQuery = isQuery || "doAllQueryTask".equals(methodName);
        isQuery = isQuery || "getValue".equals(methodName);
        isQuery = isQuery || "getCollection".equals(methodName);
        isQuery = isQuery || "exists".equals(methodName);
        isQuery = isQuery || "getPKList".equals(methodName);
        isQuery = isQuery || methodName != null && methodName.matches("^get.+(Info|Collection)$");
        for (Item i : queries) {
            isQuery = isQuery || i.classMatchs(className) && i.methodMatchs(methodName);
        }
        if (isQuery) {
            // empty if block
        }
        return Repository.Responsibility.Command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        File config = new File(new File(System.getProperty(CONFIG_DIR)), FILE_NAME);
        if (config.exists()) {
            Properties properties = new Properties();
            FileInputStream input = null;
            try {
                input = new FileInputStream(config);
                properties.load(input);
            }
            catch (Exception e) {
                logger.error((Object)("load repository config error. config:" + config.getAbsolutePath()), (Throwable)e);
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {}
                }
            }
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                Item i = Item.newInstance((String)e.getKey());
                if (i == null) continue;
                if (READ.equals(e.getValue())) {
                    mandatories.add(i);
                    continue;
                }
                if (WRITE.equals(e.getValue())) {
                    commands.add(i);
                    continue;
                }
                queries.add(i);
            }
        }
    }

    private static class Item {
        final String clazz;
        private final List<String> methods;

        static Item newInstance(String desc) {
            Item item;
            if (desc == null || desc.length() == 0) {
                return null;
            }
            int index = desc.indexOf(40);
            String methods = null;
            if (index < 0) {
                item = new Item(desc);
            } else {
                item = new Item(desc.substring(0, index));
                methods = desc.substring(index + 1, desc.lastIndexOf(41));
            }
            if (methods != null && methods.length() > 0) {
                for (String s : methods.split(",")) {
                    item.addMethod(s);
                }
            }
            return item;
        }

        Item(String clazz) {
            this.clazz = clazz;
            this.methods = new ArrayList<String>(1);
        }

        void addMethod(String m) {
            this.methods.add(m);
        }

        boolean classMatchs(String clazz) {
            if (clazz == null) {
                return false;
            }
            return clazz.matches(this.clazz);
        }

        boolean methodMatchs(String method) {
            if (method == null) {
                return false;
            }
            if (this.methods.size() == 0) {
                return true;
            }
            for (String m : this.methods) {
                if (!method.matches(m)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder str = new StringBuilder(this.clazz);
            str.append("(");
            int size = this.methods.size();
            for (int i = 0; i < size; ++i) {
                str.append(this.methods.get(i));
                if (i == size - 1) continue;
                str.append(",");
            }
            str.append(")");
            return str.toString();
        }
    }
}

