/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.db;

import com.kingdee.bos.Context;
import com.kingdee.bos.db.LifeCycleable;
import com.kingdee.bos.db.RWSplitingManager;
import com.kingdee.bos.db.RepositoryController;
import com.kingdee.bos.db.RepositoryFactory;
import com.kingdee.bos.db.TableInfo;
import com.kingdee.bos.db.TableManager;
import com.kingdee.bos.db.TempTableConfig;
import com.kingdee.bos.db.ThreadAndRecycleManager;
import com.kingdee.bos.db.ViewInfo;
import com.kingdee.bos.rpc.RPCConfig;
import com.kingdee.bos.rpc.performance.InvokeMonitor;
import com.kingdee.bos.sql.dom.stmt.SqlCreateTableStmt;
import com.kingdee.bos.sql.parser.Lexer;
import com.kingdee.bos.sql.parser.SqlParser;
import com.kingdee.bos.sql.shell.Repository;
import com.kingdee.util.StringUtils;
import com.kingdee.util.objbuddy.BuddyObjectFactory;
import com.kingdee.util.objbuddy.IBuddyObject;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public class TempTablePool {
    public static final String MAX_TABLE_SIZE_OPTION = TempTableConfig.MAX_TABLE_SIZE_OPTION;
    private static final Logger logger = Logger.getLogger(TempTablePool.class);
    private static final Map<String, TempTablePool> instances = new HashMap<String, TempTablePool>(4);
    private final TableManager tableManager;
    private final TempTableConfig config = new TempTableConfig();
    private final UseableTableManager useableTableManager = new UseableTableManager();
    private final String ais;
    private final IBuddyObject buddy;
    private final String tempTablePoolKey;
    private final LifeCycleable lifeCycleable = new LifeCycleable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void recycleSucceed(TableInfo tableInfo) {
            logger.debug((Object)("Recycle and truncate temp table " + tableInfo.tableName + " succeed."));
            if (tableInfo.tableFields == null) {
                return;
            }
            TempTablePool.this.useableTableManager.addTableInfo(tableInfo);
            Map map = TempTablePool.this.viewInfoMap;
            synchronized (map) {
                Iterator iter = TempTablePool.this.viewInfoMap.values().iterator();
                while (iter.hasNext()) {
                    ++((ViewInfo)iter.next()).realeaseCount;
                }
            }
            if (!TempTablePool.this.memMappingInfo.contains(tableInfo)) {
                TempTablePool.this.addTempMapping(tableInfo);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void recycleFailed(TableInfo tableInfo) {
            logger.error((Object)("Recycle and truncate temp table " + tableInfo.tableName + " failed, will retry again."));
            Map map = TempTablePool.this.viewInfoMap;
            synchronized (map) {
                Iterator iter = TempTablePool.this.viewInfoMap.values().iterator();
                while (iter.hasNext()) {
                    ++((ViewInfo)iter.next()).delayCount;
                }
            }
        }

        @Override
        public void recycleAbandoned(TableInfo tableInfo) {
            logger.error((Object)("Recycle and truncate temp table " + tableInfo.tableName + " failed,abandon retry."));
        }

        @Override
        public void usableTimeouted(TableInfo tableInfo) {
            TempTablePool.this.useableTableManager.removeTableInfo(tableInfo);
            logger.debug((Object)("Idle temp table " + tableInfo.tableName + " timeout and will be dropped later,not usable again."));
        }

        @Override
        public void usingTimeouted(TableInfo tableInfo) {
            logger.debug((Object)("Using temp table " + tableInfo.tableName + " timeout and will be recycled later."));
        }

        @Override
        public void deleteSucceed(TableInfo tableInfo) {
            logger.debug((Object)("Drop temp table " + tableInfo.tableName + " succeed."));
        }

        @Override
        public void deleteFailed(TableInfo tableInfo) {
            logger.error((Object)("Drop temp table " + tableInfo.tableName + " failed,will retry again."));
        }

        @Override
        public void deleteAbandoned(TableInfo tableInfo) {
            logger.error((Object)("Drop temp table " + tableInfo.tableName + " failed,abandon retry."));
        }
    };
    private final List<TableInfo> memMappingInfo = new ArrayList<TableInfo>();
    final List<TableInfo> memMappingInfoToAdd = new ArrayList<TableInfo>();
    final List<TableInfo> memMappingInfoToRemove = new ArrayList<TableInfo>();
    private final Object memoryMonitor = new Object();
    public static final String TABLE_DESC = "TempTablePool.TempTable";
    private final Map<String, ViewInfo> viewInfoMap = new Hashtable<String, ViewInfo>();

    public long getRecycleTableWaitTime() {
        return 0L;
    }

    public void setRecycleTableWaitTime(long recycleTableWaitTime) {
    }

    private TempTablePool(String ais) throws SQLException {
        this(ais, false);
    }

    private TempTablePool(String ais, boolean isOutMysql) throws SQLException {
        this.ais = ais;
        this.tempTablePoolKey = ais;
        this.tableManager = !isOutMysql ? TableManager.innerGetTableManager(ais) : TableManager.innergetOutMysqlTableManager(ais);
        this.buddy = BuddyObjectFactory.getInstance((Object)this);
        try {
            this.buddy.initialize();
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
        }
    }

    public String getAis() {
        return this.ais;
    }

    private void init() throws Exception {
        this.cleanAndInitTempMappingAndTable();
        ThreadAndRecycleManager threadManager = new ThreadAndRecycleManager(this, 2, this.lifeCycleable);
        threadManager.start();
    }

    private void cleanAndInitTempMappingAndTable() throws Exception {
        int count;
        if (this.isTableDropWhenRecycle()) {
            logger.info((Object)"Begin Drop temp table, it may take long time, please wait...");
            long begin = System.currentTimeMillis();
            try {
                if (this.tableManager.isOutMySql()) {
                    this.tableManager.cleanTempTable(false);
                } else {
                    int timeout = this.config.usingTimeout + 3600000;
                    this.tableManager.cleanTimeoutTempTableAll(timeout);
                    this.tableManager.cleanTempTable(false);
                }
            }
            catch (Exception e) {
                logger.error((Object)"error when clear temp table", (Throwable)e);
                e.printStackTrace();
            }
            long cost = System.currentTimeMillis() - begin;
            logger.info((Object)("End Drop temp table, cost " + cost + " ms."));
            return;
        }
        int timeout = this.config.usableTimeout + 3600000;
        this.tableManager.cleanTimeoutTempTableAll(timeout);
        this.tableManager.cleanTempMapping(false);
        this.tableManager.cleanTempTable(true);
        int topSize = this.config.maxSize * 3 / 4;
        List rows = this.tableManager.getTempTableMapping(topSize, true);
        Iterator iter = rows.iterator();
        for (count = 0; iter.hasNext() && count < topSize; ++count) {
            Object[] row = (Object[])iter.next();
            String tabname = (String)row[0];
            String fields = (String)row[1];
            Timestamp ts = (Timestamp)row[2];
            TableInfo info = new TableInfo(tabname, "Reuse Temp Table", Integer.MAX_VALUE, ts.getTime(), fields);
            info.setState(0);
            this.useableTableManager.addTableInfo(info);
            this.tableManager.addTableInfo(info);
            this.memMappingInfo.add(info);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Reuse Temp Table Count:" + count));
        }
    }

    public static final TempTablePool getInstance(Context context) {
        Repository repo = RepositoryFactory.getQueryRepository(context);
        if (repo != null) {
            return TempTablePool.getInstance(repo.getIdentity());
        }
        return TempTablePool.getInstance(context.getAIS());
    }

    public static final TempTablePool getInstance(Context context, String ais) {
        return TempTablePool.getInstance(ais);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final TempTablePool getInstance(String ais) {
        assert (ais != null);
        TempTablePool instance = instances.get(ais);
        if (instance != null) {
            return instance;
        }
        Map<String, TempTablePool> map = instances;
        synchronized (map) {
            try {
                instance = instances.get(ais);
                if (instance == null) {
                    instance = new TempTablePool(ais);
                    instances.put(ais, instance);
                    instance.init();
                }
                return instance;
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
        return null;
    }

    public static final TempTablePool getInstanceForOutMySql() {
        return TempTablePool.getInstanceForOutMySql("OutMysql");
    }

    public static final TempTablePool getInstanceForOutMySql(Context ctx) {
        return TempTablePool.getInstanceForOutMySql(ctx.getAIS());
    }

    public static final TempTablePool getInstanceForOutMySql(String ais) {
        TempTablePool instance = instances.get(ais);
        if (instance != null) {
            return instance;
        }
        try {
            instance = new TempTablePool(ais, true);
            instance.init();
            instances.put(ais, instance);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return instance;
    }

    public static final TempTablePool getInstanceForRead(Context context) {
        return TempTablePool.getInstance(RWSplitingManager.getReadAis(context));
    }

    public static final TempTablePool getInstanceForRead(Context ctx, String ais) {
        if (ais != null && instances.containsKey(ais)) {
            return TempTablePool.getInstance(ais);
        }
        return TempTablePool.getInstanceForRead(ctx);
    }

    public int getDropUsingTimes() {
        return this.config.minUsingTimes;
    }

    public void setDropUsingTimes(int dropUsingTimes) {
        this.config.minUsingTimes = dropUsingTimes;
    }

    public int getDropTimeout() {
        return this.config.usableTimeout;
    }

    public void setDropTimeout(int dropTimeout) {
        this.config.usableTimeout = dropTimeout;
    }

    public int getRecycleTimeout() {
        return this.config.usingTimeout;
    }

    public void setRecycleTimeout(int recycleTimeout) {
        this.config.usingTimeout = recycleTimeout;
    }

    private void setUsing(TableInfo info) {
        info.setState(1);
        info.incUsingCount();
        info.usingStack = new Throwable("Using Table");
    }

    public String createTempTable(String createSQL) throws Exception {
        return this.createTempTable(createSQL, null, null);
    }

    public String createTempTableName() throws Exception {
        return this.tableManager.getTableName(TABLE_DESC, Long.MAX_VALUE, null);
    }

    public String createTempTable(String createSQL, String oldTableName) throws Exception {
        return this.createTempTable(createSQL, oldTableName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createTempTable(String createSQL, String oldTableName, String oldConstraintName) throws Exception {
        Iterator<ViewInfo> iter;
        if (this.isTableDropWhenRecycle()) {
            String tableName = this.tableManager.getTableName(TABLE_DESC, Long.MAX_VALUE, null);
            if (oldTableName != null) {
                this.createTable(createSQL, oldTableName, tableName, oldConstraintName);
            } else {
                this.createTable(createSQL, tableName);
            }
            TableInfo info = this.tableManager.getTableInfo(tableName);
            this.setUsing(info);
            return tableName;
        }
        String fields = this.getTableFields(createSQL);
        boolean isFirstCreate = !this.useableTableManager.contains(fields);
        List<TableInfo> useableInfos = this.useableTableManager.getUseableTables(fields);
        TableInfo info = null;
        String tableName = null;
        Map<String, ViewInfo> map = useableInfos;
        synchronized (map) {
            while (true) {
                if (!useableInfos.isEmpty()) {
                    info = useableInfos.remove(0);
                    this.setUsing(info);
                    tableName = info.tableName;
                    try {
                        if (!this.tableManager.isTableExists(tableName)) {
                            if (oldTableName != null) {
                                this.createTable(createSQL, oldTableName, tableName, oldConstraintName);
                            } else {
                                this.createTable(createSQL, tableName);
                            }
                            info.incDropCount();
                            break;
                        }
                        if (this.tableManager.isTableEmpty(tableName)) break;
                        try {
                            this.releaseTable(tableName);
                        }
                        catch (Exception ex) {
                            logger.error((Object)ex);
                        }
                        tableName = null;
                    }
                    catch (Throwable ex) {}
                    continue;
                }
                if (this.size() < this.config.maxSize || isFirstCreate) break;
                useableInfos.wait();
            }
        }
        if (tableName != null) {
            map = this.viewInfoMap;
            synchronized (map) {
                iter = this.viewInfoMap.values().iterator();
                while (iter.hasNext()) {
                    ++iter.next().aquireCount;
                }
            }
            return tableName;
        }
        tableName = null;
        tableName = this.tableManager.getTableName(TABLE_DESC, Long.MAX_VALUE, fields);
        if (oldTableName != null) {
            this.createTable(createSQL, oldTableName, tableName, oldConstraintName);
        } else {
            this.createTable(createSQL, tableName);
        }
        info = this.tableManager.getTableInfo(tableName);
        this.addTempMapping(info);
        this.setUsing(info);
        map = this.viewInfoMap;
        synchronized (map) {
            iter = this.viewInfoMap.values().iterator();
            while (iter.hasNext()) {
                ++iter.next().createCount;
            }
        }
        return tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTempMapping(TableInfo tableInfo) {
        if (this.isTableDropWhenRecycle()) {
            return;
        }
        if (tableInfo.tableFields == null) {
            return;
        }
        Object object = this.memoryMonitor;
        synchronized (object) {
            if (!this.memMappingInfo.contains(tableInfo)) {
                this.memMappingInfo.add(tableInfo);
            }
            if (!this.memMappingInfoToAdd.contains(tableInfo)) {
                this.memMappingInfoToAdd.add(tableInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTempMapping(TableInfo tableInfo) {
        if (this.isTableDropWhenRecycle()) {
            return;
        }
        Object object = this.memoryMonitor;
        synchronized (object) {
            this.memMappingInfo.remove(tableInfo);
            if (!this.memMappingInfoToRemove.contains(tableInfo)) {
                this.memMappingInfoToRemove.add(tableInfo);
            }
        }
    }

    private void createTable(String createSQL, String oldName, String newName, String oldConstraint) throws Exception {
        String sql = StringUtils.replace((String)createSQL, (String)oldName, (String)newName);
        if (oldConstraint != null) {
            String newConstraint = "ZC" + newName.substring(newName.length() - 16);
            sql = StringUtils.replace((String)sql, (String)oldConstraint, (String)newConstraint);
        }
        this.tableManager.createTable(sql);
    }

    private void createTable(String createSQL, String newName) throws Exception {
        Lexer lexer = new Lexer(createSQL);
        SqlParser parser2 = new SqlParser(lexer);
        Collection col = parser2.parseStmtList();
        Object obj = col.iterator().next();
        if (!(obj instanceof SqlCreateTableStmt)) {
            throw new IllegalAccessException("Error! SQL is not a create table sql. SQL: " + createSQL);
        }
        SqlCreateTableStmt stmt = (SqlCreateTableStmt)obj;
        stmt.name = newName;
        this.tableManager.createTable(stmt);
    }

    public void analyzeTable(Connection conn, String tableName) throws SQLException {
        this.tableManager.analyzeTable(conn, tableName);
    }

    public String createIndex(String tableName, String columns, boolean isUnique, boolean isClustered) throws Exception {
        TableInfo tableInfo = this.tableManager.getTableInfo(tableName);
        if (tableInfo == null) {
            throw new Exception("Can't find tableInfo for " + tableName);
        }
        columns = columns.trim();
        if (!tableInfo.getIndexMap().containsValue(columns)) {
            String indexName;
            block9: {
                indexName = this.tableManager.createIndexName();
                String sql = null;
                sql = isUnique ? "CREATE UNIQUE INDEX " + indexName + " ON " + tableName + " (" + columns + ")" : (isClustered ? "CREATE CLUSTERED INDEX " + indexName + " ON " + tableName + " (" + columns + ")" : "CREATE INDEX " + indexName + " ON " + tableName + " (" + columns + ")");
                try {
                    if (this.tableManager.isSqlServer()) {
                        this.tableManager.executeSQLDirect(sql);
                    } else {
                        this.tableManager.executeSQL(sql);
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)("Create Index Error! tableName:" + tableName + ", columns:" + columns), (Throwable)ex);
                    if (this.tableManager.isTableExists(tableName)) break block9;
                    throw ex;
                }
            }
            tableInfo.getIndexMap().put(indexName, columns);
            try {
                this.removeTempMapping(tableInfo);
            }
            catch (Exception ex) {
                logger.error((Object)("Remove Temp Table Mapping error! tableName:" + tableInfo.tableName), (Throwable)ex);
            }
            return indexName;
        }
        for (String indexName : tableInfo.getIndexMap().keySet()) {
            String value = tableInfo.getIndexMap().get(indexName);
            if (!value.equals(columns)) continue;
            return indexName;
        }
        throw new Exception("Impossible Exception Occur");
    }

    public void releaseTable(String tableName) {
        assert (tableName != null);
        TableInfo info = this.tableManager.getTableInfo(tableName);
        if (info == null) {
            return;
        }
        this.releaseInner(info);
    }

    void releaseInner(TableInfo info) {
        if (info.tableFields == null) {
            info.setState(8);
        } else if (this.isTableDropWhenRecycle()) {
            info.setState(8);
        } else {
            info.setState(4);
        }
    }

    private String getTableFields(String createSQL) {
        String fields = createSQL.substring(createSQL.indexOf(40) + 1);
        if (fields.indexOf("CONSTRAINT") != -1) {
            fields = fields.substring(0, fields.indexOf("CONSTRAINT")).trim();
        }
        return fields;
    }

    static String getConstraintName(String realTableName) {
        String newConstraintName = realTableName.substring(realTableName.length() - 16);
        newConstraintName = "ZC" + newConstraintName;
        return newConstraintName;
    }

    public int getTempTableSize() {
        return this.tableManager.getTableInfoSize();
    }

    TableInfo[] getTableInfosByState(int state) {
        return this.tableManager.getTableInfosByState(state);
    }

    TableInfo getTableInfoByTableName(String tabName) {
        return this.tableManager.getTableInfo(tabName);
    }

    TableInfo[] getTableInfosByTime(long begin, long end) {
        return this.tableManager.getTableInfosByTime(begin, end);
    }

    String[] listDefinition() {
        ArrayList list = new ArrayList();
        list.addAll(this.useableTableManager.fieldSet());
        return list.toArray(new String[0]);
    }

    TableInfo[] getTableInfosByDef(String def) {
        ArrayList<TableInfo> list = new ArrayList<TableInfo>();
        TableInfo[] infos = this.tableManager.getAllTableInfos();
        for (int i = 0; i < infos.length; ++i) {
            if (!def.equals(infos[i].tableFields)) continue;
            list.add(infos[i]);
        }
        return list.toArray(new TableInfo[0]);
    }

    TableInfo[] getAllTableInfos() {
        return this.tableManager.getAllTableInfos();
    }

    public int size() {
        return this.tableManager.tableMap.size();
    }

    public int getMaxSize() {
        return this.config.maxSize;
    }

    public boolean setMaxSize(int newSize) {
        if (this.size() > newSize || newSize < 1000) {
            return false;
        }
        this.config.maxSize = newSize;
        return true;
    }

    public void testInsert(String name, int times) throws Exception {
        for (int i = 0; i < times; ++i) {
            this.tableManager.executeSQL("insert into " + name + " values ('flsd" + i + "')");
        }
    }

    TableManager getTableManager() {
        return this.tableManager;
    }

    public int getTableSizeByState(int state) {
        return this.tableManager.getTableSize(state);
    }

    public Properties getProperties() {
        Properties prop = new Properties();
        return prop;
    }

    public int getTruncateBatch() {
        return this.config.truncateBatch;
    }

    public void setTruncateBatch(int truncateBatch) {
        if (truncateBatch < 2) {
            return;
        }
        this.config.truncateBatch = truncateBatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addViewPoint() {
        Map<String, ViewInfo> map = this.viewInfoMap;
        synchronized (map) {
            ViewInfo info = new ViewInfo();
            info.startTime = System.currentTimeMillis();
            String key = String.valueOf(info.startTime);
            this.viewInfoMap.put(key, info);
            return key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewInfo fetchViewInfo(String key) {
        Map<String, ViewInfo> map = this.viewInfoMap;
        synchronized (map) {
            ViewInfo info = this.viewInfoMap.remove(key);
            if (info != null) {
                info.endTime = System.currentTimeMillis();
            }
            return info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listViewInfoKey() {
        Map<String, ViewInfo> map = this.viewInfoMap;
        synchronized (map) {
            ArrayList<String> list = new ArrayList<String>();
            list.addAll(this.viewInfoMap.keySet());
            return list.toArray(new String[0]);
        }
    }

    public String getStatics() {
        Calendar c = Calendar.getInstance();
        StringBuffer sb2 = new StringBuffer();
        TableInfo[] tableInfos = this.getAllTableInfos();
        sb2.append("<TABLE border=1 cellspacing=0 cellpadding=0>");
        sb2.append("<tr>");
        sb2.append("<td>").append("TableName").append("</td>");
        sb2.append("<td>").append("TableFields").append("</td>");
        sb2.append("<td>").append("State").append("</td>");
        sb2.append("<td>").append("CreateTime").append("</td>");
        sb2.append("<td>").append("LastStateTime").append("</td>");
        sb2.append("<td>").append("UsingCount").append("</td>");
        sb2.append("<td>").append("TrunctateCount").append("</td>");
        sb2.append("<td>").append("DropCount").append("</td>");
        sb2.append("<td>").append("RecycleRetryCount").append("</td>");
        sb2.append("<td>").append("UsingStack").append("</td>");
        sb2.append("</tr>");
        StringBuffer sb = new StringBuffer();
        int freeCount = 0;
        int usedCount = 0;
        int usingCount = 0;
        int tabCount = 0;
        for (int i = 0; i < tableInfos.length; ++i) {
            TableInfo tabInfo = tableInfos[i];
            if (tabInfo.getTableFields() == null) continue;
            ++tabCount;
            sb.append("<tr>");
            sb.append("<td>").append(tabInfo.getTableName()).append("</td>");
            sb.append("<td>").append(tabInfo.getTableFields()).append("</td>");
            int state = tabInfo.getState();
            if (state == 0) {
                sb.append("<td>").append("USABLE").append("</td>");
                ++freeCount;
            } else if (state == 1) {
                sb.append("<td>").append("USING").append("</td>");
                ++usingCount;
            } else {
                sb.append("<td>&nbsp</td>");
            }
            c.setTimeInMillis(tabInfo.getCreatedDateTime());
            sb.append("<td>").append(DateFormat.getDateTimeInstance(3, 2).format(c.getTime())).append("</td>");
            c.setTimeInMillis(tabInfo.getLastStateTime());
            sb.append("<td>").append(DateFormat.getDateTimeInstance(3, 2).format(c.getTime())).append("</td>");
            sb.append("<td>").append(tabInfo.getUsingCount()).append("</td>");
            sb.append("<td>").append(tabInfo.getTrunctateCount()).append("</td>");
            sb.append("<td>").append(tabInfo.getDropCount()).append("</td>");
            sb.append("<td>").append(tabInfo.getRecycleRetry()).append("</td>");
            if (tabInfo.getUsingStack() != null) {
                StackTraceElement[] ste = tabInfo.getUsingStack().getStackTrace();
                String str = "";
                for (int j = 2; j < ste.length; ++j) {
                    str = str + ste[j].toString() + "<br/>";
                }
                sb.append("<td>").append(str).append("</td>");
            } else {
                sb.append("<td>&nbsp</td>");
            }
            sb.append("</tr>");
        }
        sb.append("<tr>");
        sb.append("<td colspan=10>").append("Table total count is ").append(tabCount).append(". free total count is ").append(freeCount).append(". used total count is ").append(usedCount).append(". using total count is ").append(usingCount).append(".</td>");
        sb.append("</tr>");
        if (tabCount != 0) {
            sb2.append("<tr>");
            sb2.append("<td colspan=10>").append("Table total count is ").append(tabCount).append(". free total count is ").append(freeCount).append(". used total count is ").append(usedCount).append(". using total count is ").append(usingCount).append(".</td>");
            sb2.append("</tr>");
        }
        sb2.append(sb);
        sb2.append("</TABLE>");
        return sb2.toString();
    }

    public String createDBSystemTempTable(String sql, Connection cn) throws Exception {
        return this.tableManager.createDBSystemTempTable_Session(sql, cn);
    }

    public void releaseDBSystemTempTable(String tableName, Connection cn) throws Exception {
        this.tableManager.releaseDBSystemTempTable(tableName, cn);
    }

    public String createDBSystemTempTableIndex(String tableName, String columns, boolean isUnique, boolean isClustered, Connection cn) throws Exception {
        return this.tableManager.createDBSystemTempTableIndex(tableName, columns, isUnique, isClustered, cn);
    }

    public String getName() {
        return this.tempTablePoolKey + "_TempTablePool";
    }

    public TempTableConfig getConfig() {
        return this.config;
    }

    boolean isTableDropWhenRecycle() {
        if (this.tableManager.isOutMySql() || this.tableManager.isPostgres()) {
            return true;
        }
        if (this.config.tableRecyclePolicy != null && !"default".equalsIgnoreCase(this.config.tableRecyclePolicy)) {
            return this.config.isDrop(this.config.tableRecyclePolicy);
        }
        return this.tableManager.isOracle();
    }

    static {
        if (RWSplitingManager.isRWSplit(null)) {
            RPCConfig.addInvokeMonitor((InvokeMonitor)RepositoryController.instance);
        }
    }

    private class UseableTableManager {
        private Map<String, List<TableInfo>> map = new HashMap<String, List<TableInfo>>();

        private UseableTableManager() {
        }

        public synchronized boolean contains(String fieldDesc) {
            return this.map.containsKey(fieldDesc);
        }

        public synchronized Set fieldSet() {
            return this.map.keySet();
        }

        public synchronized List<TableInfo> getUseableTables(String fieldDesc) {
            List<TableInfo> list = this.map.get(fieldDesc);
            if (list == null) {
                list = new ArrayList<TableInfo>();
                this.map.put(fieldDesc, list);
            } else {
                ArrayList<TableInfo> list2 = new ArrayList<TableInfo>();
                for (TableInfo tableInfo : list) {
                    long l = System.currentTimeMillis() - tableInfo.getCreatedDateTime();
                    if (l <= (long)((TempTablePool)TempTablePool.this).config.usableTimeout) continue;
                    list2.add(tableInfo);
                    tableInfo.setState(8);
                }
                list.removeAll(list2);
            }
            return list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void removeTableInfo(TableInfo tableInfo) {
            if (tableInfo.getTableFields() != null) {
                List<TableInfo> list = this.map.get(tableInfo.getTableFields());
                if (list == null) {
                    list = new ArrayList<TableInfo>();
                    this.map.put(tableInfo.getTableFields(), list);
                }
                List<TableInfo> list2 = list;
                synchronized (list2) {
                    list.remove(tableInfo);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void addTableInfo(TableInfo tableInfo) {
            if (tableInfo.getTableFields() != null) {
                List<TableInfo> list = this.map.get(tableInfo.getTableFields());
                if (list == null) {
                    list = new ArrayList<TableInfo>();
                    this.map.put(tableInfo.getTableFields(), list);
                }
                List<TableInfo> list2 = list;
                synchronized (list2) {
                    list.add(tableInfo);
                    try {
                        list.notify();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

