/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.db;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.db.BatchTruncateResult;
import com.kingdee.bos.db.ITempTableMonitorService;
import com.kingdee.bos.db.TableInfo;
import com.kingdee.bos.db.TableManager;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.util.UUTN;
import com.kingdee.util.db.SQLUtils;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class TempTableUtil {
    private static final Logger logger = Logger.getLogger(TableManager.class);
    private final String ais;
    private final TableManager tableManager;
    public static final String LIKE_EXP_ALL = "'VT%'";
    public static final String LIKE_EXP = "'VT" + UUTN.S_ID + "%'";
    public static final String TEMP_MAPPING_TABLE = "T_KSQL_TM";

    TempTableUtil(TableManager tableManager, String ais) {
        this.tableManager = tableManager;
        this.ais = ais;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTableExists(String tableName) throws SQLException {
        boolean bl;
        String sql = "SELECT top 1 1 FROM " + tableName;
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = TableManager.getConnection(this.ais);
            stmt = conn.createStatement();
            stmt.setQueryTimeout(3);
            stmt.executeQuery(sql);
            bl = true;
        }
        catch (Exception ex0) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(null, stmt, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup(null, (Statement)stmt, (Connection)conn);
            return bl2;
        }
        SQLUtils.cleanup(null, (Statement)stmt, (Connection)conn);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTableEmpty(String tableName) throws SQLException {
        boolean bl;
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        String sql = "select top 1 * from " + tableName;
        try {
            conn = TableManager.getConnection(this.ais);
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            bl = !rs.next();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, stmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cleanTempTable() throws SQLException {
        Connection conn = null;
        Statement stmt = null;
        Statement dropStmt = null;
        int count = 0;
        try {
            conn = TableManager.getConnection(this.ais);
            stmt = conn.createStatement();
            String sql = null;
            sql = this.tableManager.isPostgres() ? "SELECT KSQL_TABNAME FROM KSQL_USERTABLES WHERE UCASE(KSQL_TABNAME) LIKE 'VT" + UUTN.S_ID + "%'" : "SELECT KSQL_TABNAME FROM KSQL_USERTABLES WHERE KSQL_TABNAME LIKE 'VT" + UUTN.S_ID + "%'";
            ResultSet rs = stmt.executeQuery(sql);
            dropStmt = conn.createStatement();
            while (rs.next()) {
                dropStmt.execute("DROP TABLE " + rs.getString(1));
                ++count;
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(dropStmt);
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)dropStmt);
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTempMapping(TableInfo[] tableInfos) throws SQLException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = TableManager.getConnection(this.ais);
            String sql = "insert into T_KSQL_TM values(?,?)";
            stmt = conn.prepareStatement(sql);
            for (int i = 0; i < tableInfos.length; ++i) {
                try {
                    stmt.setString(1, tableInfos[i].tableName);
                    stmt.setString(2, tableInfos[i].tableFields);
                    stmt.executeUpdate();
                    continue;
                }
                catch (SQLException e) {
                    logger.error((Object)("addTempMapping\u5931\u8d25:" + e.getMessage()));
                }
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(stmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    public void removeTempMapping(TableInfo[] tableInfos) throws SQLException {
        String[] tableNames = new String[tableInfos.length];
        for (int i = 0; i < tableInfos.length; ++i) {
            tableNames[i] = tableInfos[i].tableName;
        }
        this.removeTempMapping(tableNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTempMapping(String[] tableNames) throws SQLException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = TableManager.getConnection(this.ais);
            String sql = "DELETE FROM T_KSQL_TM WHERE tabname = ?";
            stmt = conn.prepareStatement(sql);
            for (int i = 0; i < tableNames.length; ++i) {
                try {
                    stmt.setString(1, tableNames[i]);
                    stmt.executeUpdate();
                    continue;
                }
                catch (SQLException e) {
                    logger.error((Object)("removeTempMapping\u5931\u8d25:" + e.getMessage()));
                }
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(stmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanTempMapping(boolean cleanAll) throws SQLException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        StringBuffer deleteSql = new StringBuffer("DELETE FROM T_KSQL_TM WHERE tabname like " + LIKE_EXP);
        String selectSql = null;
        selectSql = this.tableManager.isPostgres() ? "SELECT KSQL_TABNAME FROM KSQL_USERTABLES WHERE UCASE(KSQL_TABNAME) like " + LIKE_EXP : "SELECT KSQL_TABNAME FROM KSQL_USERTABLES WHERE KSQL_TABNAME like " + LIKE_EXP;
        try {
            conn = TableManager.getConnection(this.ais);
            stmt = conn.createStatement();
            if (!cleanAll) {
                rs = stmt.executeQuery(selectSql);
                boolean isFirst = true;
                while (rs.next()) {
                    if (isFirst) {
                        isFirst = false;
                        deleteSql.append(" AND tabname NOT IN('" + rs.getString(1));
                        continue;
                    }
                    deleteSql.append("','" + rs.getString(1));
                }
                if (!isFirst) {
                    deleteSql.append("')");
                }
            }
            stmt.execute(deleteSql.toString());
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, stmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listUselessTempTable(boolean flag) throws SQLException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<String> list = new ArrayList<String>();
        String sql = null;
        sql = this.tableManager.isPostgres() ? "SELECT KSQL_TABNAME FROM KSQL_USERTABLES WHERE ucase(KSQL_TABNAME) LIKE " + LIKE_EXP : "SELECT KSQL_TABNAME FROM KSQL_USERTABLES WHERE KSQL_TABNAME LIKE " + LIKE_EXP;
        try {
            conn = TableManager.getConnection(this.ais);
            if (flag) {
                String subSql = "SELECT tabname FROM T_KSQL_TM WHERE tabname LIKE " + LIKE_EXP;
                stmt = conn.createStatement();
                rs = stmt.executeQuery(subSql);
                boolean first = true;
                while (rs.next()) {
                    if (first) {
                        sql = this.tableManager.isPostgres() ? sql + " AND UCASE(KSQL_TABNAME) NOT IN('" + rs.getString(1) : sql + " AND KSQL_TABNAME NOT IN('" + rs.getString(1);
                        first = false;
                        continue;
                    }
                    sql = sql + "','" + rs.getString(1);
                }
                if (!first) {
                    sql = sql + "')";
                }
                rs.close();
                stmt.close();
            }
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql.toString());
            while (rs.next()) {
                list.add(rs.getString(1));
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, stmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return list.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listUselessTempTableAll(boolean flag) throws SQLException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<String> list = new ArrayList<String>();
        String sql = null;
        sql = this.tableManager.isPostgres() ? "SELECT KSQL_TABNAME FROM KSQL_USERTABLES WHERE ucase(KSQL_TABNAME) LIKE 'VT%'" : "SELECT KSQL_TABNAME FROM KSQL_USERTABLES WHERE KSQL_TABNAME LIKE 'VT%'";
        try {
            conn = TableManager.getConnection(this.ais);
            if (flag) {
                String subSql = "SELECT tabname FROM T_KSQL_TM WHERE tabname LIKE 'VT%'";
                stmt = conn.createStatement();
                rs = stmt.executeQuery(subSql);
                boolean first = true;
                while (rs.next()) {
                    if (first) {
                        sql = this.tableManager.isPostgres() ? sql + " AND ucase(KSQL_TABNAME) NOT IN('" + rs.getString(1) : sql + " AND KSQL_TABNAME NOT IN('" + rs.getString(1);
                        first = false;
                        continue;
                    }
                    sql = sql + "','" + rs.getString(1);
                }
                if (!first) {
                    sql = sql + "')";
                }
                rs.close();
                stmt.close();
            }
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql.toString());
            while (rs.next()) {
                list.add(rs.getString(1));
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, stmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return list.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listTimeoutTempTableAll_Postgres(int timeout) throws SQLException {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<String> list = new ArrayList<String>();
        String sql = "SELECT KSQL_TABNAME FROM KSQL_USERTABLES WHERE  (UCASE(KSQL_TABNAME) LIKE 'VT%' OR UCASE(KSQL_TABNAME) LIKE 'GZT%')";
        try {
            conn = TableManager.getConnection(this.ais);
            ps = conn.prepareStatement(sql);
            rs = ps.executeQuery();
            String table = null;
            long time = -1L;
            long currentTime = System.currentTimeMillis();
            while (rs.next()) {
                table = rs.getString(1);
                String[] parts = table.split("_");
                if (parts.length != 2) continue;
                try {
                    time = Long.parseLong(parts[1]);
                    if (currentTime - time <= (long)timeout) continue;
                    list.add(parts[0]);
                }
                catch (Throwable t) {}
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, ps, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return list.toArray(new String[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listTimeoutTempTableAll(int timeout) throws SQLException {
        if (this.tableManager.isPostgres()) {
            return this.listTimeoutTempTableAll_Postgres(timeout);
        }
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<String> list = new ArrayList<String>();
        String sql = "SELECT KSQL_TABNAME FROM KSQL_USERTABLES WHERE KSQL_CREATETIME<? And (KSQL_TABNAME LIKE 'VT%' OR KSQL_TABNAME LIKE 'GZT%')";
        try {
            conn = TableManager.getConnection(this.ais);
            ps = conn.prepareStatement(sql.toString());
            Timestamp ts = new Timestamp(System.currentTimeMillis() - (long)timeout);
            ps.setTimestamp(1, ts);
            rs = ps.executeQuery();
            while (rs.next()) {
                list.add(rs.getString(1));
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, ps, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return list.toArray(new String[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeSQL(String sql) throws SQLException {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = TableManager.getConnection(this.ais);
            stmt = conn.createStatement();
            stmt.execute(sql);
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(stmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getTempTableMapping(int count, boolean delete) throws SQLException {
        ArrayList<Object[]> result;
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block17: {
            conn = null;
            stmt = null;
            rs = null;
            result = new ArrayList<Object[]>();
            ArrayList<String> dropTableList = new ArrayList<String>();
            ArrayList<String> deleteRowsList = new ArrayList<String>();
            String sql1 = "select ksql_tabname,KSQL_CREATETIME from KSQL_USERTABLES where ksql_tabname like " + LIKE_EXP;
            String sql2 = "SELECT tabname, fields from T_KSQL_TM WHERE tabname like " + LIKE_EXP;
            try {
                String a;
                conn = TableManager.getConnection(this.ais);
                stmt = conn.prepareStatement(sql1);
                rs = stmt.executeQuery();
                HashSet<String> allnames = new HashSet<String>();
                HashMap<String, Timestamp> nameCreateTime = new HashMap<String, Timestamp>();
                while (rs.next()) {
                    String name = rs.getString(1);
                    Timestamp ts = rs.getTimestamp(2);
                    allnames.add(name);
                    nameCreateTime.put(name, ts);
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, null);
                stmt = conn.prepareStatement(sql2);
                rs = stmt.executeQuery();
                int index = 0;
                boolean nonext = false;
                while (index < count) {
                    if (!rs.next()) {
                        nonext = true;
                        break;
                    }
                    a = rs.getString(1);
                    String b = rs.getString(2);
                    if (allnames.contains(a)) {
                        allnames.remove(a);
                        result.add(new Object[]{a, b, nameCreateTime.get(a)});
                        ++index;
                        continue;
                    }
                    deleteRowsList.add(a);
                }
                if (!nonext) {
                    while (rs.next()) {
                        a = rs.getString(1);
                        if (allnames.contains(a)) {
                            allnames.remove(a);
                            dropTableList.add(a);
                            deleteRowsList.add(a);
                            continue;
                        }
                        deleteRowsList.add(a);
                    }
                }
                dropTableList.addAll(allnames);
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, null);
                if (!delete) break block17;
                String[] names = new String[dropTableList.size()];
                dropTableList.toArray(names);
                for (int i = 0; i < names.length; ++i) {
                    try {
                        stmt = conn.prepareStatement("drop table " + names[i]);
                        stmt.executeUpdate();
                        continue;
                    }
                    catch (SQLException e) {
                        logger.warn((Object)("Error when drop table " + names[i]));
                        continue;
                    }
                    finally {
                        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, null);
                    }
                }
                if (deleteRowsList.size() > 0) {
                    names = new String[deleteRowsList.size()];
                    deleteRowsList.toArray(names);
                    String sql = "delete from T_KSQL_TM where tabname=?";
                    stmt = conn.prepareStatement(sql);
                    for (int i = 0; i < names.length; ++i) {
                        stmt.setString(1, names[i]);
                        stmt.addBatch();
                    }
                    stmt.executeBatch();
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BatchTruncateResult batchTruncateTable2(String[] names) throws SQLException {
        BatchTruncateResult batchTruncateResult;
        String sql = "truncate table ";
        Connection conn = null;
        Statement stmt = null;
        ArrayList<String> sList = new ArrayList<String>();
        ArrayList<String> fList = new ArrayList<String>();
        try {
            conn = TableManager.getConnection(this.ais);
            stmt = conn.createStatement();
            stmt.setQueryTimeout(1);
            for (int i = 0; i < names.length; ++i) {
                try {
                    stmt.executeUpdate("truncate table " + names[i]);
                    sList.add(names[i]);
                    continue;
                }
                catch (Exception ex) {
                    fList.add(names[i]);
                    logger.warn((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            batchTruncateResult = new BatchTruncateResult(sList.toArray(new String[0]), fList.toArray(new String[0]), new String[0]);
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(null, stmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup(null, (Statement)stmt, (Connection)conn);
        return batchTruncateResult;
    }

    public BatchTruncateResult batchTruncateTable(String[] names) throws SQLException {
        return this.batchTruncateTable(names, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BatchTruncateResult batchTruncateTable(String[] names, boolean isUseBatch) throws SQLException {
        BatchTruncateResult batchTruncateResult;
        String sql = "truncate table ";
        Connection conn = null;
        Statement stmt = null;
        int queryTimeOut = 0;
        boolean isDb2 = false;
        if (isUseBatch) {
            conn = TableManager.getConnection(this.ais);
            int dbType = KSqlUtil.getDbType((Connection)conn);
            if (dbType == 1 || dbType == 9) {
                isDb2 = true;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Release temp table : is db2? " + isDb2));
            }
            try {
                String tempSql;
                int i;
                stmt = conn.createStatement();
                queryTimeOut = stmt.getQueryTimeout();
                stmt.setQueryTimeout(3);
                if (isDb2) {
                    for (i = 0; i < names.length; ++i) {
                        tempSql = "/*dialect*/ALTER TABLE " + names[i] + " ACTIVATE NOT LOGGED INITIALLY WITH EMPTY TABLE";
                        stmt.addBatch(tempSql);
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("Release temp table sql: " + tempSql));
                    }
                } else {
                    for (i = 0; i < names.length; ++i) {
                        tempSql = "truncate table " + names[i];
                        stmt.addBatch(tempSql);
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("Release temp table sql: " + tempSql));
                    }
                }
                int[] rs = null;
                try {
                    rs = stmt.executeBatch();
                }
                catch (BatchUpdateException be) {
                    logger.warn((Object)(this.ais + " :Batch Truncat Table failed"));
                    rs = be.getUpdateCounts();
                }
                if (rs.length == names.length) {
                    ArrayList<String> sList = new ArrayList<String>();
                    ArrayList<String> fList = new ArrayList<String>();
                    for (int i2 = 0; i2 < rs.length; ++i2) {
                        if (rs[i2] >= 0 || rs[i2] == -2) {
                            sList.add(names[i2]);
                            continue;
                        }
                        fList.add(names[i2]);
                    }
                    BatchTruncateResult i2 = new BatchTruncateResult(sList.toArray(new String[0]), fList.toArray(new String[0]), new String[0]);
                    return i2;
                }
                String[] sNames = new String[rs.length];
                for (int i3 = 0; i3 < rs.length; ++i3) {
                    sNames[i3] = names[i3];
                }
                String[] fNames = new String[]{names[rs.length]};
                String[] uNames = new String[names.length - rs.length - 1];
                for (int i4 = 0; i4 < uNames.length; ++i4) {
                    uNames[i4] = names[i4 + rs.length + 1];
                }
                BatchTruncateResult batchTruncateResult2 = new BatchTruncateResult(sNames, fNames, uNames);
                return batchTruncateResult2;
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.setQueryTimeout(queryTimeOut);
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
                SQLUtils.cleanup(null, (Statement)stmt, (Connection)conn);
            }
        }
        try {
            conn = TableManager.getConnection(this.ais);
            int dbType = KSqlUtil.getDbType((Connection)conn);
            if (dbType == 1 || dbType == 9) {
                isDb2 = true;
            }
            ArrayList<String> sList = new ArrayList<String>();
            ArrayList<String> fList = new ArrayList<String>();
            for (int i = 0; i < names.length; ++i) {
                try {
                    String tempSql;
                    stmt = conn.createStatement();
                    queryTimeOut = stmt.getQueryTimeout();
                    stmt.setQueryTimeout(1);
                    if (isDb2) {
                        tempSql = "/*dialect*/ALTER TABLE " + names[i] + " ACTIVATE NOT LOGGED INITIALLY WITH EMPTY TABLE";
                        stmt.execute(tempSql);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Release temp table sql: " + tempSql));
                        }
                    } else {
                        tempSql = "truncate table " + names[i];
                        stmt.execute(tempSql);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Release temp table sql: " + tempSql));
                        }
                    }
                    sList.add(names[i]);
                    continue;
                }
                catch (Exception ex) {
                    fList.add(names[i]);
                    continue;
                }
                finally {
                    try {
                        if (stmt != null) {
                            stmt.setQueryTimeout(queryTimeOut);
                        }
                    }
                    catch (Exception ex2) {}
                    SQLUtils.cleanup((Statement)stmt);
                }
            }
            batchTruncateResult = new BatchTruncateResult(sList.toArray(new String[0]), fList.toArray(new String[0]), new String[0]);
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(null, stmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup(null, (Statement)stmt, (Connection)conn);
        return batchTruncateResult;
    }

    public static final void releaseTempTable(String tabName) throws BOSException {
        ITempTableMonitorService ittms = null;
        ittms = (ITempTableMonitorService)BOSObjectFactory.createRemoteBOSObject((String)"com.kingdee.bos.db.TempTableMonitorSerivce", ITempTableMonitorService.class);
        if (ittms != null) {
            ittms.releaseTable(tabName);
        }
    }
}

