/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.db;

import com.kingdee.bos.db.AddMappingWorker;
import com.kingdee.bos.db.LifeCycleable;
import com.kingdee.bos.db.NativeTimeoutRunnable;
import com.kingdee.bos.db.OutMySqlTableManager;
import com.kingdee.bos.db.RemoveMappingWorker;
import com.kingdee.bos.db.SwitchPolicyRunnable;
import com.kingdee.bos.db.TableInfo;
import com.kingdee.bos.db.TableManager;
import com.kingdee.bos.db.TempTableConfig;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.db.ToDeleteWorker;
import com.kingdee.bos.db.ToRecycleWorker;
import com.kingdee.bos.db.Touchable;
import com.kingdee.bos.db.UsableTimeoutWorker;
import com.kingdee.bos.db.UsingTimeoutWorker;
import com.kingdee.bos.db.Worker;
import com.kingdee.bos.util.backport.concurrent.Executors;
import com.kingdee.bos.util.backport.concurrent.ThreadPoolExecutor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ThreadAndRecycleManager
extends Thread {
    public static final Logger logger = Logger.getLogger(ThreadAndRecycleManager.class);
    private TempTablePool pool;
    private TableManager tableManager;
    private TempTableConfig config;
    public static ThreadPoolExecutor threadPool;
    private long lastTouchTime_UsingTimeout = -1L;
    private long lastTouchTime_UsableTimeout = -1L;
    private long lastTouchTime_ToRecycle = -1L;
    private long lastTouchTime_ToDelete = -1L;
    private long lastTouchTime_RemoveMapping = -1L;
    private long lastTouchTime_AddMapping = -1L;
    private long lastTouchTime_NativeTimeout = -1L;
    private long lastTouchTime_SwitchPolicyRunnable = -1L;
    private UsableTimeoutWorker instanceUsableTimeoutWorker = null;
    private UsingTimeoutWorker instanceUsingTimeoutWorker = null;
    private ToRecycleWorker instanceToRecycleWorker = null;
    private ToDeleteWorker instanceToDeleteWorker = null;
    private AddMappingWorker instanceAddMappingWorker = null;
    private RemoveMappingWorker instanceRemoveMappingWorker = null;
    private NativeTimeoutRunnable nativeTimeoutRunnable = null;
    private Runnable switchPolicyRunnable = null;

    ThreadAndRecycleManager(TempTablePool pool, int threadCount, LifeCycleable lifeCycleable) {
        this.pool = pool;
        this.tableManager = pool.getTableManager();
        this.config = pool.getConfig();
        if (this.tableManager.isOutMySql()) {
            this.nativeTimeoutRunnable = ((OutMySqlTableManager)this.tableManager).getNativeTimeoutRunnable(this.config.nativeTimeout);
        }
        if (pool.isTableDropWhenRecycle()) {
            this.switchPolicyRunnable = new SwitchPolicyRunnable(pool);
        }
        this.setName("Temp Table Thread And Recycle Manager for " + pool.getAis());
        this.instanceAddMappingWorker = new AddMappingWorker();
        this.instanceAddMappingWorker.setLifeCycleable(lifeCycleable);
        this.instanceAddMappingWorker.setToucher(new Touchable(){

            @Override
            public void touch() {
                ThreadAndRecycleManager.this.lastTouchTime_AddMapping = System.currentTimeMillis();
            }
        });
        this.instanceRemoveMappingWorker = new RemoveMappingWorker();
        this.instanceRemoveMappingWorker.setLifeCycleable(lifeCycleable);
        this.instanceRemoveMappingWorker.setToucher(new Touchable(){

            @Override
            public void touch() {
                ThreadAndRecycleManager.this.lastTouchTime_RemoveMapping = System.currentTimeMillis();
            }
        });
        this.instanceToDeleteWorker = new ToDeleteWorker();
        this.instanceToDeleteWorker.setLifeCycleable(lifeCycleable);
        this.instanceToDeleteWorker.setToucher(new Touchable(){

            @Override
            public void touch() {
                ThreadAndRecycleManager.this.lastTouchTime_ToDelete = System.currentTimeMillis();
            }
        });
        this.instanceToRecycleWorker = new ToRecycleWorker();
        this.instanceToRecycleWorker.setLifeCycleable(lifeCycleable);
        this.instanceToRecycleWorker.setToucher(new Touchable(){

            @Override
            public void touch() {
                ThreadAndRecycleManager.this.lastTouchTime_ToRecycle = System.currentTimeMillis();
            }
        });
        this.instanceUsableTimeoutWorker = new UsableTimeoutWorker();
        this.instanceUsableTimeoutWorker.setLifeCycleable(lifeCycleable);
        this.instanceUsableTimeoutWorker.setToucher(new Touchable(){

            @Override
            public void touch() {
                ThreadAndRecycleManager.this.lastTouchTime_UsableTimeout = System.currentTimeMillis();
            }
        });
        this.instanceUsingTimeoutWorker = new UsingTimeoutWorker();
        this.instanceUsingTimeoutWorker.setLifeCycleable(lifeCycleable);
        this.instanceUsingTimeoutWorker.setToucher(new Touchable(){

            @Override
            public void touch() {
                ThreadAndRecycleManager.this.lastTouchTime_UsingTimeout = System.currentTimeMillis();
            }
        });
        if (threadPool == null) {
            threadPool = (ThreadPoolExecutor)Executors.newFixedThreadPool((int)threadCount);
        } else {
            threadPool.setMaximumPoolSize((int)((double)threadPool.getMaximumPoolSize() * 1.5));
        }
    }

    @Override
    public void run() {
        while (true) {
            long endTime;
            long dure;
            long startTime = System.currentTimeMillis();
            try {
                this.doit();
            }
            catch (Throwable t) {
                logger.error((Object)t.getMessage());
                t.printStackTrace();
            }
            if (this.nativeTimeoutRunnable != null) {
                try {
                    this.doNativeTimeout();
                }
                catch (Throwable t) {
                    logger.error((Object)t.getMessage());
                    t.printStackTrace();
                }
            }
            if ((dure = (endTime = System.currentTimeMillis()) - startTime) >= (long)this.config.mainLoopTime) continue;
            try {
                ThreadAndRecycleManager.sleep((long)this.config.mainLoopTime - dure);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void doNativeTimeout() {
        if (this.nativeTimeoutRunnable.hasPrivileges() && System.currentTimeMillis() - this.lastTouchTime_NativeTimeout > (long)this.config.nativeTimeoutLoopTime) {
            this.lastTouchTime_NativeTimeout = System.currentTimeMillis();
            threadPool.execute((Runnable)this.nativeTimeoutRunnable);
        }
    }

    private void doSwitchPolicyRunnable() {
        if (System.currentTimeMillis() - this.lastTouchTime_SwitchPolicyRunnable > (long)this.config.switchPolicyRunnableLoopTime) {
            this.lastTouchTime_SwitchPolicyRunnable = System.currentTimeMillis();
            threadPool.execute(this.switchPolicyRunnable);
        }
    }

    private void setUsing(TableInfo info) {
        info.setState(1);
        info.incUsingCount();
        info.usingStack = new Throwable("Using Table");
    }

    private Map getRunInfos() {
        boolean doUsingTimeout;
        boolean doUsableTimeout;
        boolean doToRecycle;
        boolean doToDelete;
        HashMap<String, TableInfo[]> result = new HashMap<String, TableInfo[]>();
        ArrayList<TableInfo> tableInfos = new ArrayList<TableInfo>();
        tableInfos.addAll(this.pool.getTableManager().tableMap.values());
        ArrayList<TableInfo> toDeleteList = null;
        ArrayList<TableInfo> toRecycleList = null;
        ArrayList<TableInfo> usableList = null;
        ArrayList<TableInfo> usingList = null;
        boolean bl = doToDelete = System.currentTimeMillis() - this.lastTouchTime_ToDelete > (long)this.config.deleteLoopTime;
        if (doToDelete) {
            toDeleteList = new ArrayList<TableInfo>();
        }
        boolean bl2 = doToRecycle = System.currentTimeMillis() - this.lastTouchTime_ToRecycle > (long)this.config.recycleLoopTime;
        if (doToRecycle) {
            toRecycleList = new ArrayList<TableInfo>();
        }
        boolean bl3 = doUsableTimeout = System.currentTimeMillis() - this.lastTouchTime_UsableTimeout > (long)this.config.usableTimeoutLoopTime;
        if (doUsableTimeout) {
            usableList = new ArrayList<TableInfo>();
        }
        boolean bl4 = doUsingTimeout = System.currentTimeMillis() - this.lastTouchTime_UsingTimeout > (long)this.config.usingTimeoutLoopTime;
        if (doUsingTimeout) {
            usingList = new ArrayList<TableInfo>();
        }
        boolean doRemoveMapping = System.currentTimeMillis() - this.lastTouchTime_RemoveMapping > (long)this.config.removeMappingLoopTime;
        boolean doAddMapping = System.currentTimeMillis() - this.lastTouchTime_AddMapping > (long)this.config.addMappingLoopTime;
        for (TableInfo tableInfo : tableInfos) {
            int state = tableInfo.getState();
            if (state == 0) {
                if (!doUsableTimeout) continue;
                usableList.add(tableInfo);
                continue;
            }
            if (state == 8) {
                if (!doToDelete) continue;
                toDeleteList.add(tableInfo);
                continue;
            }
            if (state == 4) {
                if (!doToRecycle) continue;
                toRecycleList.add(tableInfo);
                continue;
            }
            if (state == 1) {
                if (!doUsingTimeout) continue;
                usingList.add(tableInfo);
                continue;
            }
            if (state != 0 || !doUsingTimeout) continue;
            this.setUsing(tableInfo);
            usingList.add(tableInfo);
        }
        if (doToDelete && toDeleteList.size() > 0) {
            result.put("KEY_TODELETE", toDeleteList.toArray(new TableInfo[toDeleteList.size()]));
        }
        if (doToRecycle && toRecycleList.size() > 0) {
            result.put("KEY_TORECYCLE", toRecycleList.toArray(new TableInfo[toRecycleList.size()]));
        }
        if (doUsingTimeout && usingList.size() > 0) {
            result.put("KEY_USINGTIMEOUT", usingList.toArray(new TableInfo[usingList.size()]));
        }
        if (doUsableTimeout && (tableInfos.size() >= this.config.maxSize || usableList.size() > 5000)) {
            result.put("KEY_USABLETIMEOUT", usableList.toArray(new TableInfo[usableList.size()]));
        }
        if (!this.pool.isTableDropWhenRecycle()) {
            if (doAddMapping && this.pool.memMappingInfoToAdd.size() > 0) {
                result.put("KEY_ADDMAPPING", this.pool.memMappingInfoToAdd.toArray(new TableInfo[this.pool.memMappingInfoToAdd.size()]));
                this.pool.memMappingInfoToAdd.clear();
            }
            if (doRemoveMapping && this.pool.memMappingInfoToRemove.size() > 0) {
                result.put("KEY_REMOVEMAPPING", this.pool.memMappingInfoToRemove.toArray(new TableInfo[this.pool.memMappingInfoToRemove.size()]));
                this.pool.memMappingInfoToRemove.clear();
            }
        }
        return result;
    }

    private void doit() {
        Worker worker;
        Map runInfos = this.getRunInfos();
        if (runInfos.isEmpty()) {
            return;
        }
        TableInfo[] tableInfos = (TableInfo[])runInfos.get("KEY_TORECYCLE");
        if (tableInfos != null && !(worker = this.instanceToRecycleWorker).isRunning()) {
            ((ToRecycleWorker)worker).running = true;
            worker.setTableInfos(tableInfos);
            worker.setTempTablePool(this.pool);
            threadPool.execute((Runnable)worker);
        }
        if ((tableInfos = (TableInfo[])runInfos.get("KEY_TODELETE")) != null) {
            worker = this.instanceToDeleteWorker;
            if (!worker.isRunning()) {
                ((ToDeleteWorker)worker).running = true;
                logger.debug((Object)"Delete Worker is available.");
                worker.setTableInfos(tableInfos);
                worker.setTempTablePool(this.pool);
                threadPool.execute((Runnable)worker);
            } else {
                logger.debug((Object)"Delete Worker is not available.");
            }
        }
        if ((tableInfos = (TableInfo[])runInfos.get("KEY_USABLETIMEOUT")) != null && !(worker = this.instanceUsableTimeoutWorker).isRunning()) {
            ((UsableTimeoutWorker)worker).running = true;
            worker.setTableInfos(tableInfos);
            worker.setTempTablePool(this.pool);
            threadPool.execute((Runnable)worker);
        }
        if ((tableInfos = (TableInfo[])runInfos.get("KEY_USINGTIMEOUT")) != null && !(worker = this.instanceUsingTimeoutWorker).isRunning()) {
            ((UsingTimeoutWorker)worker).running = true;
            worker.setTableInfos(tableInfos);
            worker.setTempTablePool(this.pool);
            threadPool.execute((Runnable)worker);
        }
        if ((tableInfos = (TableInfo[])runInfos.get("KEY_ADDMAPPING")) != null && !(worker = this.instanceAddMappingWorker).isRunning()) {
            ((AddMappingWorker)worker).running = true;
            worker.setTableInfos(tableInfos);
            worker.setTempTablePool(this.pool);
            threadPool.execute((Runnable)worker);
        }
        if ((tableInfos = (TableInfo[])runInfos.get("KEY_REMOVEMAPPING")) != null && !(worker = this.instanceRemoveMappingWorker).isRunning()) {
            ((RemoveMappingWorker)worker).running = true;
            worker.setTableInfos(tableInfos);
            worker.setTempTablePool(this.pool);
            threadPool.execute((Runnable)worker);
        }
    }
}

