/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.db;

import com.kingdee.bos.db.TableInfo;
import com.kingdee.bos.db.TableManager;
import com.kingdee.bos.db.ThreadAndRecycleManager;
import com.kingdee.bos.db.Worker;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

class ToDeleteWorker
extends Worker {
    private static Logger logger = ThreadAndRecycleManager.logger;

    ToDeleteWorker() {
    }

    @Override
    public void call() {
        logger.debug((Object)"Begin Delete Table...");
        TableManager tableManager = this.pool.getTableManager();
        ArrayList<TableInfo> listInfos = new ArrayList<TableInfo>();
        for (int i = 0; i < this.tableInfos.length; ++i) {
            TableInfo info = this.tableInfos[i];
            if (info.getState() != 8) continue;
            listInfos.add(info);
        }
        List<TableInfo> failList = tableManager.dropTableBatch(listInfos);
        listInfos.removeAll(failList);
        for (TableInfo tableInfo : listInfos) {
            tableManager.removeTableInfo(tableInfo.tableName);
            this.pool.removeTempMapping(tableInfo);
            this.lifeCycleable.deleteSucceed(tableInfo);
        }
        for (TableInfo tableInfo : failList) {
            tableInfo.incDeleteTryTime();
            if (tableInfo.getDeleteTryTime() > 2) {
                tableManager.removeTableInfo(tableInfo.tableName);
                this.pool.removeTempMapping(tableInfo);
                this.lifeCycleable.deleteAbandoned(tableInfo);
                continue;
            }
            this.lifeCycleable.deleteFailed(tableInfo);
        }
        logger.debug((Object)"End Delete Table...");
    }
}

