/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.db;

import com.kingdee.bos.db.BatchTruncateResult;
import com.kingdee.bos.db.TableInfo;
import com.kingdee.bos.db.TableManager;
import com.kingdee.bos.db.ThreadAndRecycleManager;
import com.kingdee.bos.db.Worker;
import java.util.ArrayList;
import java.util.HashMap;

class ToRecycleWorker
extends Worker {
    ToRecycleWorker() {
    }

    @Override
    public void call() {
        String ais = this.pool.getAis();
        TableManager tableManager = this.pool.getTableManager();
        HashMap<String, TableInfo> mapInfos = new HashMap<String, TableInfo>(this.tableInfos.length);
        ArrayList<TableInfo> listInfos = new ArrayList<TableInfo>(this.tableInfos.length);
        ArrayList<String> names = new ArrayList<String>(this.tableInfos.length);
        long actionTime = System.currentTimeMillis();
        for (int i = 0; i < this.tableInfos.length; ++i) {
            TableInfo info = this.tableInfos[i];
            if (info.getState() != 4) continue;
            mapInfos.put(info.tableName, info);
            listInfos.add(info);
            names.add(info.tableName);
        }
        BatchTruncateResult result = null;
        long costTime = System.currentTimeMillis();
        try {
            result = tableManager.batchTruncateTable(names, true);
            costTime = System.currentTimeMillis() - costTime;
        }
        catch (Exception ex) {
            ThreadAndRecycleManager.logger.warn((Object)(ais + ":Batch Truncate Error, request again. " + ex.getMessage()));
        }
        if (result != null) {
            TableInfo info;
            int i;
            for (i = 0; i < result.succNames.length; ++i) {
                info = (TableInfo)mapInfos.get(result.succNames[i]);
                info.setState(0);
                info.resetRecycleRetry();
                this.lifeCycleable.recycleSucceed(info);
            }
            for (i = 0; i < result.faildNames.length; ++i) {
                info = (TableInfo)mapInfos.get(result.faildNames[i]);
                info.incRecycleRetry();
                if (info.getRecycleRetry() > 1) {
                    info.setState(8);
                    this.lifeCycleable.recycleAbandoned(info);
                    continue;
                }
                this.lifeCycleable.recycleFailed(info);
            }
            if (ThreadAndRecycleManager.logger.isDebugEnabled()) {
                ThreadAndRecycleManager.logger.debug((Object)(ais + ":Batch truncate Complete, Total: " + names.size() + ", Cost:" + (System.currentTimeMillis() - actionTime) + ", Execute Cost:" + costTime + ", successful:" + result.succNames.length + ", faild:" + result.faildNames.length + ", unsettled:" + result.unsettledNames.length));
                StringBuffer namestr = new StringBuffer("");
                for (int i2 = 0; i2 < result.faildNames.length; ++i2) {
                    namestr.append(", ").append(result.faildNames[i2]);
                }
                if (namestr.length() > 0) {
                    ThreadAndRecycleManager.logger.debug((Object)(ais + ": Batch truncate faild tables:" + namestr.substring(1)));
                }
            }
        }
    }
}

