/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework;

import com.kingdee.bos.framework.PluginMethodProvider;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.util.XMLParser;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;

public class PluginMethodProviderManager {
    private static Logger logger = Logger.getLogger(PluginMethodProviderManager.class);
    private static PluginMethodProvider provider;

    private static void init() {
        block13: {
            String configPath = System.getProperty("DynamicConfig.path");
            if (StringUtils.isEmpty((String)configPath)) {
                String home = System.getProperty("EAS_HOME");
                configPath = ConfigMDUtil.isClient() ? home + "/client/deploy/client/" + "DynamicConfig.xml" : home + "/server/properties/" + "DynamicConfig.xml";
            }
            if (new File(configPath).exists()) {
                try {
                    Document doc = XMLParser.parseXML((InputStream)new FileInputStream(configPath));
                    Element root = doc.getRootElement();
                    List cis = root.getChildren("configitem", root.getNamespace());
                    if (cis == null || cis.size() <= 0) break block13;
                    for (int i = 0; i < cis.size(); ++i) {
                        Element ci = (Element)cis.get(i);
                        String name = ci.getAttributeValue("name");
                        if (!"pluginMethodProvider".equals(name)) continue;
                        Element att = ci.getChild("attribute", root.getNamespace());
                        if (att == null) break;
                        String className = att.getAttributeValue("value");
                        try {
                            Class<?> c = Class.forName(className);
                            PluginMethodProvider lis = (PluginMethodProvider)c.newInstance();
                            if (provider == null) {
                                provider = lis;
                            }
                        }
                        catch (Exception e) {
                            logger.error((Object)e, (Throwable)e);
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)e, (Throwable)e);
                }
            }
        }
        if (provider != null) {
            return;
        }
        Configuration config = Configuration.getInstance();
        ConfigurationItem ci = config.getConfigItem("pluginMethodProvider");
        if (ci == null) {
            return;
        }
        Map map = ci.getProperties();
        for (String className : map.values()) {
            try {
                Class<?> c = Class.forName(className);
                PluginMethodProvider lis = (PluginMethodProvider)c.newInstance();
                if (provider != null) continue;
                provider = lis;
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    public static void setProvider(PluginMethodProvider pp) {
        provider = pp;
    }

    public static PluginMethodProvider getProvider() {
        return provider;
    }

    static {
        try {
            PluginMethodProviderManager.init();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }
}

