/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.agent;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.Utils;
import com.kingdee.bos.dao.ormapping.lazyload.IObjectValueLazyLoader;
import com.kingdee.bos.dao.ormapping.lazyload.ObjectValueLazyLoaderFactory;
import com.kingdee.bos.framework.agent.AgentContainerFactory;
import com.kingdee.bos.framework.agent.AgentManager;
import com.kingdee.bos.framework.agent.AgentState;
import com.kingdee.bos.framework.agent.IObjectCollectionAgent;
import com.kingdee.bos.framework.agent.IObjectValueAgent;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.ObjectUtils;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AgentUtility {
    private static final Logger logger = Logger.getLogger(AgentUtility.class);

    public static IObjectValueAgent createAgent(IObjectValue ov) {
        return null;
    }

    public static IObjectValue createInfo(IObjectValueAgent agent) {
        return null;
    }

    public static IObjectValueAgent copyAgent(IObjectValueAgent agent) {
        IObjectValueAgent retAgent = null;
        AbstractObjectValue sourceInfo = (AbstractObjectValue)agent.getInfoInstance();
        Class<?> agentClass = agent.getClass();
        try {
            if (sourceInfo != null) {
                sourceInfo = (AbstractObjectValue)sourceInfo.clone();
                Method m = agentClass.getMethod("copyOvToAgent", IObjectValue.class);
                retAgent = (IObjectValueAgent)m.invoke(null, sourceInfo);
            } else {
                Method m = agentClass.getMethod("create", new Class[0]);
                retAgent = (IObjectValueAgent)m.invoke(null, new Object[0]);
            }
        }
        catch (Exception e) {
            logger.error((Object)"copyOvToAgent invoke failed.", (Throwable)e);
        }
        return retAgent;
    }

    public static IObjectValueAgent createAgentWithId(IObjectValueAgent agent) {
        AbstractObjectValue ov = null;
        AbstractObjectValue agentOv = (AbstractObjectValue)agent;
        Class<?> agentClass = agent.getClass();
        try {
            Method m = agentClass.getMethod("create", null);
            ov = (AbstractObjectValue)m.invoke(null, null);
            ov.put(agentOv.getPKField(), agentOv.get(agentOv.getPKField()));
            ((IObjectValueAgent)ov).setAgentState(agent.getAgentState());
        }
        catch (Exception e) {
            logger.error((Object)("Agent [" + agent + "]" + " creating failed!"), (Throwable)e);
        }
        return (IObjectValueAgent)ov;
    }

    public static IObjectValueAgent loadAgent(IObjectValueAgent ov) {
        if (AgentContainerFactory.isRemote() && AgentState.INIT == ov.getAgentState()) {
            Context context = ContextUtils.getContextFromSession();
            try {
                AbstractObjectValue obj = (AbstractObjectValue)ov;
                IObjectValueLazyLoader loader = ObjectValueLazyLoaderFactory.getLocalInstance(context);
                loader.fillValue((IObjectValue)obj);
                Method method = ov.getClass().getMethod("copyOvToAgent", IObjectValue.class);
                return (IObjectValueAgent)method.invoke(null, ov);
            }
            catch (Exception e) {
                logger.error((Object)("Agent [" + ov + "] loading" + "] failed!"), (Throwable)e);
                return ov;
            }
        }
        return ov;
    }

    public static void loadAgents(List agents, IObjectCollection retCollection) {
        if (agents == null || agents.isEmpty()) {
            return;
        }
        BOSObjectType type = ((IObjectValue)agents.get(0)).getBOSType();
        if (type == null) {
            throw new IllegalArgumentException("Unknown BOSType.");
        }
        EntityObjectInfo entity = null;
        Context context = null;
        if (AgentContainerFactory.isRemote()) {
            context = ContextUtils.getContextFromSession();
            entity = MetaDataLoaderFactory.getMetaDataLoader((Context)context).getEntity(type);
        } else {
            entity = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(type);
        }
        IObjectValueAgent agent2 = null;
        IObjectValue obj2 = null;
        IObjectPK pk = null;
        StringBuffer buffer = new StringBuffer();
        StringBuffer oqlBuffer = new StringBuffer();
        int filteItemIndex = 0;
        int initAgnentNum = 0;
        int agentSize = agents.size();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(new FilterInfo());
        Object[] agentBulk = new Object[agentSize];
        HashMap<IObjectPK, Integer> pkIndexMap = new HashMap<IObjectPK, Integer>();
        int cusor = -1;
        for (IObjectValueAgent agent2 : agents) {
            obj2 = (IObjectValue)agent2;
            ++cusor;
            if (!AgentContainerFactory.isRemote() || AgentState.INIT != agent2.getAgentState()) {
                agentBulk[cusor] = obj2;
                continue;
            }
            if (!type.equals((Object)obj2.getBOSType())) {
                logger.error((Object)("Contain different Type Agent:" + type.toString() + " and " + obj2.getBOSType()));
                throw new IllegalArgumentException("Agents contains different type Agent!");
            }
            pk = Utils.getObjectPK(entity, obj2);
            if (pk == null) {
                logger.error((Object)("The INIT State agent doesn't contain PK value:" + obj2));
                throw new IllegalArgumentException("Agent (" + agent2.toString() + ") doesn't contain PK value!");
            }
            agentBulk[cusor] = pk;
            pkIndexMap.put(pk, cusor);
            if (pk instanceof ObjectUuidPK) {
                if (initAgnentNum == 0) {
                    oqlBuffer.append("where ");
                    oqlBuffer.append(((ObjectUuidPK)pk).getKeyFields()[0]);
                    oqlBuffer.append(" in (");
                } else {
                    oqlBuffer.append(",");
                }
                oqlBuffer.append("'");
                oqlBuffer.append(((ObjectUuidPK)pk).getKeyValue());
                oqlBuffer.append("'");
            }
            if (initAgnentNum != 0) {
                buffer.append(" or ");
            }
            String[] keys = pk.getKeyFields();
            int n = keys.length;
            for (int l = 0; l < n; ++l) {
                entityViewInfo.getFilter().getFilterItems().add(new FilterItemInfo(keys[l], pk.getKeyValue(keys[l])));
                if (l == 0) {
                    buffer.append("(#");
                } else {
                    buffer.append(" and #");
                }
                buffer.append(filteItemIndex);
                ++filteItemIndex;
            }
            if (keys.length > 0) {
                buffer.append(")");
            }
            ++initAgnentNum;
        }
        if (initAgnentNum >= 1) {
            entityViewInfo.getFilter().setMaskString(buffer.toString());
            IObjectCollection collection = null;
            try {
                collection = pk instanceof ObjectUuidPK ? Utils.getObjectCollection(context, type, oqlBuffer.append(")").toString()) : Utils.getObjectCollection(context, type, entityViewInfo);
            }
            catch (BOSException ex) {
                logger.error((Object)"Error", (Throwable)ex);
                throw new RuntimeException("Get object collection with initial state error", ex);
            }
            assert (agent2 != null);
            try {
                Method method = agent2.getClass().getMethod("copyOvToAgent", IObjectValue.class);
                for (IObjectValue obj2 : collection) {
                    pk = Utils.getObjectPK(entity, obj2);
                    if (pk == null) {
                        logger.error((Object)("The INIT State agent doesn't contain PK value:" + obj2));
                        throw new IllegalArgumentException("Agent (" + obj2.toString() + ") doesn't contain PK value!");
                    }
                    Integer index = (Integer)pkIndexMap.get(pk);
                    if (index == null) {
                        throw new InternalError("Internal algorithmic Error!");
                    }
                    if (!pk.equals(agentBulk[index])) {
                        throw new InternalError("Internal algorithmic Error!");
                    }
                    agentBulk[index.intValue()] = method.invoke(null, obj2);
                }
            }
            catch (RuntimeException e) {
                logger.error((Object)"Copy VO to Agent error", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                throw new RuntimeException("Copy VO to Agent error!", e);
            }
        }
        for (int i = 0; i < agentSize; ++i) {
            if (!(agentBulk[i] instanceof IObjectValue)) {
                logger.warn((Object)(type + ": " + agentBulk[i] + " has beed deleted by others."));
                continue;
            }
            retCollection.addObject((IObjectValue)agentBulk[i]);
        }
    }

    public static IObjectValueAgent deepCopyAgentValue(IObjectValueAgent agent) {
        IdentityHashMap map = new IdentityHashMap();
        AbstractObjectValue ret = (AbstractObjectValue)AgentUtility.innerDeepCopyAgentValue((IObjectValue)agent, map);
        ret.trimToSize();
        return (IObjectValueAgent)ret;
    }

    private static IObjectValue innerDeepCopyAgentValue(IObjectValue source, Map set) {
        assert (set != null);
        if (source == null) {
            return null;
        }
        if (set.containsKey(source)) {
            IObjectValue o = (IObjectValue)set.get(source);
            if (o.getClass().getName().equals(source.getClass().getName())) {
                return o;
            }
            throw new IllegalArgumentException("error: source" + source.getClass().getName() + " target " + o.getClass().getName());
        }
        IObjectValue target = null;
        try {
            target = (IObjectValue)source.getClass().newInstance();
        }
        catch (InstantiationException e) {
            logger.error((Object)"InstantiationException", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"IllegalAccessException", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)"IllegalArgumentException", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            logger.error((Object)"SecurityException", (Throwable)e);
            throw new RuntimeException(e);
        }
        IObjectValue pre = set.put(source, target);
        if (pre != null) {
            throw new IllegalArgumentException("identityHashCode error  pre " + pre.getClass().getName() + " target " + target.getClass().getName());
        }
        try {
            Map extendedProps = (Map)ObjectUtils.createCopy((Object)source.getExtendedProperties());
            for (String key : extendedProps.keySet()) {
                target.setExtendedProperty(key, (String)extendedProps.get(key));
            }
        }
        catch (CloneNotSupportedException e) {
            logger.error((Object)"CloneNotSupportedException", (Throwable)e);
            throw new RuntimeException(e);
        }
        target.setPKField(source.getPKField());
        target.setDefaultLocale(source.getDefaultLocale());
        try {
            Enumeration iter = source.keys();
            while (iter.hasMoreElements()) {
                String key = (String)iter.nextElement();
                Object obj = source.get(key);
                if (obj instanceof IObjectValueAgent || obj instanceof IObjectValue) {
                    target.put(key, (Object)AgentUtility.innerDeepCopyAgentValue((IObjectValue)((AbstractObjectValue)obj), set));
                    continue;
                }
                if (obj instanceof IObjectCollectionAgent || obj instanceof IObjectCollection) {
                    AbstractObjectCollection cloneCollection = (AbstractObjectCollection)obj.getClass().newInstance();
                    AbstractObjectCollection sourceCollection = (AbstractObjectCollection)obj;
                    int j = sourceCollection.size();
                    for (int i = 0; i < j; ++i) {
                        IObjectValue ov = sourceCollection.getObject(i);
                        cloneCollection.addObject(AgentUtility.innerDeepCopyAgentValue(ov, set));
                    }
                    target.put(key, (Object)cloneCollection);
                    continue;
                }
                if (obj == null) {
                    target.put(key, null);
                    continue;
                }
                target.put(key, ObjectUtils.createCopy((Object)obj));
            }
        }
        catch (InstantiationException e) {
            logger.error((Object)"error", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"error", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)AgentUtility.dumpCopyContext(source, set));
            throw e;
        }
        catch (CloneNotSupportedException e) {
            logger.error((Object)"error", (Throwable)e);
            throw new RuntimeException(e);
        }
        if (target instanceof IObjectValueAgent) {
            AgentManager.registerIntercepter((IObjectValueAgent)target, ((IObjectValueAgent)source).getAgentState());
        }
        return target;
    }

    static String dumpCopyContext(IObjectValue source, Map set) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("source:\n");
        buffer.append(source.toString());
        buffer.append("set:\n");
        buffer.append(set.toString());
        return buffer.toString();
    }

    public static IObjectValue getNoAgentValue(IObjectValue ov) {
        if (ov instanceof IObjectValueAgent) {
            IdentityHashMap map = new IdentityHashMap();
            AbstractObjectValue ret = (AbstractObjectValue)AgentUtility.innerGetNoAgentValue(ov, map);
            ret.trimToSize();
            return ret;
        }
        return ov;
    }

    private static IObjectValue innerGetNoAgentValue(IObjectValue source, Map set) {
        assert (set != null);
        if (source == null) {
            return null;
        }
        if (set.containsKey(source)) {
            return (IObjectValue)set.get(source);
        }
        IObjectValue target = null;
        try {
            String noagent_classname;
            if (source instanceof IObjectValueAgent) {
                String agentName = source.getClass().getName();
                noagent_classname = agentName.substring(0, agentName.length() - "Agent".length());
                noagent_classname = noagent_classname + "Info";
            } else {
                noagent_classname = source.getClass().getName();
            }
            target = (IObjectValue)Class.forName(noagent_classname).newInstance();
        }
        catch (InstantiationException e) {
            logger.error((Object)"InstantiationException", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"IllegalAccessException", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)"IllegalArgumentException", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            logger.error((Object)"SecurityException", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"ClassNotFoundException", (Throwable)e);
            throw new RuntimeException(e);
        }
        set.put(source, target);
        try {
            Map extendedProps = (Map)ObjectUtils.createCopy((Object)source.getExtendedProperties());
            for (String key : extendedProps.keySet()) {
                target.setExtendedProperty(key, (String)extendedProps.get(key));
            }
        }
        catch (CloneNotSupportedException e) {
            logger.error((Object)"CloneNotSupportedException", (Throwable)e);
            throw new RuntimeException(e);
        }
        target.setPKField(source.getPKField());
        target.setDefaultLocale(source.getDefaultLocale());
        try {
            Enumeration iter = source.keys();
            while (iter.hasMoreElements()) {
                String key = (String)iter.nextElement();
                Object obj = source.get(key);
                if (obj instanceof IObjectValueAgent || obj instanceof IObjectValue) {
                    target.put(key, (Object)AgentUtility.innerGetNoAgentValue((IObjectValue)((AbstractObjectValue)obj), set));
                    continue;
                }
                if (obj instanceof IObjectCollectionAgent || obj instanceof IObjectCollection) {
                    String noagent_classname;
                    if (obj instanceof IObjectCollectionAgent) {
                        String agentName = obj.getClass().getName();
                        noagent_classname = agentName.substring(0, agentName.length() - "Agent".length());
                    } else {
                        noagent_classname = obj.getClass().getName();
                    }
                    AbstractObjectCollection cloneCollection = (AbstractObjectCollection)Class.forName(noagent_classname).newInstance();
                    AbstractObjectCollection sourceCollection = (AbstractObjectCollection)obj;
                    int j = sourceCollection.size();
                    for (int i = 0; i < j; ++i) {
                        IObjectValue ov = sourceCollection.getObject(i);
                        cloneCollection.addObject(AgentUtility.innerGetNoAgentValue(ov, set));
                    }
                    target.put(key, (Object)cloneCollection);
                    continue;
                }
                if (obj == null) {
                    target.put(key, null);
                    continue;
                }
                target.put(key, ObjectUtils.createCopy((Object)obj));
            }
        }
        catch (InstantiationException e) {
            logger.error((Object)"error", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"error", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (CloneNotSupportedException e) {
            logger.error((Object)"error", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"error", (Throwable)e);
            throw new RuntimeException(e);
        }
        return target;
    }
}

