/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.agent;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.framework.agent.AgentState;
import com.kingdee.bos.framework.agent.AgentUtility;
import com.kingdee.bos.framework.agent.IObjectCollectionAgent;
import com.kingdee.bos.framework.agent.IObjectValueAgent;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import java.io.IOException;
import java.util.ArrayList;

public class ObjectCollectionAgentMarshalDelegate {
    private final IObjectCollectionAgent ocAgent;

    public ObjectCollectionAgentMarshalDelegate(IObjectCollectionAgent ocAgent) {
        this.ocAgent = ocAgent;
    }

    public void marshal(Marshaller marshaller) throws IOException {
        IObjectCollection oc = (IObjectCollection)this.ocAgent;
        marshaller.writeInt(oc.size());
        int len = oc.size();
        for (int i = 0; i < len; ++i) {
            IObjectValueAgent detailAgent = (IObjectValueAgent)oc.getObject(i);
            if (AgentState.INIT == detailAgent.getAgentState()) {
                detailAgent = AgentUtility.createAgentWithId(detailAgent);
            }
            marshaller.writeObject((Object)detailAgent);
        }
        IObjectPK[] deleted = this.ocAgent.getDeletedOVSet().toArray(new IObjectPK[0]);
        marshaller.writeObject((Object)deleted);
    }

    public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        int size = unmarshaller.readInt();
        ArrayList<Object> objs = new ArrayList<Object>(size);
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                objs.add(unmarshaller.readObject());
            }
            AgentUtility.loadAgents(objs, this.ocAgent.getTargetOV());
        }
        IObjectPK[] deleted = (IObjectPK[])unmarshaller.readObject();
        int len = deleted.length;
        for (int i = 0; i < len; ++i) {
            this.ocAgent.deleteOV(deleted[i]);
        }
    }
}

