/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.agent;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.framework.agent.AgentManager;
import com.kingdee.bos.framework.agent.AgentState;
import com.kingdee.bos.framework.agent.AgentUtility;
import com.kingdee.bos.framework.agent.IObjectCollectionAgent;
import com.kingdee.bos.framework.agent.IObjectValueAgent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SerializableObjectCollectionAgent
implements Serializable {
    private final String collectionClass;
    private final List list;
    private final List deletedSet;

    public SerializableObjectCollectionAgent(IObjectCollection oc, IObjectCollectionAgent agentImpl) {
        this.collectionClass = oc.getClass().getSuperclass().getName();
        if (oc.size() > 0) {
            this.list = new ArrayList();
            IObjectValueAgent detailAgent = null;
            int len = oc.size();
            for (int i = 0; i < len; ++i) {
                detailAgent = (IObjectValueAgent)oc.getObject(i);
                if (AgentState.INIT == detailAgent.getAgentState()) {
                    detailAgent = AgentUtility.createAgentWithId(detailAgent);
                }
                this.list.add(detailAgent);
            }
        } else {
            this.list = null;
        }
        if (agentImpl != null && agentImpl.getDeletedOVSet().size() > 0) {
            this.deletedSet = new ArrayList();
            Iterator it = agentImpl.getDeletedOVSet().iterator();
            while (it.hasNext()) {
                this.deletedSet.add(it.next());
            }
        } else {
            this.deletedSet = null;
        }
    }

    private Object readResolve() {
        IObjectCollectionAgent agent = AgentManager.createCollectionAgent(this.collectionClass);
        if (this.deletedSet != null) {
            Iterator it = this.deletedSet.iterator();
            while (it.hasNext()) {
                agent.deleteOV((IObjectPK)it.next());
            }
        }
        if (this.list != null && this.list.size() > 0) {
            AgentUtility.loadAgents(this.list, agent.getTargetOV());
        }
        return agent;
    }
}

