/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.batch;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class BatchExecuteParamsEntry
implements Serializable {
    private static final long serialVersionUID = 2550769445380293794L;
    private final Class[] paramTypes;
    private final List paramValues;

    public BatchExecuteParamsEntry(Class[] paramTypes) {
        this.paramTypes = paramTypes;
        this.paramValues = new ArrayList(paramTypes.length);
    }

    public BatchExecuteParamsEntry(Class[] parameterTypes, Object[] arrParamValue) {
        this(parameterTypes);
        for (int i = 0; i < arrParamValue.length; ++i) {
            this.add(arrParamValue[i]);
        }
    }

    private void sizeCheck() {
        if (this.paramValues.size() == this.paramTypes.length) {
            throw new IndexOutOfBoundsException("index:" + this.paramValues.size());
        }
    }

    private void typeCheck(int index, Object paramValue) {
        if (paramValue == null) {
            if (this.paramTypes[index].isPrimitive()) {
                throw new IllegalArgumentException("error primitive parameter type: index:<" + index + ">, expected:<" + this.paramTypes[index].getName() + "> but was:<null>");
            }
            return;
        }
        if (!this.paramTypes[index].isInstance(paramValue)) {
            throw new IllegalArgumentException("error parameter type: index:<" + index + ">, expected:<" + this.paramTypes[index].getName() + "> but was:<" + paramValue.getClass().getName() + ">");
        }
    }

    public BatchExecuteParamsEntry add(Object paramValue) {
        this.sizeCheck();
        this.typeCheck(this.paramValues.size(), paramValue);
        this.paramValues.add(paramValue);
        return this;
    }

    public BatchExecuteParamsEntry add(int index, Object paramValue) {
        this.sizeCheck();
        this.typeCheck(index, paramValue);
        this.paramValues.add(index, paramValue);
        return this;
    }

    public Object get(int index) {
        return this.paramValues.get(index);
    }

    public Object set(int index, Object paramValue) {
        this.typeCheck(index, paramValue);
        return this.paramValues.set(index, paramValue);
    }

    public Object[] toArray() {
        return this.paramValues.toArray();
    }

    public Class[] getParamTypes() {
        return this.paramTypes;
    }
}

