/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.bp;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.framework.bp.BPOption;
import com.kingdee.bos.framework.bp.BPResult;
import com.kingdee.bos.framework.bp.BpManager;
import com.kingdee.bos.framework.bp.IDynamicBackground;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;

public class DynamicBackground
extends AbstractBOSObject
implements IDynamicBackground {
    public DynamicBackground() {
        this.registerInterface(IDynamicObject.class, this);
    }

    public DynamicBackground(Context ctx) {
        super(ctx);
        this.registerInterface(IDynamicBackground.class, this);
    }

    public BOSObjectType getType() {
        return null;
    }

    @Override
    public BPResult invokeBackound(BOSObjectType type, String methodName, Class[] parmeTypes, Object[] args) throws BOSException {
        IBOSObject obj = BOSObjectFactory.createBOSObject((Context)this.getContext(), (BOSObjectType)type);
        return this.invokeBackound(obj, methodName, parmeTypes, args, new BPOption());
    }

    @Override
    public BPResult invokeBackound(String className, String methodName, Class[] parmeTypes, Object[] args) throws BOSException {
        IBOSObject obj = BOSObjectFactory.createBOSObject((Context)this.getContext(), (String)className);
        return this.invokeBackound(obj, methodName, parmeTypes, args, new BPOption());
    }

    @Override
    public BPResult invokeBackound(BOSObjectType type, String methodName, Class[] parmeTypes, Object[] args, BPOption option) throws BOSException {
        IBOSObject obj = BOSObjectFactory.createBOSObject((Context)this.getContext(), (BOSObjectType)type);
        return this.invokeBackound(obj, methodName, parmeTypes, args, option);
    }

    @Override
    public BPResult invokeBackound(String className, String methodName, Class[] parmeTypes, Object[] args, BPOption option) throws BOSException {
        IBOSObject obj = BOSObjectFactory.createBOSObject((Context)this.getContext(), (String)className);
        return this.invokeBackound(obj, methodName, parmeTypes, args, option);
    }

    private BPResult invokeBackound(IBOSObject obj, String methodName, Class[] parmeTypes, Object[] args, BPOption bpoption) throws BOSException {
        try {
            Method method = DynamicBackground.getMethod(obj, methodName, parmeTypes);
            BPResult r = BpManager.getInstance(this.getContext()).submitBackgroundProcess(this.getContext(), bpoption, obj, method, args);
            return r;
        }
        catch (NoSuchMethodException nse) {
            BPResult r = new BPResult();
            r.status = -1;
            r.Message = StringUtils.stackToString((Exception)nse);
            return r;
        }
    }

    public static final Method getMethod(IBOSObject obj, String name, Class[] parameterTypes) throws NoSuchMethodException {
        obj.getClass().getMethod(name, parameterTypes);
        Method[] methods = obj.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (!m.getName().equals(name) || m.getParameterTypes().length != parameterTypes.length) continue;
            Class<?>[] params = m.getParameterTypes();
            boolean flag = true;
            for (int j = 0; j < params.length; ++j) {
                if (params[j].isAssignableFrom(parameterTypes[j])) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            return m;
        }
        throw new NoSuchMethodException("method '" + name + "' not found.");
    }
}

