/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.ejb;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ReflectException;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.batch.BatchExecuteException;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.framework.batch.IBatchExecuteResult;
import com.kingdee.bos.framework.bp.BPOption;
import com.kingdee.bos.framework.bp.BPResult;
import com.kingdee.bos.framework.bp.BpManager;
import com.kingdee.bos.framework.ejb.BizController;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.framework.ejb.EJBRemoteException;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MDHostType;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.bo.TypeReference;
import com.kingdee.bos.metadata.bo.TypeReferenceFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.bos.service.ServiceExecutionException;
import com.kingdee.bos.service.ServiceManagerFactory;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.BaseException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

public abstract class AbstractBizControllerBean
implements SessionBean,
BizController {
    private SessionContext sessionContext;

    public void setSessionContext(SessionContext context) throws RemoteException, EJBException {
        this.sessionContext = context;
    }

    public void ejbActivate() throws EJBException {
    }

    public void ejbPassivate() throws EJBException {
    }

    public void ejbRemove() throws EJBException {
    }

    public void ejbCreate() throws CreateException, EJBException {
    }

    protected abstract BOSObjectType getBOSType();

    protected Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection(ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    protected final void setRollbackOnly() {
        try {
            this.sessionContext.setRollbackOnly();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected ServiceContext createServiceContext(MetaDataPK methodPK, Object[] params) {
        return new ServiceContext(MetaDataTypeList.FACADE, this.getBOSType(), (IMetaDataPK)methodPK, params);
    }

    protected void invokeServiceBefore(ServiceContext svcCtx) throws ServiceExecutionException, BOSException {
        svcCtx.setExecutionMode(0);
        ServiceStateManager.getInstance().setServiceState(this.getServiceState(svcCtx));
        ServiceManagerFactory.getServiceManager().execute((IServiceContext)svcCtx);
    }

    protected void invokeServiceAfter(ServiceContext svcCtx) throws ServiceExecutionException, BOSException {
        svcCtx.setExecutionMode(1);
        ServiceManagerFactory.getServiceManager().execute((IServiceContext)svcCtx);
    }

    protected ServiceStateManager.ServiceState getServiceState(ServiceContext svcCtx) {
        ServiceStateManager.ServiceState state = new ServiceStateManager.ServiceState();
        state.enableSpecialService("WORKFLOW_BIZEVENT");
        state.enableSpecialService("PLUGIN_SERVICE_EP");
        state.enableSpecialService("HRSYNMODIFY_EVENT");
        return state;
    }

    protected ServiceStateManager.ServiceState getServiceState() {
        ServiceStateManager.ServiceState state = new ServiceStateManager.ServiceState();
        state.enableSpecialService("WORKFLOW_BIZEVENT");
        state.enableSpecialService("PLUGIN_SERVICE_EP");
        state.enableSpecialService("HRSYNMODIFY_EVENT");
        return state;
    }

    protected void cleanUpServiceState() {
        ServiceStateManager.getInstance().finishCall();
    }

    @Override
    public BPResult executeBackground(Context ctx, BPOption option, String methodName, Class[] parmeTypes, Object[] parmeValues) throws BOSException, RemoteException {
        BpManager manager = BpManager.getInstance(ctx);
        return manager.submitBackgroundProcess(ctx, option, this, methodName, parmeTypes, parmeValues);
    }

    @Override
    public BatchExecuteResult batchExecute(Context ctx, String name, Class[] paramTypes, BatchExecuteParamsEntry[] paramEntries) throws BaseException {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("methodName cannot be null.");
        }
        if (paramTypes == null) {
            throw new IllegalArgumentException("method parameter cannot be null.");
        }
        if (paramEntries == null || paramEntries.length == 0) {
            throw new IllegalArgumentException("method arguments cannot be null.");
        }
        if (paramTypes.length == 0) {
            throw new BatchExecuteException("method parameter cannot be empty.");
        }
        MetaDataPK methodPK = this.getMethodPK(ctx, name, paramTypes);
        if (methodPK == null) {
            BusinessObjectInfo bo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getBusinessObject(this.getBOSType());
            throw new BatchExecuteException("No Such method: " + name + "(" + this.paramTypesToString(paramTypes) + ") in " + bo);
        }
        Method batchMethod = AbstractBizControllerBean.getMethod(this, this.getBatchMethodName(ctx, name), new Class[]{Context.class, BatchExecuteParamsEntry[].class});
        if (batchMethod == null) {
            return this.loopingExecute(ctx, name, paramTypes, paramEntries);
        }
        BizController bizCtrl = EJBFactory.getBusinessController(ctx, this.getBOSType());
        try {
            return bizCtrl.batchingExecute(ctx, methodPK, batchMethod, paramEntries);
        }
        catch (RemoteException err) {
            throw new EJBRemoteException(err);
        }
    }

    private BatchExecuteResult loopingExecute(Context ctx, String name, Class[] paramTypes, BatchExecuteParamsEntry[] paramEntries) throws BOSException {
        BatchExecuteResult result = new BatchExecuteResult(paramEntries.length);
        BizController bizCtrl = EJBFactory.getBusinessController(ctx, this.getBOSType());
        Method mth = AbstractBizControllerBean.getMethod(bizCtrl, name, AbstractBizControllerBean.getParamTypeArray(paramTypes));
        if (mth == null) {
            BusinessObjectInfo bo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getBusinessObject(this.getBOSType());
            throw new BatchExecuteException("No Such method: " + name + "(" + this.paramTypesToString(paramTypes) + ") in " + bo);
        }
        ServiceStateManager.LoopSnatpot ls = new ServiceStateManager.LoopSnatpot(ServiceStateManager.getInstance());
        for (int i = 0; i < result.size(); ++i) {
            try {
                ServiceStateManager.getInstance().reSetServiceState(ls);
                Object rtv = AbstractBizControllerBean.invoke(bizCtrl, mth, AbstractBizControllerBean.getParamValueArray(ctx, paramEntries[i]));
                result.setReturnValue(i, rtv);
                continue;
            }
            catch (Throwable th) {
                result.setException(i, th);
            }
        }
        ServiceStateManager.getInstance().reSetStateSnatpot(ls);
        return result;
    }

    @Override
    public BatchExecuteResult batchingExecute(Context ctx, MetaDataPK methodPK, Method batchMethod, BatchExecuteParamsEntry[] paramEntries) throws BaseException {
        ServiceStateManager.getInstance().setServiceState(this.getServiceState());
        try {
            int i;
            BatchExecuteResult result = new BatchExecuteResult(paramEntries.length);
            ServiceContext[] arrSvcCtx = new ServiceContext[result.size()];
            for (int i2 = 0; i2 < arrSvcCtx.length; ++i2) {
                ServiceContext svcCtx = this.createServiceContext(methodPK, AbstractBizControllerBean.getParamValueArray(ctx, paramEntries[i2]));
                svcCtx.setExecutionMode(0);
                svcCtx.setBatchExctue(true);
                arrSvcCtx[i2] = svcCtx;
            }
            ServiceManagerFactory.getServiceManager().execute((IServiceContext[])arrSvcCtx);
            ArrayList<BatchExecuteParamsEntry> successedEntries = new ArrayList<BatchExecuteParamsEntry>();
            ArrayList<Integer> successedEntryIndex = new ArrayList<Integer>();
            for (int i3 = 0; i3 < arrSvcCtx.length; ++i3) {
                Throwable th = arrSvcCtx[i3].getServiceException();
                if (th == null) {
                    successedEntries.add(paramEntries[i3]);
                    successedEntryIndex.add(i3);
                    continue;
                }
                result.setException(i3, th);
            }
            Object batchRtv = AbstractBizControllerBean.invoke(this, batchMethod, new Object[]{ctx, successedEntries.toArray(new BatchExecuteParamsEntry[0])});
            result.setBatchResult(batchRtv);
            if (batchRtv instanceof IBatchExecuteResult) {
                for (int i4 = 0; i4 < successedEntryIndex.size(); ++i4) {
                    if (!((IBatchExecuteResult)batchRtv).exceptionOccured(i4)) continue;
                    int entryIndex = (Integer)successedEntryIndex.get(i4);
                    arrSvcCtx[entryIndex] = null;
                }
            }
            for (i = 0; i < arrSvcCtx.length; ++i) {
                if (arrSvcCtx[i] == null) continue;
                if (arrSvcCtx[i].getServiceException() != null) {
                    arrSvcCtx[i] = null;
                    continue;
                }
                ServiceContext svcCtx = this.createServiceContext(methodPK, AbstractBizControllerBean.getParamValueArray(ctx, paramEntries[i]));
                svcCtx.setExecutionMode(1);
                svcCtx.setBatchExctue(true);
                arrSvcCtx[i] = svcCtx;
            }
            ServiceManagerFactory.getServiceManager().execute((IServiceContext[])arrSvcCtx);
            for (i = 0; i < arrSvcCtx.length; ++i) {
                Throwable th;
                if (arrSvcCtx[i] == null || (th = arrSvcCtx[i].getServiceException()) == null) continue;
                result.setException(i, th);
            }
            BatchExecuteResult batchExecuteResult = result;
            return batchExecuteResult;
        }
        catch (Throwable th) {
            this.setRollbackOnly();
            if (th instanceof BaseException) {
                throw (BaseException)th;
            }
            throw new BOSException(th);
        }
        finally {
            this.cleanUpServiceState();
        }
    }

    private String paramTypesToString(Class[] paramTypes) {
        assert (paramTypes != null);
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < paramTypes.length; ++i) {
            sbuf.append(paramTypes[i].getName());
            if (i >= paramTypes.length - 1) continue;
            sbuf.append(", ");
        }
        return sbuf.toString();
    }

    private static Method getMethod(Object obj, String methodName, Class[] parameterTypes) {
        Method[] methods = obj.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (!m.getName().equals(methodName) || m.getParameterTypes().length != parameterTypes.length) continue;
            Class<?>[] params = m.getParameterTypes();
            boolean flag = true;
            for (int j = 0; j < params.length; ++j) {
                if (params[j].isAssignableFrom(parameterTypes[j])) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            return m;
        }
        return null;
    }

    protected String getBatchMethodName(Context ctx, String name) throws BaseException {
        return "batch" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private static Class[] getParamTypeArray(Class[] parameterTypes) {
        Class[] types = new Class[parameterTypes.length + 1];
        types[0] = Context.class;
        System.arraycopy(parameterTypes, 0, types, 1, parameterTypes.length);
        return types;
    }

    private static Object[] getParamValueArray(Context ctx, BatchExecuteParamsEntry entry) {
        Object[] params = new Object[entry.getParamTypes().length + 1];
        params[0] = ctx;
        Object[] entryItems = entry.toArray();
        System.arraycopy(entryItems, 0, params, 1, entryItems.length);
        return params;
    }

    private MetaDataPK getMethodPK(Context ctx, String name, Class[] parameterTypes) {
        BusinessObjectInfo bo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getBusinessObject(this.getBOSType());
        MethodCollection mthdCol = bo.getAllMethodsRuntime();
        for (int i = 0; i < mthdCol.size(); ++i) {
            ParameterCollection paramCol;
            boolean nameMatch;
            MethodInfo mthd = mthdCol.get(i);
            String pimMthdName = mthd.getName();
            boolean bl = nameMatch = pimMthdName.equals(name) || "getValue".equals(pimMthdName) && name.equals(this.get_GETVALUE_MethodName(bo)) || "getCollection".equals(pimMthdName) && name.equals(this.get_GETCOLLECTION_MethodName(bo));
            if (!nameMatch || (paramCol = mthd.getParameters()).size() != parameterTypes.length) continue;
            boolean paramTypeMatch = true;
            TypeReferenceFactory trf = TypeReferenceFactory.getInstance((MDHostType)MDHostType.RUNTIME);
            int n = paramCol.size();
            for (int j = 0; j < n; ++j) {
                TypeReference pimType = trf.getParameterType(bo, paramCol.get(j));
                TypeReference psmType = trf.createTypeReference(parameterTypes[j]);
                if (psmType.equals((Object)pimType)) continue;
                paramTypeMatch = false;
                break;
            }
            if (!paramTypeMatch) continue;
            return MetaDataPK.create((String)mthd.getInnerID());
        }
        return null;
    }

    private String get_GETVALUE_MethodName(BusinessObjectInfo bo) {
        if (bo instanceof EntityObjectInfo) {
            EntityObjectInfo entity = (EntityObjectInfo)bo;
            String className = entity.getObjectValueClassRuntime();
            int pos = className.lastIndexOf(46);
            return "get" + className.substring(pos + 1);
        }
        return null;
    }

    private String get_GETCOLLECTION_MethodName(BusinessObjectInfo bo) {
        if (bo instanceof EntityObjectInfo) {
            EntityObjectInfo entity = (EntityObjectInfo)bo;
            String className = entity.getObjectCollectionClassRuntime();
            int pos = className.lastIndexOf(46);
            return "get" + className.substring(pos + 1);
        }
        return null;
    }

    private static Object invoke(Object obj, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke(obj, args);
        }
        catch (IllegalAccessException iae) {
            throw new ReflectException((Throwable)iae);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }
}

