/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.ejb;

import com.kingdee.bos.BOSClassNotFoundException;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ICommonBOSType;
import com.kingdee.bos.db.RWSplitingManager;
import com.kingdee.bos.db.RepositoryFactory;
import com.kingdee.bos.framework.DeployInfoManagerFactory;
import com.kingdee.bos.framework.config.AISDeployInfo;
import com.kingdee.bos.framework.config.AppServerDeployInfo;
import com.kingdee.bos.framework.config.SolutionDeployInfo;
import com.kingdee.bos.framework.ejb.BizController;
import com.kingdee.bos.framework.ejb.EJBUtils;
import com.kingdee.bos.framework.ejb.IEJBUtils;
import com.kingdee.bos.jdbc.trace.ConnectionWrapper;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataUtils;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.sql.shell.Repository;
import com.kingdee.bos.transaction.BOSTransactionAttribute;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.bos.transaction.EJBTxFacade.ITxHelperHome;
import com.kingdee.bos.transaction.EJBTxFacade.ITxInvokerLocalHome;
import com.kingdee.bos.transaction.EJBTxFacade.ITxInvokerRemoteHome;
import com.kingdee.bos.transaction.TxContext;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.security.AccessControlException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.ejb.SessionBean;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class EJBFactory {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.framework.ejb.EJBFactory");
    private static final String JDBC = "jdbc";
    private static Hashtable<String, String> jndiNameCache = new Hashtable();
    private static Hashtable<String, Boolean> aisCache = new Hashtable();
    private static Hashtable<String, IEJBUtils[]> ejbUtilsCache = new Hashtable();
    private static Hashtable<String, IEJBUtils> queryDSCache = new Hashtable();
    private static ITxInvokerLocalHome invokerLh;
    private static ITxInvokerRemoteHome invokerRh;
    private static boolean isConnectionTrace;

    private static IEJBUtils[] getAllEJBUtils(Context ctx) {
        EJBFactory.loadConfigInfo(ctx);
        IEJBUtils[] ejbUtils = ejbUtilsCache.get(ctx.getAIS());
        return ejbUtils;
    }

    public static Connection getConnnection(Context ctx) throws SQLException {
        return EJBFactory.getConnection(ctx);
    }

    public static Connection getQueryConnection(Context ctx) throws SQLException {
        String ais = null;
        Repository repo = RepositoryFactory.getQueryRepository(ctx);
        if (repo != null) {
            ais = repo.getIdentity();
        }
        if (ais != null) {
            return EJBFactory.getQueryConnection(ctx, ais);
        }
        return EJBFactory.getConnection(ctx);
    }

    private static Connection getQueryConnection(Context ctx, String aix) throws SQLException {
        assert (ctx != null && ctx.getAIS() != null);
        EJBFactory.loadConfigInfo(ctx);
        IEJBUtils queryDS = queryDSCache.get(aix);
        if (queryDS == null) {
            throw new SQLException("Cannot found query datasource, please check the config file!");
        }
        Connection conn = null;
        try {
            conn = queryDS.getConnection();
        }
        catch (Exception e) {
            // empty catch block
        }
        if ((conn == null || conn.isClosed()) && queryDS instanceof EJBUtils) {
            try {
                ((EJBUtils)queryDS).clean();
                conn = queryDS.getConnection();
                if (conn.isClosed()) {
                    throw new SQLException(aix + " cannot get connection .");
                }
                logger.error((Object)(aix + "  connection is closed. re connectied"));
            }
            catch (Exception e) {
                ((EJBUtils)queryDS).clean();
                queryDS = queryDSCache.get(ctx.getAIS());
                conn = queryDS.getConnection();
                logger.error((Object)(aix + " cannot get connection . Switch to " + ctx.getAIS()));
                RWSplitingManager.setIsRWSplit(false);
                logger.error((Object)" close IsRWSplit ");
            }
        }
        if (isConnectionTrace) {
            return ConnectionWrapper.wrapperTrace(conn);
        }
        return conn;
    }

    public static Connection getConnection(Context ctx) throws SQLException {
        return TxContext.getConnection(ctx);
    }

    public static Connection getConnection0(Context ctx) throws SQLException {
        if (RepositoryFactory.isBindQueryRepository(ctx)) {
            return EJBFactory.getQueryConnection(ctx);
        }
        Connection cn = EJBFactory.getAllEJBUtils(ctx)[0].getConnection();
        if (isConnectionTrace) {
            return ConnectionWrapper.wrapperTrace(cn);
        }
        return cn;
    }

    public static BizController getBusinessController(Context ctx, BOSObjectType type) throws BOSException {
        return EJBFactory.getEJBusinessController(ctx, type);
    }

    public static BizController getBusinessController(Context ctx, BOSObjectType type, IMetaDataPK pk) throws BOSException {
        return EJBFactory.getEJBusinessController(ctx, type, pk);
    }

    private static BizController getEJBusinessController(Context ctx, BOSObjectType type) throws BOSException {
        return EJBFactory.getEJBusinessController(ctx, type, null);
    }

    private static BizController getEJBusinessController(Context ctx, BOSObjectType type, IMetaDataPK pk) throws BOSException {
        BusinessObjectInfo meta = null;
        meta = pk == null ? EJBFactory.getBOFromCache(ctx, type) : EJBFactory.getBOFromCache(ctx, pk);
        try {
            String className = meta.getRuntimeBusinessControllerBean();
            Class<?> beanClass = Class.forName(className);
            SessionBean obj = (SessionBean)beanClass.newInstance();
            if (pk != null && obj instanceof ICommonBOSType) {
                ((ICommonBOSType)obj).setPK(pk);
            }
            if (type != null && obj instanceof ICommonBOSType) {
                ((ICommonBOSType)obj).setBOSType(type);
            }
            if (invokerLh == null && invokerRh == null) {
                EJBFactory.initEJBTxInvoker();
            }
            BOSTransactionAttribute bta = null;
            bta = pk != null ? BOSTransactionAttribute.getAttribute(ctx, pk) : BOSTransactionAttribute.getAttribute(ctx, type);
            EJBTransactionProxy handler = new EJBTransactionProxy(obj, invokerLh, invokerRh, bta, type);
            HashSet interfaces = new HashSet();
            Class<?> currentClazz = beanClass;
            do {
                interfaces.addAll(Arrays.asList(currentClazz.getInterfaces()));
            } while ((currentClazz = currentClazz.getSuperclass()) != null && !Object.class.equals(currentClazz));
            Class[] proxyInterfaces = interfaces.toArray(new Class[0]);
            BizController proxy = (BizController)Proxy.newProxyInstance(EJBFactory.class.getClassLoader(), proxyInterfaces, (InvocationHandler)handler);
            return proxy;
        }
        catch (ClassNotFoundException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            throw new BOSClassNotFoundException((Throwable)e);
        }
        catch (InstantiationException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            throw new BOSClassNotFoundException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            throw new BOSClassNotFoundException((Throwable)e);
        }
    }

    public static EJBTransactionProxy getEJBTransactionProxy(Object target) {
        if (invokerLh == null && invokerRh == null) {
            EJBFactory.initEJBTxInvoker();
        }
        return new EJBTransactionProxy(target, invokerLh, invokerRh);
    }

    public static String getJNDIName(Context ctx, BOSObjectType type, boolean isRemote) throws BOSException {
        String key = ctx.getSolution() + "_" + type.toString();
        if (jndiNameCache.contains(key)) {
            return jndiNameCache.get(key);
        }
        BusinessObjectInfo meta = EJBFactory.getBOFromCache(ctx, type);
        String value = null;
        value = isRemote ? "ejb/" + ctx.getSolution() + "/" + meta.getBusinessControllerHome().replace('.', '_') : "ejb/" + ctx.getSolution() + "/" + meta.getBusinessControllerLocaleHome().replace('.', '_');
        jndiNameCache.put(key, value);
        return value;
    }

    private static boolean isQueryDataSourceAvaliable(IEJBUtils ejbUtils) {
        try {
            DataSource queryDataSource = (DataSource)ejbUtils.getInitialContext().lookup(ejbUtils.getDataSource());
            if (queryDataSource != null) {
                return true;
            }
        }
        catch (NamingException nex) {
            logger.debug((Object)("JNDI Exception Occurred. Is your JNDI " + ejbUtils.getDataSource() + " resource available?\n"), (Throwable)nex);
        }
        catch (AccessControlException ae) {
            logger.debug((Object)"You cannot execute this eunction with the security permissions you are using. Try using the securityCredential/securityPrincipalpoolman parameters.\n", (Throwable)ae);
        }
        return false;
    }

    private static void loadConfigInfo(Context ctx) {
        if (ejbUtilsCache.containsKey(ctx.getAIS())) {
            return;
        }
        SolutionDeployInfo slnDeployInfo = DeployInfoManagerFactory.getDeployInfoManager().getSolutionDeployInfo(ctx.getSolution());
        AISDeployInfo aisDeployInfo = null;
        if (slnDeployInfo != null) {
            aisDeployInfo = slnDeployInfo.getAISInfo(ctx.getAIS());
        }
        EJBUtils[] ejbUtils = null;
        if (aisDeployInfo == null) {
            ejbUtils = new EJBUtils[]{new EJBUtils("jdbc/" + ctx.getAIS())};
            ejbUtilsCache.put(ctx.getAIS(), ejbUtils);
            EJBUtils queryDS = new EJBUtils("jdbc/" + ctx.getAIS() + "_Query");
            if (EJBFactory.isQueryDataSourceAvaliable(queryDS)) {
                queryDSCache.put(ctx.getAIS(), queryDS);
            } else {
                queryDSCache.put(ctx.getAIS(), ejbUtils[0]);
            }
            aisCache.put(ctx.getAIS(), Boolean.FALSE);
        } else {
            AppServerDeployInfo[] appServerInfos = aisDeployInfo.getServerInfos();
            int len = appServerInfos.length;
            ejbUtils = new EJBUtils[len];
            for (int i = 0; i < len; ++i) {
                String contextFactory = appServerInfos[i].getContextFactory();
                String jndiURL = appServerInfos[i].getJndiURL();
                String securityCredential = appServerInfos[i].getSecurityCredential();
                String securityPrincipal = appServerInfos[i].getSecurityPrincipal();
                String datasource = appServerInfos[i].getDatasource();
                if (datasource == null) {
                    datasource = "jdbc/" + ctx.getAIS();
                }
                ejbUtils[i] = new EJBUtils(datasource, jndiURL, contextFactory, securityCredential, securityPrincipal);
                if (i != 0) continue;
                if (jndiURL == null) {
                    aisCache.put(ctx.getAIS(), false);
                } else {
                    aisCache.put(ctx.getAIS(), true);
                }
                EJBUtils queryDS = new EJBUtils(datasource + "_Query", jndiURL, contextFactory, securityCredential, securityPrincipal);
                if (EJBFactory.isQueryDataSourceAvaliable(queryDS)) {
                    queryDSCache.put(ctx.getAIS(), queryDS);
                    continue;
                }
                queryDSCache.put(ctx.getAIS(), ejbUtils[0]);
            }
            ejbUtilsCache.put(ctx.getAIS(), ejbUtils);
        }
    }

    public static BusinessObjectInfo getBOFromCache(Context ctx, BOSObjectType type) throws BOSException {
        return MetaDataUtils.getBOFromCache((Context)ctx, (BOSObjectType)type);
    }

    public static BusinessObjectInfo getBOFromCache(Context ctx, IMetaDataPK pk) throws BOSException {
        return MetaDataUtils.getBOFromCache((Context)ctx, (IMetaDataPK)pk);
    }

    private static void initEJBTxInvoker() {
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            ConfigurationItem jndi = Configuration.getInstance().getConfigItem("jndi");
            if (jndi != null) {
                String url = jndi.getProperty("jndiURL");
                String factory = jndi.getProperty("contextFactory");
                String user = jndi.getProperty("securityPrincipal");
                String pass = jndi.getProperty("securityCredential");
                if (url != null) {
                    env.put("java.naming.provider.url", url);
                }
                if (factory != null) {
                    env.put("java.naming.factory.initial", factory);
                }
                if (user != null) {
                    env.put("java.naming.security.principal", user);
                    if (pass != null) {
                        env.put("java.naming.security.credentials", pass);
                    } else {
                        env.put("java.naming.security.credentials", "");
                    }
                }
            }
            InitialContext ctx = new InitialContext(env);
            try {
                try {
                    invokerLh = (ITxInvokerLocalHome)ctx.lookup("ejb/TxLocalEJB");
                    logger.info((Object)"Get Local TxEJB from jndi");
                }
                catch (Throwable t) {
                    invokerRh = (ITxInvokerRemoteHome)PortableRemoteObject.narrow((Object)ctx.lookup("ejb/TxEJB"), ITxInvokerRemoteHome.class);
                    logger.info((Object)"Get Remote TxEJB from jndi");
                }
            }
            catch (Throwable _) {
                try {
                    invokerLh = (ITxInvokerLocalHome)ctx.lookup("local:ejb/TxLocalEJB");
                    logger.info((Object)"Get Local TxEJB from jndi by local:xxxx/xxxx");
                }
                catch (Throwable __) {
                    ITxHelperHome home = (ITxHelperHome)PortableRemoteObject.narrow((Object)ctx.lookup("ejb/TxHelper"), ITxHelperHome.class);
                    invokerLh = home.create().findTxEJB("ejb/TxLocalEJBRef");
                    logger.info((Object)"Get Local TxEJB from remote HelperEJB");
                }
            }
        }
        catch (Exception e) {
            logger.fatal((Object)"Can NOT init Tx Broker EJB.", (Throwable)e);
        }
    }

    public static Set<String> getQueryDataSources() {
        HashSet<String> copy = new HashSet<String>();
        copy.addAll(queryDSCache.keySet());
        return copy;
    }

    public static Hashtable<String, IEJBUtils> getQueryDSCache() {
        return queryDSCache;
    }

    static {
        isConnectionTrace = false;
        try {
            ConfigurationItem item = Configuration.getInstance().getConfigItem("DebugOptions");
            if (item != null) {
                String trace = item.getProperty("connection.trace");
                if ("true".equalsIgnoreCase(trace)) {
                    isConnectionTrace = true;
                    logger.info((Object)"==JDBC connection trace service started==");
                }
                logger.info((Object)"==Transaction (Ejb Mode) broker start ... ==");
                try {
                    EJBFactory.initEJBTxInvoker();
                    logger.warn((Object)"==Transaction (Ejb Mode) broker started ==");
                }
                catch (Exception e) {
                    logger.warn((Object)"==Transaction (Ejb Mode) broker start ERROR ==");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

