/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.ejb;

import com.kingdee.bos.framework.ejb.IEJBUtils;
import java.util.Hashtable;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

public class EJBHomeCache {
    private Hashtable ejbHomes;
    private IEJBUtils ejbBase;

    public EJBHomeCache(IEJBUtils ejbBase) {
        this.ejbBase = ejbBase;
        this.ejbHomes = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EJBHome lookupEJBHome(Class homeClass, String jndiName) throws NamingException {
        if (this.ejbBase == null) {
            throw new IllegalStateException("EJBBaseUtils class not registered.");
        }
        EJBHome home = null;
        if (this.ejbHomes.containsKey(jndiName)) {
            home = (EJBHome)this.ejbHomes.get(jndiName);
        }
        if (home == null) {
            EJBHomeCache eJBHomeCache = this;
            synchronized (eJBHomeCache) {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                if (loader != this.getClass().getClassLoader()) {
                    try {
                        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                        home = (EJBHome)PortableRemoteObject.narrow((Object)this.ejbBase.getInitialContext().lookup(jndiName), (Class)homeClass);
                        this.ejbHomes.put(jndiName, home);
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(loader);
                    }
                }
            }
        }
        return home;
    }

    public EJBLocalHome lookupEJBLocalHome(String jndiName) throws NamingException {
        if (this.ejbBase == null) {
            throw new IllegalStateException("EJBBaseUtils class not registered.");
        }
        EJBLocalHome home = null;
        if (this.ejbHomes.containsKey(jndiName)) {
            home = (EJBLocalHome)this.ejbHomes.get(jndiName);
        }
        if (home == null) {
            home = (EJBLocalHome)this.ejbBase.getInitialContext().lookup(jndiName);
            this.ejbHomes.put(jndiName, home);
        }
        return home;
    }
}

