/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.ejb;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.Utils;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.framework.ejb.HistoryEntityParam;
import com.kingdee.bos.framework.ejb.HistoryUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.HistoryConstant;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class HistoryObjectReader {
    public int getAllHisVersionCount(Context ctx, Connection cn, BOSObjectType currentType, IObjectPK currentPK, EntityViewInfo view) throws BOSException {
        HistoryEntityParam param = HistoryUtil.getHistoryEntityParam(ctx, currentType);
        if (!param.isNeedHistory()) {
            return 0;
        }
        int count = HistoryUtil.getHistoryCcount(ctx, cn, currentType, currentPK, view);
        return count;
    }

    public List getAllHisVersionReturnCurrent(Context ctx, BOSObjectType currentType, IObjectPK currentPK) throws DataAccessException {
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection(ctx);
            ArrayList<IObjectValue> historyList = new ArrayList<IObjectValue>();
            HistoryEntityParam param = HistoryUtil.getHistoryEntityParam(ctx, currentType);
            if (!param.isNeedHistory()) {
                ArrayList<IObjectValue> arrayList = historyList;
                return arrayList;
            }
            IObjectCollection collection = HistoryUtil.getHistoryCollection(ctx, cn, currentType, currentPK);
            for (int i = 0; i < collection.size(); ++i) {
                IObjectValue currentInfo = Utils.newObjectValueInstance(param.getCurrentEntityInfo());
                historyList.add(HistoryUtil.convertHistoryInfo(collection.getObject(i), currentInfo));
            }
            ArrayList<IObjectValue> arrayList = historyList;
            return arrayList;
        }
        catch (SQLException e) {
            throw new DataAccessException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    protected IObjectValue _getHisValueByCurrentIDAndDate(Context ctx, IObjectPK pk, BOSObjectType bosType, Date EFFDT, SelectorItemCollection sic) throws BOSException {
        if (pk == null) {
            return null;
        }
        if (EFFDT == null) {
            EFFDT = DateTimeUtils.truncateDate((Date)new Date());
        }
        EntityViewInfo view = new EntityViewInfo();
        Object[] params = new Object[]{pk};
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(HistoryConstant.EFFDT, (Object)EFFDT, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo(HistoryConstant.LEFFDT, (Object)EFFDT, CompareType.GREATER));
        view.setFilter(filter);
        List result = this.getAllHisVersionReturnCurrentPaging(ctx, bosType, pk, view, 0, 1000);
        if (result.size() > 0) {
            return (IObjectValue)result.get(0);
        }
        return null;
    }

    public List getAllHisVersionReturnCurrentPaging(Context ctx, BOSObjectType currentType, IObjectPK currentPK, EntityViewInfo view, int start, int length) throws BOSException {
        ArrayList<IObjectValue> historyList = new ArrayList<IObjectValue>();
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection(ctx);
            HistoryEntityParam param = HistoryUtil.getHistoryEntityParam(ctx, currentType);
            if (!param.isNeedHistory()) {
                ArrayList<IObjectValue> arrayList = historyList;
                return arrayList;
            }
            IObjectCollection collection = HistoryUtil.getHistoryCollectionPaging(ctx, cn, currentType, currentPK, view, start, length);
            for (int i = 0; i < collection.size(); ++i) {
                IObjectValue currentInfo = Utils.newObjectValueInstance(param.getCurrentEntityInfo());
                historyList.add(HistoryUtil.convertHistoryInfo(collection.getObject(i), currentInfo));
            }
            ArrayList<IObjectValue> arrayList = historyList;
            return arrayList;
        }
        catch (SQLException e) {
            throw new DataAccessException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    public List getAllHisVersionReturnHistory(Context ctx, BOSObjectType currentType, IObjectPK currentPK) throws DataAccessException {
        ArrayList<IObjectValue> historyList = new ArrayList<IObjectValue>();
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection(ctx);
            HistoryEntityParam param = HistoryUtil.getHistoryEntityParam(ctx, currentType);
            if (!param.isNeedHistory()) {
                ArrayList<IObjectValue> arrayList = historyList;
                return arrayList;
            }
            IObjectCollection collection = HistoryUtil.getHistoryCollection(ctx, cn, currentType, currentPK);
            for (int i = 0; i < collection.size(); ++i) {
                historyList.add(collection.getObject(i));
            }
            ArrayList<IObjectValue> arrayList = historyList;
            return arrayList;
        }
        catch (SQLException e) {
            throw new DataAccessException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    public IObjectValue getHistoryVersion(Context ctx, IObjectPK pk, EntityViewInfo view, BOSObjectType currentType) throws DataAccessException {
        if (!HistoryUtil.needHistory(ctx, currentType)) {
            return null;
        }
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection(ctx);
            HistoryEntityParam param = HistoryUtil.getHistoryEntityParam(ctx, currentType);
            IObjectValue historyVO = HistoryUtil.getDao(ctx, cn, param.getHistoryEntityInfo()).getValue(view);
            IObjectValue currentVO = Utils.newObjectValueInstance(param.getCurrentEntityInfo());
            IObjectValue iObjectValue = HistoryUtil.convertHistoryInfo(historyVO, currentVO);
            return iObjectValue;
        }
        catch (SQLException e) {
            throw new DataAccessException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }
}

