/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.ejb;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.HistoryParam;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.Utils;
import com.kingdee.bos.framework.ejb.HistoryEntityParam;
import com.kingdee.bos.framework.ejb.HistoryUpdateResultParam;
import com.kingdee.bos.framework.ejb.HistoryUtil;
import com.kingdee.bos.framework.ejb.HistoryValidateUtil;
import com.kingdee.bos.framework.ejb.PreOrPosInfo;
import com.kingdee.bos.metadata.entity.HistoryConstant;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.util.DateTimeUtils;
import java.sql.Connection;
import java.util.Date;
import java.util.HashSet;

public class HistoryObjectUpdater {
    private IObjectPK[] convertSetToArray(HashSet<IObjectPK> pkSet) {
        Object[] objs = pkSet.toArray();
        ObjectUuidPK[] pks = new ObjectUuidPK[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            pks[i] = (IObjectPK)objs[i];
        }
        return pks;
    }

    public IObjectPK[] innerUpdateModifyRevise(Context ctx, Connection cn, IObjectPK pk, IObjectValue model, HistoryParam hisParam) throws BOSException {
        HashSet<IObjectPK> pkSet = new HashSet<IObjectPK>();
        HistoryEntityParam param = HistoryUtil.getHistoryEntityParam(ctx, model.getBOSType());
        if (param.isNeedHistory()) {
            IObjectValue posInfo;
            PreOrPosInfo preposInfo = HistoryUtil.getPrePosInfo(ctx, cn, model, pk, hisParam);
            HistoryUtil.getDao(ctx, cn, model.getBOSType()).update(pk, model);
            IObjectValue historyInfo = Utils.newObjectValueInstance(param.getHistoryEntityInfo());
            IORMappingDAO dao = HistoryUtil.getDao(ctx, cn, historyInfo);
            HistoryUtil.cloneInfo(preposInfo.getCurrentObj(), historyInfo);
            HistoryUtil.cloneInfo(model, historyInfo);
            HistoryUtil.swapHistoryKeyValue(historyInfo);
            historyInfo.put(HistoryConstant.ID, preposInfo.getCurrentObj().get(HistoryConstant.ID));
            Date currentStartDate = (Date)historyInfo.get(HistoryConstant.EFFDT);
            Date preStartDate = null;
            if (preposInfo.getPreObj() != null) {
                preStartDate = (Date)preposInfo.getPreObj().get(HistoryConstant.EFFDT);
            }
            Date posEndDate = null;
            if (preposInfo.getPosObj() != null) {
                posEndDate = (Date)preposInfo.getPosObj().get(HistoryConstant.EFFDT);
            }
            if (preStartDate != null && (preStartDate == null || !DateTimeUtils.dayAfter((Date)currentStartDate, (Date)preStartDate)) || posEndDate != null && (posEndDate == null || !DateTimeUtils.dayAfter((Date)posEndDate, (Date)currentStartDate))) {
                throw new BOSException("HIS-EFFDT:" + preStartDate + ",HIS-LEFFDT:" + posEndDate + ",message:effectdate is not fitable");
            }
            HistoryValidateUtil.validOneRecordHistoryDateAndCleanDate(historyInfo);
            dao.update((IObjectPK)new ObjectUuidPK(historyInfo.get(HistoryConstant.ID).toString()), historyInfo);
            pkSet.add((IObjectPK)new ObjectUuidPK(historyInfo.get(HistoryConstant.ID).toString()));
            IObjectValue preInfo = preposInfo.getPreObj();
            if (preInfo != null && !DateTimeUtils.dayEquals((Date)HistoryUtil.getBeforeDay(hisParam.getEffectStartDate()), (Date)((Date)preInfo.get(HistoryConstant.LEFFDT)))) {
                preInfo.put(HistoryConstant.LEFFDT, (Object)HistoryUtil.getBeforeDay(hisParam.getEffectStartDate()));
                HistoryValidateUtil.validOneRecordHistoryDateAndCleanDate(preInfo);
                dao.update((IObjectPK)new ObjectUuidPK(preInfo.get(HistoryConstant.ID).toString()), preInfo);
                pkSet.add((IObjectPK)new ObjectUuidPK(preInfo.get(HistoryConstant.ID).toString()));
            }
            if ((posInfo = preposInfo.getPosObj()) != null && !DateTimeUtils.dayEquals((Date)HistoryUtil.getAfterDay((Date)historyInfo.get(HistoryConstant.LEFFDT)), (Date)((Date)posInfo.get(HistoryConstant.EFFDT)))) {
                posInfo.put(HistoryConstant.EFFDT, (Object)HistoryUtil.getAfterDay((Date)historyInfo.get(HistoryConstant.LEFFDT)));
                HistoryValidateUtil.validOneRecordHistoryDateAndCleanDate(posInfo);
                dao.update((IObjectPK)new ObjectUuidPK(posInfo.get(HistoryConstant.ID).toString()), posInfo);
                pkSet.add((IObjectPK)new ObjectUuidPK(posInfo.get(HistoryConstant.ID).toString()));
            }
        } else {
            HistoryUtil.getDao(ctx, cn, model.getBOSType()).update(pk, model);
        }
        return this.convertSetToArray(pkSet);
    }

    public HistoryUpdateResultParam innerUpdateModifyHistory(Context ctx, Connection cn, IObjectPK pk, IObjectValue model, HistoryParam hisParam) throws BOSException {
        HistoryUpdateResultParam result = new HistoryUpdateResultParam();
        HistoryEntityParam param = HistoryUtil.getHistoryEntityParam(ctx, model.getBOSType());
        HashSet<IObjectPK> pkSet = new HashSet<IObjectPK>();
        if (param.isNeedHistory()) {
            IObjectValue posInfo;
            IObjectValue currentHistoryVersion = HistoryUtil.getHistoryVersion(ctx, model.getBOSType(), pk);
            model.put(HistoryConstant.historyRelateID, (Object)BOSUuid.read((String)pk.toString()));
            PreOrPosInfo preposInfo = HistoryUtil.getPrePosInfo(ctx, cn, model, (IObjectPK)new ObjectUuidPK(currentHistoryVersion.get(HistoryConstant.ID).toString()));
            IObjectValue historyInfo = Utils.newObjectValueInstance(param.getHistoryEntityInfo());
            IORMappingDAO dao = HistoryUtil.getDao(ctx, cn, historyInfo);
            HistoryUtil.cloneInfo(preposInfo.getCurrentObj(), historyInfo);
            HistoryUtil.cloneInfo(model, historyInfo);
            HistoryUtil.swapHistoryKeyValue(historyInfo);
            historyInfo.put(HistoryConstant.ID, preposInfo.getCurrentObj().get(HistoryConstant.ID));
            Date currentStartDate = (Date)historyInfo.get(HistoryConstant.EFFDT);
            Date preStartDate = null;
            if (preposInfo.getPreObj() != null) {
                preStartDate = (Date)preposInfo.getPreObj().get(HistoryConstant.EFFDT);
            }
            Date posEndDate = null;
            if (preposInfo.getPosObj() != null) {
                posEndDate = (Date)preposInfo.getPosObj().get(HistoryConstant.EFFDT);
            }
            if (preStartDate != null && (preStartDate == null || !DateTimeUtils.dayAfter((Date)currentStartDate, (Date)preStartDate)) || posEndDate != null && (posEndDate == null || !DateTimeUtils.dayAfter((Date)posEndDate, (Date)currentStartDate))) {
                throw new BOSException("HIS-EFFDT:" + preStartDate + ",HIS-LEFFDT:" + posEndDate + ",message:effectdate is not fitable");
            }
            HistoryValidateUtil.validOneRecordHistoryDateAndCleanDate(historyInfo);
            dao.update((IObjectPK)new ObjectUuidPK(historyInfo.get(HistoryConstant.ID).toString()), historyInfo);
            result.setHistoryPK((IObjectPK)new ObjectUuidPK(historyInfo.get(HistoryConstant.ID).toString()));
            pkSet.add((IObjectPK)new ObjectUuidPK(historyInfo.get(HistoryConstant.ID).toString()));
            IObjectValue preInfo = preposInfo.getPreObj();
            if (preInfo != null && !DateTimeUtils.dayEquals((Date)HistoryUtil.getBeforeDay(hisParam.getEffectStartDate()), (Date)((Date)preInfo.get(HistoryConstant.LEFFDT)))) {
                preInfo.put(HistoryConstant.LEFFDT, (Object)HistoryUtil.getBeforeDay(hisParam.getEffectStartDate()));
                HistoryValidateUtil.validOneRecordHistoryDateAndCleanDate(preInfo);
                dao.update((IObjectPK)new ObjectUuidPK(preInfo.get(HistoryConstant.ID).toString()), preInfo);
                pkSet.add((IObjectPK)new ObjectUuidPK(preInfo.get(HistoryConstant.ID).toString()));
            }
            if ((posInfo = preposInfo.getPosObj()) != null && !DateTimeUtils.dayEquals((Date)HistoryUtil.getAfterDay((Date)historyInfo.get(HistoryConstant.LEFFDT)), (Date)((Date)posInfo.get(HistoryConstant.EFFDT)))) {
                posInfo.put(HistoryConstant.EFFDT, (Object)HistoryUtil.getAfterDay((Date)historyInfo.get(HistoryConstant.LEFFDT)));
                HistoryValidateUtil.validOneRecordHistoryDateAndCleanDate(posInfo);
                dao.update((IObjectPK)new ObjectUuidPK(posInfo.get(HistoryConstant.ID).toString()), posInfo);
                pkSet.add((IObjectPK)new ObjectUuidPK(posInfo.get(HistoryConstant.ID).toString()));
            }
        }
        result.setPks(this.convertSetToArray(pkSet));
        return result;
    }

    public HistoryUpdateResultParam innerUpdateModifyHistoryRevise(Context ctx, Connection cn, IObjectPK pk, IObjectValue model, HistoryParam hisParam) throws BOSException {
        HistoryUpdateResultParam result = new HistoryUpdateResultParam();
        HistoryEntityParam param = HistoryUtil.getHistoryEntityParam(ctx, model.getBOSType());
        HashSet<IObjectPK> pkSet = new HashSet<IObjectPK>();
        if (param.isNeedHistory()) {
            IObjectValue currentHistoryVersion = model;
            PreOrPosInfo preposInfo = null;
            if (currentHistoryVersion.get(HistoryConstant.historyRelateID) != null) {
                preposInfo = HistoryUtil.getPrePosInfo(ctx, cn, currentHistoryVersion, (IObjectPK)new ObjectUuidPK(currentHistoryVersion.get(HistoryConstant.ID).toString()));
            } else {
                IObjectCollection collection = HistoryUtil.getHistoryCollection(ctx, cn, model.getBOSType(), (IObjectPK)new ObjectUuidPK(currentHistoryVersion.get(HistoryConstant.ID).toString()));
                preposInfo = new PreOrPosInfo();
                preposInfo.setOldCurrentObj(currentHistoryVersion);
                if (collection.size() > 0) {
                    preposInfo.setCurrentObj(collection.getObject(0));
                    if (collection.size() > 1) {
                        preposInfo.setPreObj(collection.getObject(1));
                    }
                }
            }
            IObjectValue historyInfo = Utils.newObjectValueInstance(param.getHistoryEntityInfo());
            IORMappingDAO dao = HistoryUtil.getDao(ctx, cn, historyInfo);
            HistoryUtil.cloneInfo(preposInfo.getCurrentObj(), historyInfo);
            HistoryUtil.cloneInfo(currentHistoryVersion, historyInfo);
            HistoryUtil.swapHistoryKeyValue(historyInfo);
            historyInfo.put(HistoryConstant.ID, preposInfo.getCurrentObj().get(HistoryConstant.ID));
            if (historyInfo.get(HistoryConstant.LEFFDT) == null) {
                historyInfo.put(HistoryConstant.LEFFDT, (Object)HistoryUtil.getMaxDate());
            }
            Date currentStartDate = (Date)historyInfo.get(HistoryConstant.EFFDT);
            Date preStartDate = null;
            if (preposInfo.getPreObj() != null) {
                preStartDate = (Date)preposInfo.getPreObj().get(HistoryConstant.EFFDT);
            }
            Date posEndDate = null;
            if (preposInfo.getPosObj() != null) {
                posEndDate = (Date)preposInfo.getPosObj().get(HistoryConstant.EFFDT);
            }
            if (preStartDate != null && (preStartDate == null || !DateTimeUtils.dayAfter((Date)currentStartDate, (Date)preStartDate)) || posEndDate != null && (posEndDate == null || !DateTimeUtils.dayAfter((Date)posEndDate, (Date)currentStartDate))) {
                throw new BOSException("HIS-EFFDT:" + preStartDate + ",HIS-LEFFDT:" + posEndDate + ",message:effectdate is not fitable");
            }
            HistoryValidateUtil.validOneRecordHistoryDateAndCleanDate(historyInfo);
            dao.update((IObjectPK)new ObjectUuidPK(historyInfo.get(HistoryConstant.ID).toString()), historyInfo);
            result.setHistoryPK((IObjectPK)new ObjectUuidPK(historyInfo.get(HistoryConstant.ID).toString()));
            pkSet.add((IObjectPK)new ObjectUuidPK(historyInfo.get(HistoryConstant.ID).toString()));
            IObjectValue preInfo = preposInfo.getPreObj();
            if (preInfo != null && !DateTimeUtils.dayEquals((Date)HistoryUtil.getBeforeDay(hisParam.getEffectStartDate()), (Date)((Date)preInfo.get(HistoryConstant.LEFFDT)))) {
                preInfo.put(HistoryConstant.LEFFDT, (Object)HistoryUtil.getBeforeDay(hisParam.getEffectStartDate()));
                HistoryValidateUtil.validOneRecordHistoryDateAndCleanDate(preInfo);
                dao.update((IObjectPK)new ObjectUuidPK(preInfo.get(HistoryConstant.ID).toString()), preInfo);
                pkSet.add((IObjectPK)new ObjectUuidPK(preInfo.get(HistoryConstant.ID).toString()));
            }
        }
        result.setPks(this.convertSetToArray(pkSet));
        return result;
    }

    public HistoryUpdateResultParam innerUpdateModify(Context ctx, Connection cn, IObjectPK pk, IObjectValue model, HistoryParam hisParam) throws BOSException {
        HistoryUpdateResultParam result = new HistoryUpdateResultParam();
        HistoryEntityParam param = HistoryUtil.getHistoryEntityParam(ctx, model.getBOSType());
        HashSet<IObjectPK> pkSet = new HashSet<IObjectPK>();
        if (param.isNeedHistory()) {
            if (model.get(HistoryConstant.EFFDT) == null) {
                model.put(HistoryConstant.EFFDT, (Object)DateTimeUtils.truncateDate((Date)new Date()));
            }
            PreOrPosInfo preposInfo = HistoryUtil.getPrePosInfo(ctx, cn, model, pk, hisParam);
            IObjectValue historyInfo = null;
            if (preposInfo.getCurrentObj() != null && preposInfo.getCurrentObj().getDate(HistoryConstant.EFFDT) != null && DateTimeUtils.dayEquals((Date)preposInfo.getCurrentObj().getDate(HistoryConstant.EFFDT), (Date)model.getDate(HistoryConstant.EFFDT))) {
                historyInfo = HistoryUtil.updateCreateHistoryObj(hisParam, param.getCurrentEntityInfo(), param.getHistoryEntityInfo(), model, preposInfo.getCurrentObj());
                historyInfo.put(HistoryConstant.ID, preposInfo.getCurrentObj().get(HistoryConstant.ID));
            } else {
                historyInfo = HistoryUtil.updateCreateHistoryObj(hisParam, param.getCurrentEntityInfo(), param.getHistoryEntityInfo(), model, preposInfo.getOldCurrentObj());
            }
            HistoryValidateUtil.validOneRecordHistoryDateAndCleanDate(historyInfo);
            if (preposInfo.getPosObj() != null) {
                throw new BOSException("HIS-EFFDT:" + preposInfo.getPosObj().getDate(HistoryConstant.EFFDT) + ",HIS-LEFFDT:" + null + ",message:effectdate is not fitable");
            }
            IORMappingDAO dao = HistoryUtil.getDao(ctx, cn, historyInfo);
            IObjectPK hisPK = null;
            if (historyInfo.get(HistoryConstant.ID) != null) {
                hisPK = new ObjectUuidPK(historyInfo.get(HistoryConstant.ID).toString());
                dao.update(hisPK, historyInfo);
            } else {
                hisPK = dao.addnew(historyInfo);
                IObjectValue oldCurrentInfo = preposInfo.getCurrentObj();
                if (oldCurrentInfo != null) {
                    oldCurrentInfo.put(HistoryConstant.LEFFDT, (Object)HistoryUtil.getBeforeDay(hisParam.getEffectStartDate()));
                    HistoryValidateUtil.validOneRecordHistoryDateAndCleanDate(oldCurrentInfo);
                    dao.update((IObjectPK)new ObjectUuidPK(oldCurrentInfo.get(HistoryConstant.ID).toString()), oldCurrentInfo);
                    pkSet.add((IObjectPK)new ObjectUuidPK(oldCurrentInfo.get(HistoryConstant.ID).toString()));
                }
            }
            result.setHistoryPK(hisPK);
            pkSet.add(hisPK);
        }
        result.setPks(this.convertSetToArray(pkSet));
        return result;
    }
}

