/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.ejb;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ormapping.HistoryParam;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.Utils;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.framework.ejb.HistoryEntityParam;
import com.kingdee.bos.framework.ejb.HistoryObjectReader;
import com.kingdee.bos.framework.ejb.PreOrPosInfo;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.HistoryConstant;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.List;

public class HistoryUtil {
    public static Date getBeforeDay(Date thisDate) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(thisDate);
        ((Calendar)cal).add(5, -1);
        return cal.getTime();
    }

    public static Date getAfterDay(Date thisDate) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(thisDate);
        ((Calendar)cal).add(5, 1);
        return cal.getTime();
    }

    public static void cleanInfo(Context ctx, IObjectValue model) {
        String columnName;
        Date date;
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo bo = loader.getEntity(model.getBOSType());
        if (bo.getBusinessHistoryColumn() != null && (date = (Date)model.get(columnName = bo.getBusinessHistoryColumn().getName())) != null) {
            date = DateTimeUtils.truncateDate((Date)date);
            model.put(columnName, (Object)date);
        }
        if (model.get(HistoryConstant.EFFDT) != null) {
            model.put(HistoryConstant.EFFDT, (Object)DateTimeUtils.truncateDate((Date)((Date)model.get(HistoryConstant.EFFDT))));
        }
        if (model.get(HistoryConstant.LEFFDT) != null) {
            model.put(HistoryConstant.LEFFDT, (Object)DateTimeUtils.truncateDate((Date)((Date)model.get(HistoryConstant.LEFFDT))));
        }
    }

    public static EntityObjectInfo getHistoryEntityInfo(Context ctx, IObjectValue model) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo bo = loader.getEntity(model.getBOSType());
        return loader.getEntity((IMetaDataPK)new MetaDataPK(bo.getHisEntity()));
    }

    public static HistoryEntityParam getHistoryEntityParam(Context ctx, BOSObjectType type) {
        HistoryEntityParam param = new HistoryEntityParam();
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo bo = loader.getEntity(type);
        param.setCurrentEntityInfo(bo);
        if (bo.isNeedHistory() && bo.getHisEntity() != null) {
            param.setHistoryEntityInfo(loader.getEntity((IMetaDataPK)new MetaDataPK(bo.getHisEntity())));
        }
        return param;
    }

    public static String getHistoryTableByCurrentEntity(Context ctx, EntityObjectInfo currentBO) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        if (currentBO.getHisEntity() == null || currentBO.getHisEntity().trim().length() == 0) {
            return null;
        }
        EntityObjectInfo bo = loader.getEntity((IMetaDataPK)new MetaDataPK(currentBO.getHisEntity()));
        if (bo.getTable() == null) {
            return null;
        }
        return bo.getTable().getName();
    }

    public static List dpcToList(IObjectCollection dpc) {
        ArrayList<IObjectValue> list = new ArrayList<IObjectValue>();
        for (int i = 0; i < dpc.size(); ++i) {
            list.add(dpc.getObject(i));
        }
        return list;
    }

    public static String getHistoryRelateColumnCurrentEntity(Context ctx, EntityObjectInfo currentBO) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        if (currentBO.getHisEntity() == null || currentBO.getHisEntity().trim().length() == 0) {
            return null;
        }
        EntityObjectInfo bo = loader.getEntity((IMetaDataPK)new MetaDataPK(currentBO.getHisEntity()));
        PropertyInfo prop = bo.getPropertyByName(HistoryConstant.historyRelateID);
        if (prop != null && prop.getMappingField() != null) {
            return prop.getMappingField().getName();
        }
        return null;
    }

    public static IORMappingDAO getDao(Context ctx, Connection cn, IObjectValue historyInfo) {
        return ORMappingDAO.getInstance(historyInfo.getBOSType(), ctx, cn);
    }

    public static IORMappingDAO getDao(Context ctx, Connection cn, EntityObjectInfo entityInfo) {
        return ORMappingDAO.getInstance(entityInfo.getType(), ctx, cn);
    }

    public static IORMappingDAO getDao(Context ctx, Connection cn, BOSObjectType type) {
        return ORMappingDAO.getInstance(type, ctx, cn);
    }

    public static boolean needHistory(Context ctx, BOSObjectType type) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo bo = loader.getEntity(type);
        return bo.isNeedHistory();
    }

    public static IObjectValue addNewCreateHistoryObj(HistoryParam hisParam, EntityObjectInfo current, EntityObjectInfo history, IObjectValue currentInfo) {
        try {
            IObjectValue historyInfo = Utils.newObjectValueInstance(history);
            historyInfo = HistoryUtil.cloneInfo(currentInfo, historyInfo);
            historyInfo = HistoryUtil.swapHistoryKeyValue(historyInfo);
            historyInfo.put(HistoryConstant.EFFDT, (Object)hisParam.getEffectStartDate());
            historyInfo.put(HistoryConstant.LEFFDT, (Object)HistoryUtil.getMaxDate());
            return historyInfo;
        }
        catch (InvalidDAOMetaDataException e) {
            return null;
        }
    }

    public static IObjectValue updateCreateHistoryObj(HistoryParam hisParam, EntityObjectInfo current, EntityObjectInfo history, IObjectValue currentInfo, IObjectValue currentOldInfo) {
        try {
            IObjectValue historyInfo = Utils.newObjectValueInstance(history);
            historyInfo = HistoryUtil.cloneInfo(currentOldInfo, historyInfo);
            historyInfo = HistoryUtil.cloneInfo(currentInfo, historyInfo);
            historyInfo = HistoryUtil.swapHistoryKeyValue(historyInfo);
            historyInfo.put(HistoryConstant.EFFDT, (Object)hisParam.getEffectStartDate());
            historyInfo.put(HistoryConstant.LEFFDT, (Object)HistoryUtil.getMaxDate());
            historyInfo.put(HistoryConstant.ID, null);
            return historyInfo;
        }
        catch (InvalidDAOMetaDataException e) {
            return null;
        }
    }

    public static IObjectValue convertHistoryInfo(IObjectValue currentVO, IObjectValue historyVO) {
        return HistoryUtil.swapHistoryKeyValue(HistoryUtil.cloneInfo(currentVO, historyVO));
    }

    public static IObjectValue cloneInfo(IObjectValue fromVO, IObjectValue toVO) {
        Enumeration e = fromVO.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            toVO.put(key, fromVO.get(key));
        }
        return toVO;
    }

    public static IObjectValue swapHistoryKeyValue(IObjectValue vo) {
        Object temp = vo.get(HistoryConstant.ID);
        vo.put(HistoryConstant.ID, vo.get(HistoryConstant.historyRelateID));
        vo.put(HistoryConstant.historyRelateID, temp);
        return vo;
    }

    public static HistoryParam getHistoryParam(IObjectValue model) {
        HistoryParam param = new HistoryParam();
        param.parse(model.getExtendedProperty(HistoryConstant.historyKey));
        param.setEffectStartDate((Date)model.get(HistoryConstant.EFFDT));
        if (param.getEffectStartDate() == null) {
            param.setEffectStartDate(new Date());
        }
        return param;
    }

    public static Date getMaxDate() {
        try {
            return DateTimeUtils.parseDate((String)"2199-12-31");
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static PreOrPosInfo getPrePosInfo(Context ctx, Connection cn, IObjectValue model, IObjectPK currentPK, HistoryParam hisParam) throws DataAccessException {
        IObjectValue objectValue = ORMappingDAO.getInstance(model.getBOSType(), ctx, cn).getValue(currentPK);
        Date oldEffectStartDate = (Date)objectValue.get(HistoryConstant.EFFDT);
        if (oldEffectStartDate == null) {
            oldEffectStartDate = DateTimeUtils.truncateDate((Date)new Date());
        }
        IObjectCollection collection = HistoryUtil.getHistoryCollection(ctx, cn, model.getBOSType(), currentPK);
        PreOrPosInfo prePosInfo = new PreOrPosInfo();
        prePosInfo.parseByDate(collection, oldEffectStartDate);
        prePosInfo.setOldCurrentObj(objectValue);
        return prePosInfo;
    }

    public static PreOrPosInfo getPrePosInfo(Context ctx, Connection cn, IObjectValue model, IObjectPK currentPK) throws DataAccessException {
        IObjectValue objectValue = ORMappingDAO.getInstance(model.getBOSType(), ctx, cn).getValue(currentPK);
        IObjectCollection collection = HistoryUtil.getHistoryCollection(ctx, cn, model.getBOSType(), currentPK);
        PreOrPosInfo prePosInfo = new PreOrPosInfo();
        prePosInfo.parseByID(collection, model.get(HistoryConstant.historyRelateID).toString());
        prePosInfo.setOldCurrentObj(objectValue);
        return prePosInfo;
    }

    public static List getHistoryCollectionRetureCurrent(Context ctx, BOSObjectType bosType, EntityViewInfo view) throws BOSException {
        ArrayList<IObjectValue> historyList = new ArrayList<IObjectValue>();
        if (view == null) {
            view = new EntityViewInfo();
        }
        if (view.getSorter() == null || view.getSorter().size() == 0) {
            SorterItemInfo sorter = new SorterItemInfo(HistoryConstant.EFFDT);
            sorter.setSortType(SortType.DESCEND);
            view.getSorter().add(sorter);
        }
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection(ctx);
            HistoryEntityParam historyEntityParam = HistoryUtil.getHistoryEntityParam(ctx, bosType);
            IObjectCollection collection = HistoryUtil.getDao(ctx, cn, historyEntityParam.getHistoryEntityInfo()).getCollection(view);
            for (int i = 0; i < collection.size(); ++i) {
                IObjectValue currentInfo = Utils.newObjectValueInstance(historyEntityParam.getCurrentEntityInfo());
                historyList.add(HistoryUtil.convertHistoryInfo(collection.getObject(i), currentInfo));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        return historyList;
    }

    public static IObjectCollection getHistoryCollectionPaging(Context ctx, Connection cn, BOSObjectType bosType, IObjectPK pk, EntityViewInfo view, int start, int length) throws BOSException {
        BOSObjectType type;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(HistoryConstant.historyRelateID, (Object)pk.toString()));
        if (view == null) {
            view = new EntityViewInfo();
        }
        if (view.getFilter() == null) {
            view.setFilter(new FilterInfo());
        }
        view.getFilter().mergeFilter(filter, "AND");
        if (view.getSorter() == null || view.getSorter().size() == 0) {
            SorterItemInfo sorter = new SorterItemInfo(HistoryConstant.EFFDT);
            sorter.setSortType(SortType.DESCEND);
            view.getSorter().add(sorter);
        }
        if ((type = bosType) == null) {
            type = BOSUuid.read((String)pk.toString()).getType();
        }
        IObjectCollection collection = HistoryUtil.getDao(ctx, cn, HistoryUtil.getHistoryEntityParam(ctx, type).getHistoryEntityInfo()).getCollection(view, start, length);
        return collection;
    }

    public static IObjectCollection getHistoryCollection(Context ctx, Connection cn, BOSObjectType bosType, IObjectPK pk) throws DataAccessException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(HistoryConstant.historyRelateID, (Object)pk.toString()));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemInfo sorter = new SorterItemInfo(HistoryConstant.EFFDT);
        sorter.setSortType(SortType.DESCEND);
        view.getSorter().add(sorter);
        BOSObjectType type = bosType;
        if (type == null) {
            type = BOSUuid.read((String)pk.toString()).getType();
        }
        IObjectCollection collection = HistoryUtil.getDao(ctx, cn, HistoryUtil.getHistoryEntityParam(ctx, type).getHistoryEntityInfo()).getCollection(view);
        return collection;
    }

    public static int getHistoryCcount(Context ctx, Connection cn, BOSObjectType bosType, IObjectPK pk, EntityViewInfo view) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(HistoryConstant.historyRelateID, (Object)pk.toString()));
        if (view == null) {
            view = new EntityViewInfo();
        }
        if (view.getFilter() == null) {
            view.setFilter(new FilterInfo());
        }
        view.getFilter().mergeFilter(filter, "AND");
        BOSObjectType type = bosType;
        if (type == null) {
            type = BOSUuid.read((String)pk.toString()).getType();
        }
        int count = HistoryUtil.getDao(ctx, cn, HistoryUtil.getHistoryEntityParam(ctx, type).getHistoryEntityInfo()).getCount(view.getFilter());
        return count;
    }

    public static boolean historyExists(Context ctx, BOSObjectType bosType, String currentID, Date effectDate) throws BOSException {
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection(ctx);
            boolean bl = HistoryUtil.historyExists(ctx, cn, bosType, currentID, effectDate);
            return bl;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    public static boolean historyExists(Context ctx, Connection cn, BOSObjectType bosType, String currentID, Date effectDate) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(HistoryConstant.historyRelateID, (Object)currentID));
        filter.getFilterItems().add(new FilterItemInfo(HistoryConstant.EFFDT, (Object)effectDate, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo(HistoryConstant.LEFFDT, (Object)effectDate, CompareType.GREATER_EQUALS));
        return HistoryUtil.getDao(ctx, cn, HistoryUtil.getHistoryEntityParam((Context)ctx, (BOSObjectType)bosType).historyEntityInfo).exists(filter);
    }

    public static IObjectValue getHistoryVersion(Context ctx, BOSObjectType bosType, IObjectPK pk) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)pk.toString()));
        view.setFilter(filter);
        HistoryObjectReader hisoryObjectReader = new HistoryObjectReader();
        return hisoryObjectReader.getHistoryVersion(ctx, pk, view, bosType);
    }

    public static IObjectValue getHisValueByCurrentIDAndDate(Context ctx, IObjectPK pk, BOSObjectType bosType, Date EFFDT, SelectorItemCollection sic) throws BOSException {
        HistoryObjectReader objectReader = new HistoryObjectReader();
        return objectReader._getHisValueByCurrentIDAndDate(ctx, pk, bosType, EFFDT, sic);
    }
}

