/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.function;

import com.kingdee.bos.BOSClassNotFoundException;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ICommonBOSType;
import com.kingdee.bos.InvalidMetaDataException;
import com.kingdee.bos.MissingMetaDataException;
import com.kingdee.bos.ReflectException;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.framework.BOProxy;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.AccessLevel;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.bo.ParameterInfo;
import com.kingdee.bos.metadata.bo.TransactionAttribute;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.function.FunctionObjectCollection;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.exception.FriendlyBOSException;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;

public class FunctionInvoke {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.function.FunctionInvoke");

    private FunctionInvoke() {
    }

    public static Object localInvoke(Context ctx, IMetaDataPK pk, String operationName, Object[] args) throws BOSException {
        return FunctionInvoke.localInvoke(ctx, pk, operationName, args, false);
    }

    public static Object localInvoke(Context ctx, IMetaDataPK pk, String operationName, Object[] args, boolean isHandleEvent) throws BOSException {
        try {
            return FunctionInvoke.innerLocalInvoke(ctx, pk, operationName, args, isHandleEvent, true);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static String getContextMsg(Context ctx) {
        if (ctx == null) {
            return "Context[null]";
        }
        return "Context[solu:" + ctx.getSolution() + " ais:" + ctx.getAIS() + " metadataPath:" + StringUtils.arrayToString((Object[])Utils.getMetadataPath((Context)ctx), (String)",") + "], env_ais:" + ConfigMDUtil.getAIS();
    }

    public static Object localInvokeNoProxy(Context ctx, IMetaDataPK pk, String operationName, Object[] args) throws BOSException {
        try {
            return FunctionInvoke.innerLocalInvoke(ctx, pk, operationName, args, false, false);
        }
        catch (Exception e) {
            throw new BOSException("localInvoke error in " + FunctionInvoke.getContextMsg(ctx), (Throwable)e);
        }
    }

    public static Object innerLocalInvoke(Context ctx, IMetaDataPK pk, String operationName, Object[] args, boolean isHandleEvent, boolean useProxy) throws BOSException {
        if (ctx == null || pk == null || args == null) {
            throw new IllegalArgumentException("Parameters error!");
        }
        Function_Operation fo = FunctionInvoke.getFunctionAndOperation(ctx, pk, operationName);
        String innerID = fo.refMethod.getInnerID();
        MethodInfo method = fo.refBo.getInheritedMethodByID(innerID);
        if (method == null) {
            throw new InvalidMetaDataException("can't find method by innerID. refbo:" + fo.refBo.getFullName() + " methodID:" + innerID);
        }
        Object obj = BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)fo.refBo.getType());
        String methodName = "";
        Class[] parameterTypes = null;
        boolean controllerBeanInvoke = false;
        if (method.getAccessLevel() == AccessLevel.PUBLIC) {
            methodName = method.getName();
            ParameterCollection paramCol = method.getParameters();
            int length = paramCol.size();
            parameterTypes = new Class[length];
            for (int i = 0; i < length; ++i) {
                ParameterInfo param = paramCol.get(i);
                String temp = param.getDataType();
                if (temp.trim().equalsIgnoreCase(DataType.OBJECTVALUE.toString())) {
                    try {
                        parameterTypes[i] = FunctionInvoke.getObjectValueClazzByParam(ctx, param);
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        throw new BOSClassNotFoundException("Get param data type error.", (Throwable)e);
                    }
                }
                if (temp.trim().equalsIgnoreCase(DataType.OBJECTCOLLECTION.toString())) {
                    try {
                        parameterTypes[i] = FunctionInvoke.getObjectCollectionClazzByParam(ctx, param);
                        continue;
                    }
                    catch (ClassNotFoundException e2) {
                        throw new BOSClassNotFoundException("Get param data type error.", (Throwable)e2);
                    }
                }
                parameterTypes[i] = ObjectUtils.getArgumentTypeClass((String)temp);
            }
        }
        if (!useProxy && obj != null) {
            try {
                if (TransactionAttribute.REQUIRED.equals((Object)method.getTransactionAttribute())) {
                    Class<?> ctrlBeanClass = Class.forName(fo.refBo.getRuntimeBusinessControllerBean());
                    obj = ctrlBeanClass.newInstance();
                    if (obj instanceof ICommonBOSType) {
                        ((ICommonBOSType)obj).setBOSType(fo.refBo.getType());
                        ((ICommonBOSType)obj).setPK((IMetaDataPK)MetaDataPK.create((String)fo.refBo.getFullName()));
                    }
                    controllerBeanInvoke = true;
                }
            }
            catch (Throwable t) {
                logger.error((Object)("get controllerBean failed, obj class:\t" + obj.getClass().getName()), t);
            }
        }
        Class[] argsClasses = parameterTypes;
        Object[] argsValues = args;
        if (controllerBeanInvoke) {
            argsClasses = new Class[parameterTypes.length + 1];
            argsValues = new Object[args.length + 1];
            argsClasses[0] = Context.class;
            if (parameterTypes.length > 0) {
                System.arraycopy(parameterTypes, 0, argsClasses, 1, parameterTypes.length);
            }
            if (ctx != null) {
                ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
            }
            argsValues[0] = ctx;
            if (args.length > 0) {
                System.arraycopy(args, 0, argsValues, 1, args.length);
            }
        }
        if (argsClasses.length != argsValues.length) {
            FunctionInvoke.throwFriendlyBOSException("BOSFramework_invokeFunction_paramSizeNotMatched", fo.function.getAlias(), fo.function.getFullName(), fo.operation.getAlias(), fo.operation.getName());
        }
        if (!isHandleEvent) {
            WfEventListenerStateManager.getInstance().disableEventListener();
        }
        Method runMethod = null;
        try {
            runMethod = FunctionInvoke.getMethod(obj, methodName, argsClasses);
        }
        catch (Exception e) {
            BOProxy bop = BOProxy.getProxy(ctx, (IMetaDataPK)MetaDataPK.create((String)fo.refBo.getFullName()));
            try {
                Object e2 = bop.callCmethod(method, args);
                return e2;
            }
            catch (Throwable e1) {
                throw new BOSException(e1);
            }
            finally {
                WfEventListenerStateManager.getInstance().enableEventListener();
            }
        }
        Object returnObj = null;
        try {
            returnObj = runMethod.invoke(obj, argsValues);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable e = invocationTargetException.getTargetException();
            if (e instanceof BOSException) {
                throw (BOSException)e;
            }
            throw new BOSException(e);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectException((Throwable)illegalAccessException);
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
        return returnObj;
    }

    private static Class getObjectValueClazzByParam(Context ctx, ParameterInfo param) throws ClassNotFoundException {
        String metaRef = param.getMetaDataRef();
        String metaPack = metaRef.substring(0, metaRef.lastIndexOf(46));
        String metaName = metaRef.substring(metaRef.lastIndexOf(46) + 1);
        MetaDataPK metaPK = MetaDataPK.create((String)metaPack, (String)metaName);
        EntityObjectInfo entity = MetaDataLoader.getEntity((Context)ctx, (IMetaDataPK)metaPK);
        return entity.getObjectValueClazzRuntime();
    }

    private static Class getObjectCollectionClazzByParam(Context ctx, ParameterInfo param) throws ClassNotFoundException {
        String metaRef = param.getMetaDataRef();
        String metaPack = metaRef.substring(0, metaRef.lastIndexOf(46));
        String metaName = metaRef.substring(metaRef.lastIndexOf(46) + 1);
        MetaDataPK metaPK = MetaDataPK.create((String)metaPack, (String)metaName);
        EntityObjectInfo entity = MetaDataLoader.getEntity((Context)ctx, (IMetaDataPK)metaPK);
        return entity.getObjectCollectionClazzRuntime();
    }

    public static Map getOperation(Context ctx, IMetaDataPK uiPK) throws BOSException {
        return FunctionInvoke.getOperation(ctx, uiPK, null);
    }

    public static Map getOperation(Context ctx, IMetaDataPK uiPK, String actionName) throws BOSException {
        if (uiPK == null) {
            throw new IllegalArgumentException("Parameter error!");
        }
        FunctionObjectCollection funcCol = FunctionInvoke.getRemoteFunctionRef(ctx, uiPK, MetaDataTypeList.UIOBJECT);
        if (funcCol == null) {
            throw new MissingMetaDataException("Get FunctionObject Collection error!");
        }
        Hashtable<String, OperationInfo> map = new Hashtable<String, OperationInfo>();
        int lengthFunc = funcCol.size();
        for (int i = 0; i < lengthFunc; ++i) {
            FunctionObjectInfo function = funcCol.get(i);
            OperationCollection operCol = function.getOperation();
            int lengthOper = operCol.size();
            for (int j = 0; j < lengthOper; ++j) {
                OperationInfo oper = operCol.get(j);
                if (actionName == null) {
                    map.put(function.toString() + "-" + j, oper);
                    continue;
                }
                if (oper.getUiActionRef() == null || !StringUtils.equalsIgnoreCase((String)oper.getUiActionRef().getActionRefName(), (String)actionName)) continue;
                map.put(function.toString() + "-" + oper.getUiActionRef().getUIStatus(), oper);
            }
        }
        return map;
    }

    public static FunctionObjectCollection getRemoteFunctionRef(Context ctx, IMetaDataPK refPK, BOSObjectType bosType) throws BOSException {
        if (refPK == null) {
            throw new IllegalArgumentException("Parameter error! refPK is null.");
        }
        FunctionObjectInfo function = null;
        FunctionObjectCollection reFuncCol = new FunctionObjectCollection();
        FunctionObjectCollection funcCol = FunctionInvoke.getFunctions(ctx);
        int length = funcCol.size();
        for (int i = 0; i < length; ++i) {
            function = funcCol.get(i);
            OperationCollection opers = function.getOperation();
            if (opers == null) {
                logger.error((Object)("ERROR:no operations in function :" + function.getName()));
                continue;
            }
            int size = opers.size();
            for (int j = 0; j < size; ++j) {
                OperationInfo oper = opers.get(j);
                if (oper == null) {
                    logger.error((Object)("ERROR:operation is null. function :" + function.getName()));
                    continue;
                }
                if (bosType == MetaDataTypeList.ENTITY && oper.getEntityObjectRef() != null) {
                    if (!StringUtils.equalsIgnoreCase((String)(oper.getEntityObjectRef().getPackage() + "." + oper.getEntityObjectRef().getName()), (String)(refPK.getPackage() + "." + refPK.getName()))) continue;
                    reFuncCol.add(function);
                    continue;
                }
                if (bosType == MetaDataTypeList.FACADE && oper.getFacadeObjectRef() != null) {
                    if (!StringUtils.equalsIgnoreCase((String)(oper.getFacadeObjectRef().getPackage() + "." + oper.getFacadeObjectRef().getName()), (String)(refPK.getPackage() + "." + refPK.getName()))) continue;
                    reFuncCol.add(function);
                    continue;
                }
                if (bosType != MetaDataTypeList.UIOBJECT || oper.getUiActionRef() == null) continue;
                UIObjectInfo uiObjectInfo = oper.getUiActionRef().getUIObjectRef();
                if (uiObjectInfo == null) {
                    logger.error((Object)("UIObject not found! Please check Function[" + function.getFullName() + "] 's " + "UIAction [" + oper.getUiActionRef().getActionRefName() + "]."));
                    continue;
                }
                if (!StringUtils.equalsIgnoreCase((String)(uiObjectInfo.getPackage() + "." + uiObjectInfo.getName()), (String)(refPK.getPackage() + "." + refPK.getName()))) continue;
                reFuncCol.add(function);
            }
        }
        if (reFuncCol.size() == 0) {
            throw new MissingMetaDataException("Error! Don't Found MetaData Object: " + refPK.getPackage() + "." + refPK.getName());
        }
        return reFuncCol;
    }

    private static OperationInfo getOperation(FunctionObjectInfo function, String operationName) throws BOSException {
        if (function == null) {
            throw new IllegalArgumentException("FunctionInvoke is null!");
        }
        OperationCollection operCol = function.getOperation();
        OperationInfo oper = null;
        if (operCol != null) {
            int length = operCol.size();
            for (int i = 0; i < length; ++i) {
                if (!StringUtils.equalsIgnoreCase((String)operCol.get(i).getName(), (String)operationName)) continue;
                oper = operCol.get(i);
                break;
            }
        }
        return oper;
    }

    private static Method getMethod(Object obj, String methodName, Class[] parameterTypes) throws BOSException {
        if (obj == null || parameterTypes == null) {
            throw new IllegalArgumentException("Parameters error!");
        }
        try {
            return obj.getClass().getMethod(methodName, parameterTypes);
        }
        catch (SecurityException securityException) {
            throw new ReflectException((Throwable)securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ReflectException((Throwable)noSuchMethodException);
        }
    }

    private static Function_Operation getFunctionAndOperation(Context ctx, IMetaDataPK pk, String operationName) throws BOSException {
        String msg;
        if (ctx == null || pk == null || operationName == null) {
            throw new IllegalArgumentException("Get function and operation error. One is null. Funtction:" + pk + " Operation:" + operationName);
        }
        FunctionObjectInfo function = FunctionInvoke.getFunction(ctx, pk);
        if (function == null) {
            FunctionInvoke.throwFriendlyBOSException("BOSFramework_invokeFunction_functionNotFound", pk.getFullName());
        }
        OperationInfo operation = FunctionInvoke.getOperation(function, operationName);
        BusinessObjectInfo bo = null;
        MethodInfo method = null;
        if (operation != null) {
            bo = operation.getBORef();
            method = operation.getMethodRef();
        } else {
            FunctionInvoke.throwFriendlyBOSException("BOSFramework_invokeFunction_operationNotFound", function.getAlias(), pk.getFullName(), operationName);
        }
        if (operation.getEventRef() == null) {
            msg = "BOSFramework_invokeFunction_eventNotFound";
            FunctionInvoke.throwFriendlyBOSException(msg, function.getAlias(), pk.getFullName(), operation.getAlias(), operationName, operation.getEvent(), operation.getEntityObjectRef() == null ? "entityRef is null" : operation.getEntityObjectRef().getFullName());
        }
        if (bo == null || bo.getType() == null) {
            msg = "BOSFramework_invokeFunction_boNotFound";
            if (method == null) {
                msg = "BOSFramework_invokeFunction_boAndMethodNotFound";
            }
            FunctionInvoke.throwFriendlyBOSException(msg, function.getAlias(), pk.getFullName(), operation.getAlias(), operationName, operation.getEventMethod());
        }
        if (method == null) {
            FunctionInvoke.throwFriendlyBOSException("BOSFramework_invokeFunction_methodNotFound", function.getAlias(), pk.getFullName(), operation.getAlias(), operationName);
        }
        return new Function_Operation(function, operation, bo, method);
    }

    public static FunctionObjectInfo getFunction(Context ctx, IMetaDataPK pk) throws BOSException {
        return MetaDataLoader.getFunction((Context)ctx, (IMetaDataPK)pk);
    }

    private static FunctionObjectCollection getFunctions(Context ctx) throws BOSException {
        return MetaDataLoader.getFunctions((Context)ctx);
    }

    private static void throwFriendlyBOSException(String name, String ... args) throws FriendlyBOSException {
        FriendlyBOSException exception = new FriendlyBOSException(name, null, null);
        StringBuffer str = new StringBuffer(name);
        str.append("\n ");
        str.append(FunctionInvoke.getContextMsg(ConfigMDUtil.getContext()));
        str.append("\n args:\n----");
        for (String arg : args) {
            exception.addArg(arg);
            str.append("\n -");
            str.append(arg);
        }
        str.append("\n----");
        logger.error((Object)("function invoke error. ID:" + str), (Throwable)exception);
        throw exception;
    }

    static class Function_Operation {
        final FunctionObjectInfo function;
        final OperationInfo operation;
        final BusinessObjectInfo refBo;
        final MethodInfo refMethod;

        Function_Operation(FunctionObjectInfo function, OperationInfo operation, BusinessObjectInfo refBo, MethodInfo refMethod) {
            this.function = function;
            this.operation = operation;
            this.refBo = refBo;
            this.refMethod = refMethod;
        }
    }
}

