/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service;

import com.kingdee.bos.service.ICommonServiceManager;
import com.kingdee.util.Configuration;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class ServiceManagerAdapter {
    private Logger logger = Logger.getLogger(ServiceManagerAdapter.class);
    private Map managers = new HashMap();
    private Map initedMap = new HashMap();
    private static ServiceManagerAdapter instance = new ServiceManagerAdapter();
    private static final String store_file = "serviceManagerStore.xml";

    public static ServiceManagerAdapter getInstance() {
        return instance;
    }

    private ServiceManagerAdapter() {
    }

    public ICommonServiceManager getServiceManager(String type) {
        type = type.trim().toLowerCase();
        ICommonServiceManager manager = (ICommonServiceManager)this.managers.get(type);
        Boolean inited = (Boolean)this.initedMap.get(type);
        if (inited == null || !inited.booleanValue()) {
            try {
                manager.init();
                this.initedMap.put(type, Boolean.TRUE);
                return manager;
            }
            catch (Exception e) {
                this.logger.warn((Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return manager;
    }

    public Map listRegistered() {
        HashMap map = new HashMap();
        for (Object key : this.managers.keySet()) {
            Object value = this.managers.get(key);
            if (value == null) continue;
            map.put(key, value.getClass());
        }
        return map;
    }

    public void register(String type, String cls) throws Exception {
        if (cls == null || cls.trim().length() == 0) {
            throw new Exception("Can not register ServiceManager, invalid class:" + cls);
        }
        if (type == null || type.trim().length() == 0) {
            throw new Exception("Cant not reigster ServiceManager, invalid type:" + type);
        }
        Class<?> clss = Class.forName(cls);
        ICommonServiceManager serviceManager = (ICommonServiceManager)clss.newInstance();
        this.managers.put(type.trim().toLowerCase(), serviceManager);
    }

    public boolean unregister(String type) {
        ICommonServiceManager manager = (ICommonServiceManager)this.managers.remove(type);
        if (manager != null) {
            manager.destory();
            return true;
        }
        return false;
    }

    public void load() throws Exception {
        File file = Configuration.getServerRoot();
        if (file.exists()) {
            file = new File(file.getParentFile().getAbsoluteFile() + File.separator + "config" + File.separator + store_file);
        }
        if (!file.exists()) {
            URL url = this.getClass().getClassLoader().getResource(store_file);
            if (url == null) {
                url = ServiceManagerAdapter.class.getResource(store_file);
            }
            if (url == null) {
                url = ClassLoader.getSystemResource(store_file);
            }
            if (url == null) {
                this.logger.warn((Object)"can't load registered service manager. can't find file:serviceManagerStore.xml");
                return;
            }
            file = new File(url.getFile());
        }
        SAXBuilder builder = new SAXBuilder();
        Element root = builder.build(file).getRootElement();
        List managerEls = root.getChildren("manager");
        for (Element managerEl : managerEls) {
            String type = managerEl.getAttributeValue("type");
            String cls = managerEl.getText();
            try {
                this.register(type, cls);
            }
            catch (Exception ex) {
                this.logger.error((Object)ex);
            }
        }
    }

    public void store() throws Exception {
        URL url = this.getClass().getClassLoader().getResource(store_file);
        if (url == null) {
            url = ClassLoader.getSystemResource(store_file);
        }
        File file = new File(url.getFile());
        Element root = new Element("managers");
        for (Object type : this.managers.keySet()) {
            Object value = this.managers.get(type);
            Element managerEl = new Element("manager");
            managerEl.setText(value.getClass().getName());
            managerEl.setAttribute("type", type.toString());
            root.addContent(managerEl);
        }
        Document doc = new Document();
        doc.setRootElement(root);
        XMLOutputter outputter = new XMLOutputter("  ", true);
        FileWriter writer = new FileWriter(file);
        outputter.output(doc, (Writer)writer);
    }

    public void storeServices() {
        Iterator i = this.managers.keySet().iterator();
        while (i.hasNext()) {
            ICommonServiceManager manager = (ICommonServiceManager)this.managers.get(i.next());
            try {
                manager.store();
            }
            catch (Exception ex) {
                this.logger.error((Object)ex);
            }
        }
    }
}

