/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.simulation.ormapping;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.simulation.ormapping.OrmappingDAOProxy;
import com.kingdee.bos.threadcache.Pair;
import com.kingdee.bos.threadcache.ormapping.IORMappingDAOCacheable;
import com.kingdee.bos.threadcache.ormapping.OrmappingDAOThreadLocalObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Collector {
    private HashMap rootMap = new HashMap();
    private OrmappingDAOThreadLocalObject localCache = new OrmappingDAOThreadLocalObject();
    boolean changed = true;
    private Object NULL = new Object();

    private HashMap getBosTypeMap(BOSObjectType bosType) {
        HashMap bosTypeMap = (HashMap)this.rootMap.get(bosType);
        if (bosTypeMap == null) {
            bosTypeMap = new HashMap();
            this.rootMap.put(bosType, bosTypeMap);
        }
        return bosTypeMap;
    }

    private ArrayList getTypeList(BOSObjectType bosType, Object key) {
        HashMap bosTypeMap = this.getBosTypeMap(bosType);
        ArrayList list = (ArrayList)bosTypeMap.get(key);
        if (list == null) {
            list = new ArrayList();
            bosTypeMap.put(key, list);
        }
        return list;
    }

    private void addPK(BOSObjectType bosType, Object key, IObjectPK pk) {
        ArrayList list = this.getTypeList(bosType, key);
        if (!list.contains(pk)) {
            list.add(pk);
        }
    }

    public void addGetValueIntent(BOSObjectType bosType, IObjectPK pk) throws DataAccessException {
        Pair key = new Pair("");
        this.addPK(bosType, key, pk);
    }

    public void addGetValueIntent(BOSObjectType bosType, IObjectPK pk, SorterItemCollection sorter) throws DataAccessException {
        Pair key = new Pair("1", sorter.clone());
        this.addPK(bosType, key, pk);
    }

    public void addGetValueIntent(BOSObjectType bosType, IObjectPK pk, SelectorItemCollection selector) throws DataAccessException {
        Pair key = new Pair("0", selector.clone());
        this.addPK(bosType, key, pk);
    }

    public void addGetValueIntent(BOSObjectType bosType, IObjectPK pk, SelectorItemCollection selector, SorterItemCollection sorter) throws DataAccessException {
        Pair key = new Pair("01", selector.clone(), sorter.clone());
        this.addPK(bosType, key, pk);
    }

    public void addGetValueIntent(BOSObjectType bosType, IObjectPK pk, SelectorItemCollection selector, SorterItemCollection sorter, boolean isBaseOnSelector) throws DataAccessException {
        Pair key = new Pair("012", selector.clone(), sorter.clone(), isBaseOnSelector);
        this.addPK(bosType, key, pk);
    }

    public void addGetValueIntent(BOSObjectType bosType, IObjectPK pk, SelectorItemCollection selector, boolean isBaseOnSelector) throws DataAccessException {
        Pair key = new Pair("02", selector.clone(), isBaseOnSelector);
        this.addPK(bosType, key, pk);
    }

    public boolean needContinueLoop() {
        return this.changed;
    }

    public void process(Context context, Connection cn) throws DataAccessException {
        if (this.rootMap.isEmpty()) {
            return;
        }
        this.changed = false;
        ArrayList<BOSObjectType> processedType = new ArrayList<BOSObjectType>();
        for (Map.Entry entry : this.rootMap.entrySet()) {
            BOSObjectType bosType = (BOSObjectType)entry.getKey();
            HashMap map = (HashMap)entry.getValue();
            IORMappingDAO dao = ORMappingDAO.getInstance(bosType, context, cn);
            if (dao instanceof OrmappingDAOProxy) {
                dao = ((OrmappingDAOProxy)dao).innerDAO;
            }
            if (this.procoessBosType(map, dao)) continue;
            processedType.add(bosType);
        }
        if (processedType.size() > 0) {
            Iterator iter = processedType.iterator();
            while (iter.hasNext()) {
                this.rootMap.remove(iter.next());
            }
        }
    }

    private boolean procoessBosType(HashMap map, IORMappingDAO dao) throws DataAccessException {
        boolean hasSingle = false;
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            ArrayList values = (ArrayList)entry.getValue();
            if (values.size() > 1) {
                this.processKey(key, values, dao);
                continue;
            }
            hasSingle = true;
        }
        return hasSingle;
    }

    private void processKey(Object key, ArrayList values, IORMappingDAO dao) throws DataAccessException {
        EntityViewInfo view = new EntityViewInfo();
        Boolean isBaseOnSelector = null;
        Object[] keys = ((Pair)key).items;
        String methodSign = (String)keys[0];
        for (int i = 1; i < keys.length; ++i) {
            if (keys[i] instanceof Boolean) {
                isBaseOnSelector = (Boolean)keys[i];
                continue;
            }
            this.generateEntityView(view, keys[i]);
        }
        this.generateEntityView(view, values, dao);
        IObjectCollection collection = isBaseOnSelector == null ? dao.getCollection(view) : dao.getCollection(view, (boolean)isBaseOnSelector);
        IORMappingDAOCacheable cache = null;
        if (dao instanceof IORMappingDAOCacheable) {
            cache = (IORMappingDAOCacheable)((Object)dao);
        }
        if (collection.size() > 0) {
            this.changed = true;
        }
        for (IObjectValue value : collection) {
            ObjectUuidPK pk = new ObjectUuidPK(value.getString("id"));
            if (cache != null) {
                this.setCache(methodSign, keys, (IObjectPK)pk, value, isBaseOnSelector, cache);
                continue;
            }
            this.setLocalCache(methodSign, keys, (IObjectPK)pk, value, isBaseOnSelector, dao.getType());
        }
    }

    private void setLocalCache(String methodSign, Object[] keys, IObjectPK pk, IObjectValue value, Boolean isBaseOnSelector, BOSObjectType bosType) {
        Object[] keys2 = new Object[keys.length + 1];
        keys2[0] = bosType;
        keys2[1] = pk;
        System.arraycopy(keys, 1, keys2, 2, keys.length - 1);
        this.localCache.putValue(new Pair(keys2), value == null ? this.NULL : value);
    }

    private void setCache(String methodSign, Object[] keys, IObjectPK pk, IObjectValue value, Boolean isBaseOnSelector, IORMappingDAOCacheable cache) throws DataAccessException {
        if ("".equals(methodSign)) {
            cache.setValueCache(pk, value);
        } else if ("0".equals(methodSign)) {
            cache.setValueCache(pk, (SelectorItemCollection)keys[1], value);
        } else if ("1".equals(methodSign)) {
            cache.setValueCache(pk, (SorterItemCollection)keys[1], value);
        } else if ("01".equals(methodSign)) {
            cache.setValueCache(pk, (SelectorItemCollection)keys[1], (SorterItemCollection)keys[2], value);
        } else if ("02".equals(methodSign)) {
            cache.setValueCache(pk, (SelectorItemCollection)keys[1], isBaseOnSelector, value);
        } else if ("012".equals(methodSign)) {
            cache.setValueCache(pk, (SelectorItemCollection)keys[1], (SorterItemCollection)keys[2], isBaseOnSelector, value);
        }
    }

    private void generateEntityView(EntityViewInfo view, Object key) {
        if (key instanceof SelectorItemCollection) {
            view.setSelector((SelectorItemCollection)key);
        } else if (key instanceof SorterItemCollection) {
            view.setSorter((SorterItemCollection)key);
        }
    }

    private void generateEntityView(EntityViewInfo view, ArrayList values, IORMappingDAO dao) {
        FilterInfo filterInfo = new FilterInfo();
        String strPKLists = StringUtils.arrayToString((Object[])values.toArray(), (String)",");
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strPKLists, CompareType.INCLUDE));
        view.setFilter(filterInfo);
    }

    public IObjectValue getLocalCacheValue(BOSObjectType bosType, IObjectPK pk) throws DataAccessException {
        Pair key = new Pair(bosType, pk);
        Object value = this.localCache.getValue(key);
        if (value == this.NULL) {
            return null;
        }
        return (IObjectValue)value;
    }

    public IObjectValue getLocalCacheValue(BOSObjectType bosType, IObjectPK pk, SorterItemCollection sorter) throws DataAccessException {
        Pair key = new Pair(bosType, pk, sorter);
        Object value = this.localCache.getValue(key);
        if (value == this.NULL) {
            return null;
        }
        return (IObjectValue)value;
    }

    public IObjectValue getLocalCacheValue(BOSObjectType bosType, IObjectPK pk, SelectorItemCollection selector) throws DataAccessException {
        Pair key = new Pair(bosType, pk, selector);
        Object value = this.localCache.getValue(key);
        if (value == this.NULL) {
            return null;
        }
        return (IObjectValue)value;
    }

    public IObjectValue getLocalCacheValue(BOSObjectType bosType, IObjectPK pk, SelectorItemCollection selector, SorterItemCollection sorter) throws DataAccessException {
        Pair key = new Pair(bosType, pk, selector, sorter);
        Object value = this.localCache.getValue(key);
        if (value == this.NULL) {
            return null;
        }
        return (IObjectValue)value;
    }

    public IObjectValue getLocalCacheValue(BOSObjectType bosType, IObjectPK pk, SelectorItemCollection selector, SorterItemCollection sorter, boolean isBaseOnSelector) throws DataAccessException {
        Pair key = new Pair(bosType, pk, selector, sorter, isBaseOnSelector);
        Object value = this.localCache.getValue(key);
        if (value == this.NULL) {
            return null;
        }
        return (IObjectValue)value;
    }

    public IObjectValue getLocalCacheValue(BOSObjectType bosType, IObjectPK pk, SelectorItemCollection selector, boolean isBaseOnSelector) throws DataAccessException {
        Pair key = new Pair(bosType, pk, selector, isBaseOnSelector);
        Object value = this.localCache.getValue(key);
        if (value == this.NULL) {
            return null;
        }
        return (IObjectValue)value;
    }
}

