/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.simulation.ormapping;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.simulation.SimulationExecutor;
import com.kingdee.bos.simulation.SimulationManager;
import com.kingdee.bos.simulation.ormapping.Collector;
import com.kingdee.bos.simulation.ormapping.OrmappingSimulationContext;
import com.kingdee.bos.threadcache.ormapping.IORMappingDAOCacheable;
import com.kingdee.bos.util.BOSObjectType;

public class OrmappingDAOProxy
implements IORMappingDAO {
    IORMappingDAO innerDAO;
    private boolean isThreadCached;
    private IORMappingDAOCacheable innerDAOCacheable;
    private OrmappingSimulationContext context;
    private Collector collector;
    BOSObjectType bosType;

    public OrmappingDAOProxy(IORMappingDAO innerDAO) {
        this.innerDAO = innerDAO;
        if (innerDAO instanceof IORMappingDAOCacheable) {
            this.innerDAOCacheable = (IORMappingDAOCacheable)((Object)innerDAO);
            this.isThreadCached = true;
        }
        this.context = this.getSimulationContext();
        this.collector = this.context.getCollector();
        this.bosType = innerDAO.getType();
    }

    public BOSObjectType getType() {
        return this.bosType;
    }

    public Context getContext() {
        return this.innerDAO.getContext();
    }

    private boolean isRunning() {
        SimulationExecutor executor = SimulationManager.getExecutor((String)"ORMAPPING");
        return executor.isRunning();
    }

    private OrmappingSimulationContext getSimulationContext() {
        SimulationExecutor executor = SimulationManager.getExecutor((String)"ORMAPPING");
        return (OrmappingSimulationContext)executor.getContext();
    }

    public boolean exists(IObjectPK pk) throws DataAccessException {
        return this.innerDAO.exists(pk);
    }

    public IObjectValue getValue(IObjectPK pk) throws DataAccessException {
        if (this.isThreadCached && this.innerDAOCacheable.valueCached(pk)) {
            return this.innerDAO.getValue(pk);
        }
        IObjectValue value = null;
        if (this.context.getLoopTimes() == 0) {
            this.collector.addGetValueIntent(this.bosType, pk);
            return null;
        }
        if ("FINISHED".equals(this.context.getStage())) {
            if (!this.isThreadCached) {
                return this.collector.getLocalCacheValue(this.bosType, pk);
            }
        } else {
            if (!this.isThreadCached) {
                value = this.collector.getLocalCacheValue(this.bosType, pk);
            }
            if (value == null) {
                this.collector.addGetValueIntent(this.bosType, pk);
            }
            return value;
        }
        return null;
    }

    public IObjectPK addnew(IObjectValue value) throws DataAccessException {
        return null;
    }

    public void addnew(IObjectPK pk, IObjectValue value) throws DataAccessException {
    }

    public void update(IObjectPK pk, IObjectValue value) throws DataAccessException {
    }

    public void delete(IObjectPK pk) throws DataAccessException {
    }

    public IObjectPK[] getPKList() throws DataAccessException {
        return this.innerDAO.getPKList();
    }

    public IObjectCollection getCollection() throws DataAccessException {
        return this.innerDAO.getCollection();
    }

    @Override
    public IObjectValue getValue(IObjectPK pk, SorterItemCollection sorter) throws DataAccessException {
        if (this.isThreadCached && this.innerDAOCacheable.valueCached(pk, sorter)) {
            return this.innerDAO.getValue(pk, sorter);
        }
        IObjectValue value = null;
        if (this.context.getLoopTimes() == 0) {
            this.collector.addGetValueIntent(this.bosType, pk, sorter);
            return null;
        }
        if ("FINISHED".equals(this.context.getStage())) {
            if (!this.isThreadCached) {
                return this.collector.getLocalCacheValue(this.bosType, pk, sorter);
            }
        } else {
            if (!this.isThreadCached) {
                value = this.collector.getLocalCacheValue(this.bosType, pk, sorter);
            }
            if (value == null) {
                this.collector.addGetValueIntent(this.bosType, pk, sorter);
            }
            return value;
        }
        return null;
    }

    @Override
    public IObjectValue getValue(IObjectPK pk, SelectorItemCollection selector) throws DataAccessException {
        if (this.isThreadCached && this.innerDAOCacheable.valueCached(pk, selector)) {
            return this.innerDAO.getValue(pk, selector);
        }
        IObjectValue value = null;
        if (this.context.getLoopTimes() == 0) {
            this.collector.addGetValueIntent(this.bosType, pk, selector);
            return null;
        }
        if ("FINISHED".equals(this.context.getStage())) {
            if (!this.isThreadCached) {
                return this.collector.getLocalCacheValue(this.bosType, pk, selector);
            }
        } else {
            if (!this.isThreadCached) {
                value = this.collector.getLocalCacheValue(this.bosType, pk, selector);
            }
            if (value == null) {
                this.collector.addGetValueIntent(this.bosType, pk, selector);
            }
            return value;
        }
        return null;
    }

    @Override
    public IObjectValue getValue(IObjectPK pk, SelectorItemCollection selector, SorterItemCollection sorter) throws DataAccessException {
        if (this.isThreadCached && this.innerDAOCacheable.valueCached(pk, selector, sorter)) {
            return this.innerDAO.getValue(pk, selector, sorter);
        }
        IObjectValue value = null;
        if (this.context.getLoopTimes() == 0) {
            this.collector.addGetValueIntent(this.bosType, pk, selector, sorter);
            return null;
        }
        if ("FINISHED".equals(this.context.getStage())) {
            if (!this.isThreadCached) {
                return this.collector.getLocalCacheValue(this.bosType, pk, selector, sorter);
            }
        } else {
            if (!this.isThreadCached) {
                value = this.collector.getLocalCacheValue(this.bosType, pk, selector, sorter);
            }
            if (value == null) {
                this.collector.addGetValueIntent(this.bosType, pk, selector, sorter);
            }
            return value;
        }
        return null;
    }

    @Override
    public IObjectValue getValue(IObjectPK pk, SelectorItemCollection selector, SorterItemCollection sorter, boolean isBaseOnSelector) throws DataAccessException {
        if (this.isThreadCached && this.innerDAOCacheable.valueCached(pk, selector, sorter, isBaseOnSelector)) {
            return this.innerDAO.getValue(pk, selector, sorter, isBaseOnSelector);
        }
        IObjectValue value = null;
        if (this.context.getLoopTimes() == 0) {
            this.collector.addGetValueIntent(this.bosType, pk, selector, sorter, isBaseOnSelector);
            return null;
        }
        if ("FINISHED".equals(this.context.getStage())) {
            if (!this.isThreadCached) {
                return this.collector.getLocalCacheValue(this.bosType, pk, selector, sorter, isBaseOnSelector);
            }
        } else {
            if (!this.isThreadCached) {
                value = this.collector.getLocalCacheValue(this.bosType, pk, selector, sorter, isBaseOnSelector);
            }
            if (value == null) {
                this.collector.addGetValueIntent(this.bosType, pk, selector, sorter, isBaseOnSelector);
            }
            return value;
        }
        return null;
    }

    @Override
    public IObjectValue getValue(IObjectPK pk, SelectorItemCollection selector, boolean isBaseOnSelector) throws DataAccessException {
        if (this.isThreadCached && this.innerDAOCacheable.valueCached(pk, selector, isBaseOnSelector)) {
            return this.innerDAO.getValue(pk, selector, isBaseOnSelector);
        }
        IObjectValue value = null;
        if (this.context.getLoopTimes() == 0) {
            this.collector.addGetValueIntent(this.bosType, pk, selector, isBaseOnSelector);
            return null;
        }
        if ("FINISHED".equals(this.context.getStage())) {
            if (!this.isThreadCached) {
                return this.collector.getLocalCacheValue(this.bosType, pk, selector, isBaseOnSelector);
            }
        } else {
            if (!this.isThreadCached) {
                value = this.collector.getLocalCacheValue(this.bosType, pk, selector, isBaseOnSelector);
            }
            if (value == null) {
                this.collector.addGetValueIntent(this.bosType, pk, selector, isBaseOnSelector);
            }
            return value;
        }
        return null;
    }

    @Override
    public IObjectValue getValue(String oql) throws DataAccessException {
        return this.innerDAO.getValue(oql);
    }

    @Override
    public IObjectValue getValue(String oql, boolean isBaseOnSelector) throws DataAccessException {
        return this.innerDAO.getValue(oql, isBaseOnSelector);
    }

    @Override
    public IObjectValue getValue(EntityViewInfo view) throws DataAccessException {
        return this.innerDAO.getValue(view);
    }

    @Override
    public IObjectValue getValue(EntityViewInfo view, boolean isBaseOnSelector) throws DataAccessException {
        return this.innerDAO.getValue(view, isBaseOnSelector);
    }

    @Override
    public IObjectValue getValueNoChild(IObjectPK pk) throws DataAccessException {
        return this.innerDAO.getValueNoChild(pk);
    }

    @Override
    public IObjectPK[] getPKList(FilterInfo filter, SorterItemCollection sorter) throws DataAccessException {
        return this.innerDAO.getPKList(filter, sorter);
    }

    @Override
    public IObjectPK[] getPKList(String oql) throws DataAccessException {
        return this.innerDAO.getPKList(oql);
    }

    @Override
    public IObjectCollection getCollection(EntityViewInfo view) throws DataAccessException {
        return this.innerDAO.getCollection(view);
    }

    @Override
    public IObjectCollection getCollection(EntityViewInfo view, boolean isBaseOnSelector) throws DataAccessException {
        return this.innerDAO.getCollection(view, isBaseOnSelector);
    }

    @Override
    public IObjectCollection getCollection(String oql) throws DataAccessException {
        return this.innerDAO.getCollection(oql);
    }

    @Override
    public IObjectCollection getCollection(String oql, boolean isBaseOnSelector) throws DataAccessException {
        return this.innerDAO.getCollection(oql, isBaseOnSelector);
    }

    @Override
    public IObjectCollection getCollectionNoChild(EntityViewInfo view) throws DataAccessException {
        return this.innerDAO.getCollectionNoChild(view);
    }

    @Override
    public IObjectPK[] delete(FilterInfo filter) throws DataAccessException {
        return null;
    }

    @Override
    public IObjectPK[] delete(String oql) throws DataAccessException {
        return null;
    }

    @Override
    public void delete(IObjectPK[] pk) throws DataAccessException {
    }

    @Override
    public void updateBigObject(IObjectPK pk, IObjectValue value) throws DataAccessException {
    }

    @Override
    public void updatePartial(IObjectValue value, SelectorItemCollection selector) throws DataAccessException {
    }

    @Override
    public boolean exists(FilterInfo filterInfo) throws DataAccessException {
        return this.innerDAO.exists(filterInfo);
    }

    @Override
    public boolean exists(String oql) throws DataAccessException {
        return this.innerDAO.exists(oql);
    }

    @Override
    public int getCount(FilterInfo filterInfo) throws DataAccessException {
        return this.innerDAO.getCount(filterInfo);
    }

    @Override
    public int getCount(String oql) throws DataAccessException {
        return this.innerDAO.getCount(oql);
    }

    @Override
    public boolean accept(IObjectPK pk, FilterInfo rule) throws DataAccessException {
        return this.innerDAO.accept(pk, rule);
    }

    @Override
    public boolean accept(IObjectValue value, EntityViewInfo view) throws DataAccessException {
        return this.innerDAO.accept(value, view);
    }

    @Override
    public boolean accept(IObjectValue value, FilterInfo rule) throws DataAccessException {
        return this.innerDAO.accept(value, rule);
    }

    @Override
    public boolean accept(IObjectPK pk, FilterInfo rule, boolean isExcludeRule) throws DataAccessException {
        return this.innerDAO.accept(pk, rule, isExcludeRule);
    }

    @Override
    public void addNewBatch(IObjectValue value) throws DataAccessException {
    }

    @Override
    public void updateBatch(IObjectPK pk, IObjectValue value) throws DataAccessException {
    }

    @Override
    public void deleteBatch(IObjectPK pk) throws DataAccessException {
    }

    @Override
    public void executeBatch() throws DataAccessException {
    }

    @Override
    public IObjectPK[] executeBatchWithReturn() throws DataAccessException {
        return null;
    }

    @Override
    public IObjectCollection getCollection(EntityViewInfo view, int start, int length) throws DataAccessException {
        return null;
    }

    @Override
    public String getSql(EntityViewInfo view) throws DataAccessException {
        return null;
    }
}

