/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.spi;

import com.kingdee.util.ConfigurationException;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.XMLConfiguration;
import java.io.File;

class SPConfig {
    public static final String PROPERTIES_DIR_ENV_NAME = "eas.properties.dir";
    public static final String CLIENTROOT_DIR_ENV_NAME = "easclient.root";
    public static final String CONFIG_FILE_NAME = "ServiceProviderImpl.xml";
    private XMLConfiguration config;
    boolean configError;

    SPConfig() {
    }

    private static boolean runtimeIsClient() {
        return System.getProperty(CLIENTROOT_DIR_ENV_NAME) != null;
    }

    private ConfigurationItem getSPImplListCI() {
        return this.config.getConfigItem("SPImplList");
    }

    boolean loadConfig() throws ConfigurationException {
        String configPath = SPConfig.runtimeIsClient() ? System.getProperty(CLIENTROOT_DIR_ENV_NAME) : System.getProperty(PROPERTIES_DIR_ENV_NAME);
        File configFile = new File(configPath, CONFIG_FILE_NAME);
        if (configFile.isFile() && configFile.canWrite()) {
            this.config = XMLConfiguration.getInstance((File)configFile);
            return true;
        }
        return false;
    }

    public static String getConfigFilePath() {
        String configPath = SPConfig.runtimeIsClient() ? System.getProperty(CLIENTROOT_DIR_ENV_NAME) : System.getProperty(PROPERTIES_DIR_ENV_NAME);
        File configFile = new File(configPath, CONFIG_FILE_NAME);
        return configFile.getAbsolutePath();
    }

    void reLoad() {
        if (this.config != null) {
            this.config.reload();
        }
    }

    ConfigurationItem getServiceProvicerInfo(String serviceName) {
        if (this.configError) {
            return null;
        }
        return this.getSPImplListCI().getChild(serviceName);
    }
}

