/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.calculator;

import com.kingdee.bos.streamwork.calculator.CompoundId;
import com.kingdee.bos.streamwork.calculator.ExecuteContext;
import com.kingdee.bos.streamwork.calculator.Expr;
import com.kingdee.bos.streamwork.calculator.Visitor;
import java.util.ArrayList;
import java.util.List;

public class VerifyVisitor
implements Visitor {
    private ArrayList<String> validSymbols = new ArrayList();
    private ArrayList<String> invalidSymbols = new ArrayList();
    private ExecuteContext ctx;

    public VerifyVisitor(ExecuteContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public void visit(Expr expr) {
        if (expr instanceof CompoundId) {
            CompoundId id = (CompoundId)expr;
            String[] parts = id.toStringArray();
            String key = parts[0];
            if (!this.ctx.contains(key) && !this.invalidSymbols.contains(key)) {
                this.invalidSymbols.add(key);
            } else if (!this.validSymbols.contains(key)) {
                this.validSymbols.add(key);
            }
        }
    }

    public List<String> getInvalidSymboList() {
        return this.invalidSymbols;
    }

    public List<String> getValidSymboList() {
        return this.validSymbols;
    }
}

