/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTCell;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.streamwork.client.UIDesc;
import com.kingdee.bos.streamwork.datasource.DataSource;
import com.kingdee.bos.streamwork.datasource.DataSourceWithCachedPage;
import com.kingdee.bos.streamwork.datasource.MultiDataSource;
import com.kingdee.bos.streamwork.pivot.EASPivotFrame;
import com.kingdee.bos.streamwork.service.IStreamWorkService;
import com.kingdee.bos.streamwork.service.StreamWorkServiceFactory;
import java.util.ArrayList;
import java.util.List;

public class StreamWorkClient {
    public static KDFrame createPivotFrame(KDTable table, EntityViewInfo mainQuery, IMetaDataPK mainQueryPK) throws BOSException {
        return StreamWorkClient.createPivotFrame(table, mainQuery, mainQueryPK, null);
    }

    public static KDFrame createPivotFrame(KDTable table, EntityViewInfo mainQuery, IMetaDataPK mainQueryPK, UIDesc uiDesc) throws BOSException {
        DataSource ds = null;
        if (uiDesc != null) {
            int pos = uiDesc.id.indexOf("$$EnhancerByCGLIB$$");
            if (pos > 0) {
                uiDesc.id = uiDesc.id.substring(0, pos);
            }
            ds = StreamWorkClient.createDataSource(table, mainQuery, mainQueryPK, true, uiDesc.id);
        } else {
            ds = StreamWorkClient.createDataSource(table, mainQuery, mainQueryPK);
        }
        if (ds != null) {
            ds.setProperty("uiDesc", uiDesc);
            return new EASPivotFrame(ds);
        }
        return null;
    }

    public static DataSource createDataSource(KDTable table, EntityViewInfo mainQuery, IMetaDataPK mainQueryPK) throws BOSException {
        return StreamWorkClient.createDataSource(table, mainQuery, mainQueryPK, false, null);
    }

    public static DataSource createDataSource(KDTable table, EntityViewInfo mainQuery, IMetaDataPK mainQueryPK, boolean getDefaultSchema, String ui) throws BOSException {
        DataSourceWithCachedPage cds;
        List cachedPageKeys;
        KDTColumns columns = table.getColumns();
        ArrayList cells = table.getHeadRow(0).getKDTRow().getCells();
        if (columns.size() != cells.size()) {
            return null;
        }
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList<String> cellNames = new ArrayList<String>();
        ArrayList<String> entryFields = new ArrayList<String>();
        String idField = null;
        String numberField = null;
        for (int i = 0; i < columns.size(); ++i) {
            String field = columns.getColumn(i).getFieldName();
            if (field == null || !"id".equals(field) && columns.getColumn(i).getStyle().isHided()) continue;
            fieldNames.add(field);
            KDTCell cell = (KDTCell)cells.get(i);
            String headName = cell.getValue().toString();
            cellNames.add(headName);
            if (field.startsWith("entries.")) {
                entryFields.add(headName);
            }
            if (idField == null && field.equals("id")) {
                idField = headName;
                continue;
            }
            if (numberField != null || !field.equals("number")) continue;
            numberField = headName;
        }
        IStreamWorkService pig = StreamWorkServiceFactory.createRemoteObject();
        String[] columnNames = new String[fieldNames.size()];
        fieldNames.toArray(columnNames);
        DataSource dataSource = pig.executeBOSQuery(mainQueryPK, mainQuery, columnNames, getDefaultSchema, ui);
        if (dataSource == null) {
            return null;
        }
        final String[] header = new String[cellNames.size()];
        cellNames.toArray(header);
        if (dataSource instanceof DataSourceWithCachedPage && (cachedPageKeys = (cds = (DataSourceWithCachedPage)dataSource).getCachedPageKeys()) != null && !cachedPageKeys.isEmpty()) {
            dataSource = new MultiDataSource(cds, 1800000);
        }
        if (idField != null) {
            dataSource.setProperty("headerNumberField", idField);
        } else if (numberField != null) {
            dataSource.setProperty("headerNumberField", numberField);
        }
        final DataSource fDataSource = dataSource;
        return new DataSource(){

            @Override
            public int[] getColumnTypes() {
                return fDataSource.getColumnTypes();
            }

            @Override
            public String[] getColumnNames() {
                return header;
            }

            @Override
            public int getRowCount() {
                return fDataSource.getRowCount();
            }

            @Override
            public Object getCell(int columnIndex, int rowIndex) {
                return fDataSource.getCell(columnIndex, rowIndex);
            }

            @Override
            public Object getProperty(Object key) {
                return fDataSource.getProperty(key);
            }

            @Override
            public void setProperty(Object key, Object value) {
                fDataSource.setProperty(key, value);
            }
        };
    }
}

