/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.columnbased;

import com.kingdee.bos.streamwork.columnbased.SimpleBitmap;
import com.kingdee.bos.streamwork.columnbased.Vector;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class BitmapVector<T>
implements Vector<T>,
Serializable {
    private ArrayList values = new ArrayList();
    SimpleBitmap bitmap = new SimpleBitmap();
    private int size;

    public BitmapVector() {
    }

    public BitmapVector(T[] rows) {
        for (int i = 0; i < rows.length; ++i) {
            this.append(rows[i]);
        }
    }

    public BitmapVector(Iterator<T> iter) {
        while (iter.hasNext()) {
            this.append(iter.next());
        }
    }

    public BitmapVector(Collection<T> collection) {
        Iterator<T> iter = collection.iterator();
        while (iter.hasNext()) {
            this.append(iter.next());
        }
    }

    @Override
    public void append(T o) {
        int idx = this.values.indexOf(o);
        if (idx < 0) {
            this.bitmap.set(this.values.size(), this.size);
            this.values.add(o);
        } else {
            this.bitmap.set(idx, this.size);
        }
        ++this.size;
    }

    @Override
    public void set(int row, T o) {
        if (row > this.size - 1) {
            int idx = this.values.indexOf(o);
            if (idx < 0) {
                this.bitmap.set(this.values.size(), row);
                this.values.add(o);
            } else {
                this.bitmap.set(idx, row);
            }
            this.size = row + 1;
        } else {
            for (int i = 0; i < this.bitmap.getColumnCount(); ++i) {
                if (!this.bitmap.get(i, row)) continue;
                this.bitmap.clear(i, row);
            }
            int idx = this.values.indexOf(o);
            if (idx < 0) {
                this.bitmap.set(this.values.size(), row);
                this.values.add(o);
            } else {
                this.bitmap.set(idx, row);
            }
        }
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public T get(int row) {
        for (int i = 0; i < this.bitmap.getColumnCount(); ++i) {
            if (!this.bitmap.get(i, row)) continue;
            return (T)this.values.get(i);
        }
        return null;
    }

    @Override
    public int getCardinality() {
        return this.values.size();
    }

    @Override
    public double getFactor() {
        return 1.0 * (double)this.values.size() / (double)this.size;
    }

    @Override
    public void markFinish() {
        this.bitmap.compact();
    }

    @Override
    public Iterator<T> iterator() {
        return new MyIterator();
    }

    private class MyIterator<T>
    implements Iterator {
        int pos = 0;

        private MyIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pos < BitmapVector.this.size;
        }

        public T next() {
            Object t = BitmapVector.this.get(this.pos);
            ++this.pos;
            return t;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

