/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.columnbased;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class OnlyKeyMap<T>
implements Serializable {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    transient Entry[] table;
    transient int size;
    int threshold;
    final float loadFactor;
    volatile transient int modCount;

    public OnlyKeyMap(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new Entry[capacity];
        this.init();
    }

    public OnlyKeyMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public OnlyKeyMap() {
        this.loadFactor = 0.75f;
        this.threshold = 12;
        this.table = new Entry[16];
        this.init();
    }

    void init() {
    }

    static int hash(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public T getKey(T key) {
        if (key == null) {
            return null;
        }
        int hash = OnlyKeyMap.hash(key.hashCode());
        Entry e = this.table[OnlyKeyMap.indexFor(hash, this.table.length)];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || key.equals(k))) {
                return e.getKey();
            }
            e = e.next;
        }
        return null;
    }

    public boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    final Entry getEntry(Object key) {
        int hash = key == null ? 0 : OnlyKeyMap.hash(key.hashCode());
        Entry e = this.table[OnlyKeyMap.indexFor(hash, this.table.length)];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    public Object putKey(Object key) {
        if (key == null) {
            return this.putForNullKey(key);
        }
        int hash = OnlyKeyMap.hash(key.hashCode());
        int i = OnlyKeyMap.indexFor(hash, this.table.length);
        Entry e = this.table[i];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || key.equals(k))) {
                e.recordAccess(this);
                return e.key;
            }
            e = e.next;
        }
        ++this.modCount;
        this.addEntry(hash, key, i);
        return null;
    }

    private Object putForNullKey(Object key) {
        Entry e = this.table[0];
        while (e != null) {
            if (e.key == null) {
                e.recordAccess(this);
                return null;
            }
            e = e.next;
        }
        ++this.modCount;
        this.addEntry(0, null, 0);
        return null;
    }

    void resize(int newCapacity) {
        Entry[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    void transfer(Entry[] newTable) {
        Entry[] src = this.table;
        int newCapacity = newTable.length;
        for (int j = 0; j < src.length; ++j) {
            Entry next;
            Entry e = src[j];
            if (e == null) continue;
            src[j] = null;
            do {
                next = e.next;
                int i = OnlyKeyMap.indexFor(e.hash, newCapacity);
                e.next = newTable[i];
                newTable[i] = e;
            } while ((e = next) != null);
        }
    }

    public Object removeKey(Object key) {
        Entry e = this.removeEntryForKey(key);
        return e == null ? null : e.getKey();
    }

    final Entry removeEntryForKey(Object key) {
        Entry prev;
        int hash = key == null ? 0 : OnlyKeyMap.hash(key.hashCode());
        int i = OnlyKeyMap.indexFor(hash, this.table.length);
        Entry e = prev = this.table[i];
        while (e != null) {
            Object k;
            Entry next = e.next;
            if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                e.recordRemoval(this);
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    final Entry removeMapping(Object o) {
        Entry prev;
        if (!(o instanceof Map.Entry)) {
            return null;
        }
        Map.Entry entry = (Map.Entry)o;
        Object key = entry.getKey();
        int hash = key == null ? 0 : OnlyKeyMap.hash(key.hashCode());
        int i = OnlyKeyMap.indexFor(hash, this.table.length);
        Entry e = prev = this.table[i];
        while (e != null) {
            Entry next = e.next;
            if (e.hash == hash && e.equals(entry)) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                e.recordRemoval(this);
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    public void clear() {
        ++this.modCount;
        Entry[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = null;
        }
        this.size = 0;
    }

    void addEntry(int hash, Object key, int bucketIndex) {
        Entry e = this.table[bucketIndex];
        this.table[bucketIndex] = new Entry<Object>(hash, key, e);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void createEntry(int hash, Object key, int bucketIndex) {
        Entry e = this.table[bucketIndex];
        this.table[bucketIndex] = new Entry<Object>(hash, key, e);
        ++this.size;
    }

    int capacity() {
        return this.table.length;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        EntryIterator i = this.size > 0 ? new EntryIterator() : null;
        s.defaultWriteObject();
        s.writeInt(this.table.length);
        s.writeInt(this.size);
        if (i != null) {
            while (i.hasNext()) {
                Entry e = (Entry)i.next();
                s.writeObject(e.getKey());
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int numBuckets = s.readInt();
        this.table = new Entry[numBuckets];
        this.init();
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = s.readObject();
            this.putForCreate(key);
        }
    }

    private void putForCreate(Object key) {
        int hash = key == null ? 0 : OnlyKeyMap.hash(key.hashCode());
        int i = OnlyKeyMap.indexFor(hash, this.table.length);
        Entry e = this.table[i];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) {
                return;
            }
            e = e.next;
        }
        this.createEntry(hash, key, i);
    }

    private final class KeyIterator
    extends HashIterator {
        private KeyIterator() {
        }

        public Object next() {
            return this.nextEntry().getKey();
        }
    }

    private abstract class HashIterator
    implements Iterator {
        Entry next;
        int expectedModCount;
        int index;
        Entry current;

        HashIterator() {
            this.expectedModCount = OnlyKeyMap.this.modCount;
            if (OnlyKeyMap.this.size > 0) {
                Entry[] t = OnlyKeyMap.this.table;
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        final Entry nextEntry() {
            if (OnlyKeyMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.next = e.next;
            if (this.next == null) {
                Entry[] t = OnlyKeyMap.this.table;
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
            this.current = e;
            return e;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (OnlyKeyMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Object k = this.current.key;
            this.current = null;
            OnlyKeyMap.this.removeEntryForKey(k);
            this.expectedModCount = OnlyKeyMap.this.modCount;
        }
    }

    private final class EntryIterator
    extends HashIterator {
        private EntryIterator() {
        }

        public Entry next() {
            return this.nextEntry();
        }
    }

    static class Entry<T> {
        final T key;
        Entry next;
        final int hash;

        Entry(int h, T k, Entry n) {
            this.next = n;
            this.key = k;
            this.hash = h;
        }

        public final T getKey() {
            return this.key;
        }

        public final boolean equals(Object o) {
            T k2;
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            T k1 = this.getKey();
            return k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2);
        }

        public final int hashCode() {
            return this.key == null ? 0 : this.key.hashCode();
        }

        public final String toString() {
            return "" + this.getKey();
        }

        void recordAccess(OnlyKeyMap m) {
        }

        void recordRemoval(OnlyKeyMap m) {
        }
    }
}

