/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.cuba.collection;

import com.kingdee.bos.streamwork.cuba.CUBAException;
import com.kingdee.bos.streamwork.cuba.collection.ArrayList;
import com.kingdee.bos.streamwork.cuba.collection.IInnerList;
import com.kingdee.bos.streamwork.cuba.collection.IStorageManager;
import com.kingdee.bos.streamwork.cuba.util.ObjectComparator;
import com.kingdee.bos.streamwork.cuba.util.Util;
import java.io.IOException;
import java.util.Iterator;

public class CacheableArrayList
implements IInnerList {
    IStorageManager storageManager;
    ArrayList arrayList;
    int cacheId = -1;
    long touchTime = 0L;
    int size;

    CacheableArrayList(IStorageManager storageManager, ArrayList arrayList) {
        this.storageManager = storageManager;
        this.arrayList = arrayList;
    }

    public void doCache() throws IOException {
        if (this.arrayList == null) {
            return;
        }
        this.cacheId = this.storageManager.saveArrayList(this.arrayList);
        this.size = this.arrayList.size();
        this.arrayList = null;
    }

    public synchronized void restore() {
        try {
            this.arrayList = this.storageManager.getArrayList(this.cacheId);
        }
        catch (IOException e) {
            throw Util.newInternal(e, "\u65e0\u6cd5\u6062\u590dArrayList\u3002");
        }
        catch (CUBAException e) {
            throw Util.newInternal(e, "\u65e0\u6cd5\u6062\u590dArrayList\u3002");
        }
    }

    public void touch() {
        this.touchTime = System.currentTimeMillis();
    }

    public void access() {
        if (this.arrayList == null) {
            this.restore();
        } else {
            this.touch();
        }
    }

    @Override
    public boolean contains(Object o) {
        this.access();
        return this.arrayList.contains(o);
    }

    @Override
    public Object get(int index) {
        this.access();
        return this.arrayList.get(index);
    }

    @Override
    public Object getFirst() {
        this.access();
        return this.arrayList.getFirst();
    }

    @Override
    public Object getLast() {
        this.access();
        return this.arrayList.getLast();
    }

    @Override
    public IInnerList innerAdd(Object o) {
        this.access();
        IInnerList list = this.arrayList.innerAdd(o);
        if (list instanceof ArrayList) {
            this.arrayList = (ArrayList)list;
            return this;
        }
        return list;
    }

    @Override
    public IInnerList innerAddArray(Object[] objects) {
        this.access();
        IInnerList list = this.arrayList.innerAddArray(objects);
        if (list instanceof ArrayList) {
            this.arrayList = (ArrayList)list;
            return this;
        }
        return list;
    }

    @Override
    public IInnerList innerAddFirst(Object o) {
        this.access();
        IInnerList list = this.arrayList.innerAddFirst(o);
        if (list instanceof ArrayList) {
            this.arrayList = (ArrayList)list;
            return this;
        }
        return list;
    }

    @Override
    public IInnerList innerAddList(IInnerList list) {
        this.access();
        list = this.arrayList.innerAddList(list);
        if (list instanceof ArrayList) {
            this.arrayList = (ArrayList)list;
            return this;
        }
        return list;
    }

    @Override
    public boolean isEmpty() {
        if (this.arrayList == null) {
            return this.size == 0;
        }
        return this.arrayList.isEmpty();
    }

    @Override
    public boolean isSorted() {
        this.access();
        return this.arrayList.isSorted();
    }

    @Override
    public Iterator iterator() {
        if (this.arrayList == null) {
            this.restore();
            Iterator iter = this.arrayList.iterator();
            this.arrayList = null;
            return iter;
        }
        return this.arrayList.iterator();
    }

    @Override
    public int size() {
        if (this.arrayList == null) {
            return this.size;
        }
        return this.arrayList.size();
    }

    @Override
    public IInnerList sort(ObjectComparator comparator) throws CUBAException {
        this.access();
        IInnerList list = this.arrayList.sort(comparator);
        if (list instanceof ArrayList) {
            this.arrayList = (ArrayList)list;
            return this;
        }
        return list;
    }

    @Override
    public IInnerList subList(int begin, int end) {
        if (begin == 0 && end == this.size) {
            return this;
        }
        this.access();
        IInnerList list = this.arrayList.subList(begin, end);
        if (list instanceof ArrayList) {
            this.arrayList = (ArrayList)list;
            return this;
        }
        return list;
    }

    @Override
    public Object[] toArray() {
        this.access();
        return this.arrayList.toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        this.access();
        return this.arrayList.toArray(a);
    }

    @Override
    public int realSize() {
        return 0;
    }

    @Override
    public void doCache(IStorageManager storageManager) {
        try {
            this.doCache();
        }
        catch (IOException e) {
            throw Util.newInternal(e, "\u65e0\u6cd5doCache ArrayList.");
        }
    }
}

