/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.cuba.collection;

import com.kingdee.bos.streamwork.cuba.Cube;
import com.kingdee.bos.streamwork.cuba.Member;
import com.kingdee.bos.streamwork.cuba.collection.ArrayList;
import com.kingdee.bos.streamwork.cuba.collection.CacheableListWrapper;
import com.kingdee.bos.streamwork.cuba.collection.CacheableMemberListWrapper;
import com.kingdee.bos.streamwork.cuba.collection.IInnerList;
import com.kingdee.bos.streamwork.cuba.collection.IList;
import com.kingdee.bos.streamwork.cuba.collection.IListFactory;
import com.kingdee.bos.streamwork.cuba.collection.IMemberList;
import com.kingdee.bos.streamwork.cuba.collection.IStorageManager;
import com.kingdee.bos.streamwork.cuba.collection.JoinList;
import com.kingdee.bos.streamwork.cuba.collection.ListWrapper;
import com.kingdee.bos.streamwork.cuba.collection.UnionList;
import com.kingdee.bos.streamwork.cuba.mdx.MdxQuery;
import com.kingdee.bos.streamwork.cuba.mdx.SchemaReader;

public class CacheableListFactory
implements IListFactory {
    IStorageManager storageManager;

    public CacheableListFactory(MdxQuery query) {
        SchemaReader schemaReader = query.getSchemaReader();
        Cube cube = query.getCube();
    }

    public CacheableListFactory(SchemaReader schemaReader, Cube cube) {
    }

    @Override
    public IList createArrayList(int capacity) {
        return new CacheableListWrapper(new ArrayList(capacity), this.storageManager);
    }

    @Override
    public IList createArrayList() {
        return new CacheableListWrapper(new ArrayList(), this.storageManager);
    }

    @Override
    public IList createArrayList(Object[] array) {
        if (array == null) {
            return IList.EMPTY;
        }
        IInnerList list = new ArrayList(array.length);
        list = list.innerAddArray(array);
        return new CacheableListWrapper(list, this.storageManager);
    }

    @Override
    public IMemberList createMemberList(int capacity) {
        return new CacheableMemberListWrapper(new ArrayList(capacity), this.storageManager);
    }

    @Override
    public IMemberList createMemberList() {
        return new CacheableMemberListWrapper(new ArrayList(), this.storageManager);
    }

    @Override
    public IMemberList createMemberList(Member[] array) {
        if (array == null) {
            return IMemberList.EMPTY;
        }
        IInnerList list = new ArrayList(array.length);
        list = list.innerAddArray(array);
        return new CacheableMemberListWrapper(list, this.storageManager);
    }

    @Override
    public IList createJoinList(IList list1, IList list2) {
        IInnerList innerList1 = ((ListWrapper)list1).innerList;
        IInnerList innerList2 = ((ListWrapper)list2).innerList;
        return new CacheableListWrapper(new JoinList(innerList1, innerList2), this.storageManager);
    }

    @Override
    public IList createUnionList(IList list1, IList list2) {
        IInnerList innerList1 = ((ListWrapper)list1).innerList;
        IInnerList innerList2 = ((ListWrapper)list2).innerList;
        return new CacheableListWrapper(new UnionList(innerList1, innerList2), this.storageManager);
    }

    @Override
    public void release() {
        if (this.storageManager != null) {
            this.storageManager.release();
        }
    }
}

