/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.cuba.dbsource;

import com.kingdee.bos.streamwork.cuba.CUBAException;
import com.kingdee.bos.streamwork.cuba.dbsource.Table;
import java.sql.Timestamp;
import java.util.Date;
import java.util.GregorianCalendar;

public class TimeRangeTable
implements Table {
    String columnName;
    Date start;
    Date end;
    GregorianCalendar calendar = new GregorianCalendar();

    public TimeRangeTable(String columnName, Date start, Date end) {
        this.columnName = columnName;
        this.start = start;
        this.end = end;
        this.calendar.setTime(start);
        this.calendar.add(5, -1);
    }

    @Override
    public int getColumnCount() throws CUBAException {
        return 1;
    }

    @Override
    public int getColumnType(int index) throws CUBAException {
        return 91;
    }

    @Override
    public int getColumnIndex(String name) throws CUBAException {
        if (this.columnName.equalsIgnoreCase(name)) {
            return 0;
        }
        throw new CUBAException("wrong column name:" + name);
    }

    @Override
    public String[] getColumnNames() throws CUBAException {
        return new String[]{this.columnName};
    }

    @Override
    public boolean next() throws CUBAException {
        if (this.calendar.getTime().before(this.end)) {
            this.calendar.add(5, 1);
            return true;
        }
        return false;
    }

    @Override
    public Object getValue(int index) throws CUBAException {
        if (index == 0) {
            return new Timestamp(this.calendar.getTimeInMillis());
        }
        throw new CUBAException("wrong index");
    }

    @Override
    public Object[] getValues() throws CUBAException {
        return new Object[]{this.getValue(0)};
    }

    @Override
    public void close() {
    }
}

