/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.cuba.def;

import com.kingdee.bos.streamwork.cuba.CUBAException;
import com.kingdee.bos.streamwork.cuba.def.SchemaDef;
import com.kingdee.bos.streamwork.cuba.def.SchemaParser;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class SchemaLoader {
    private static Logger logger = Logger.getLogger(SchemaLoader.class);

    public static SchemaDef load(InputStream in) throws CUBAException {
        Document doc = null;
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(in);
        }
        catch (JDOMException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Bad schema document.", (Throwable)e);
            }
            throw new CUBAException("Bad schema document.", e);
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Unable to open the schema input stream.", (Throwable)e);
            }
            throw new CUBAException("Unable to open the schema input stream.", e);
        }
        return SchemaParser.parse(doc);
    }
}

