/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.cuba.impl;

import com.kingdee.bos.streamwork.cuba.CUBADatabase;
import com.kingdee.bos.streamwork.cuba.CUBAException;
import com.kingdee.bos.streamwork.cuba.Connection;
import com.kingdee.bos.streamwork.cuba.MdxResult;
import com.kingdee.bos.streamwork.cuba.Schema;
import com.kingdee.bos.streamwork.cuba.impl.CellReaderImpl;
import com.kingdee.bos.streamwork.cuba.impl.CubeImpl;
import com.kingdee.bos.streamwork.cuba.impl.MdxResultImpl;
import com.kingdee.bos.streamwork.cuba.impl.OneAxisMdxResultImpl;
import com.kingdee.bos.streamwork.cuba.impl.StreamWorkMdxResult;
import com.kingdee.bos.streamwork.cuba.mdx.CellReader;
import com.kingdee.bos.streamwork.cuba.mdx.Exp;
import com.kingdee.bos.streamwork.cuba.mdx.MdxQuery;
import com.kingdee.bos.streamwork.cuba.mdx.ParserHelp;
import com.kingdee.bos.streamwork.cuba.mdx.SchemaReader;
import com.kingdee.bos.streamwork.cuba.q.Result;
import com.kingdee.bos.streamwork.cuba.q.ResultBuilder;
import java.io.Serializable;
import java.util.Locale;

public class ConnectionImpl
implements Connection,
Serializable {
    private static final long serialVersionUID = -8852145556892326649L;
    CUBADatabase database;
    Locale locale;
    int executeModel = 0;

    public ConnectionImpl(CUBADatabase database) {
        if (database == null) {
            throw new NullPointerException();
        }
        this.database = database;
    }

    public Schema getSchema() throws CUBAException {
        return this.database.schema;
    }

    @Override
    public SchemaReader getSchemaReader() {
        return this.database.getSchemaReader();
    }

    @Override
    public SchemaReader getRemoteSchemaReader() {
        return this.database.getSchemaReader();
    }

    @Override
    public MdxResult executeMdxQuery(MdxQuery query) throws CUBAException {
        query.setConnection(this);
        if (query.getAxes().length == 1) {
            return new OneAxisMdxResultImpl(query);
        }
        if (this.executeModel == 1) {
            return new StreamWorkMdxResult(query);
        }
        if (query.getAxes().length == 2) {
            return new MdxResultImpl(query);
        }
        return null;
    }

    @Override
    public MdxResult executeMdxQuery(String mdx) throws CUBAException {
        try {
            return this.executeMdxQuery(this.parseQuery(mdx));
        }
        catch (CUBAException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CUBAException(e);
        }
    }

    @Override
    public Result executeQuery(MdxQuery query) throws CUBAException {
        query.setConnection(this);
        ResultBuilder builder = new ResultBuilder(query);
        return builder.build();
    }

    @Override
    public Result executeQuery(String mdx) throws CUBAException {
        try {
            return this.executeQuery(this.parseQuery(mdx));
        }
        catch (CUBAException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CUBAException(e);
        }
    }

    @Override
    public MdxQuery parseQuery(String mdx) throws CUBAException {
        return ParserHelp.parseQuery(this, mdx);
    }

    @Override
    public void close() {
        if (this.database != null) {
            this.database.release();
            this.database = null;
        }
    }

    @Override
    public String getDefaultCubeName() {
        return this.database.getDefaultCubeName();
    }

    @Override
    public Exp parseExpression(String expression) throws CUBAException {
        return ParserHelp.parseExpression(expression);
    }

    public CellReader getCellReader(CubeImpl cube) {
        return new CellReaderImpl(this.database.getCubeData(cube));
    }

    @Override
    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public int getExecuteModel() {
        return this.executeModel;
    }

    public void setExecuteModel(int executeModel) {
        this.executeModel = executeModel;
    }
}

