/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.cuba.impl;

import com.kingdee.bos.streamwork.cuba.CUBAConfig;
import com.kingdee.bos.streamwork.cuba.CUBADatabase;
import com.kingdee.bos.streamwork.cuba.CUBAException;
import com.kingdee.bos.streamwork.cuba.ICubeData;
import com.kingdee.bos.streamwork.cuba.dbsource.Table;
import com.kingdee.bos.streamwork.cuba.dbsource.TableManager;
import com.kingdee.bos.streamwork.cuba.def.AbstractCubeDimensionDef;
import com.kingdee.bos.streamwork.cuba.def.CubeDef;
import com.kingdee.bos.streamwork.cuba.def.DimensionUsageDef;
import com.kingdee.bos.streamwork.cuba.def.SchemaDef;
import com.kingdee.bos.streamwork.cuba.impl.BuildContext;
import com.kingdee.bos.streamwork.cuba.impl.CubeDataFactory;
import com.kingdee.bos.streamwork.cuba.impl.CubeImpl;
import com.kingdee.bos.streamwork.cuba.impl.DimensionBuildResult;
import com.kingdee.bos.streamwork.cuba.impl.DimensionBuilder;
import com.kingdee.bos.streamwork.cuba.impl.DimensionFetch;
import com.kingdee.bos.streamwork.cuba.impl.DimensionImpl;
import com.kingdee.bos.streamwork.cuba.impl.DimensionUsageFetch;
import com.kingdee.bos.streamwork.cuba.impl.MeasureFetch;
import com.kingdee.bos.streamwork.cuba.impl.MemberImpl;
import com.kingdee.bos.streamwork.cuba.impl.RecordAdd;
import com.kingdee.bos.streamwork.cuba.impl.SchemaBuilder;
import com.kingdee.bos.streamwork.cuba.impl.SchemaImpl;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CubaBuilder {
    private static Logger logger = Logger.getLogger(CubaBuilder.class);

    public static TableManager getTableManager(SchemaDef def, Map params, CUBAConfig config) throws CUBAException, SQLException {
        return new TableManager(def, params, config);
    }

    public static SchemaImpl buildSchema(BuildContext buildContext, SchemaDef def, List notVisibleMeasures, boolean checkSchemaDef) throws CUBAException, SQLException {
        if (checkSchemaDef) {
            logger.debug((Object)"checking schema define...");
            def.check();
        }
        logger.debug((Object)"building schema object...");
        SchemaImpl schema = SchemaBuilder.buildSchema(def);
        logger.debug((Object)"schema building succeeded.");
        logger.debug((Object)"preparing connection & table Manager.");
        long time = System.currentTimeMillis();
        if (def.dimensions != null) {
            for (int i = 0; i < def.dimensions.length; ++i) {
                DimensionBuilder.buildSharedDimension(buildContext, schema.dims[i], def.dimensions[i]);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("build schema cost " + (System.currentTimeMillis() - time) + " ms."));
        }
        if (notVisibleMeasures != null && notVisibleMeasures.size() > 0) {
            MemberImpl[] measures = schema.cubes[0].measures;
            for (int i = 0; i < measures.length; ++i) {
                if (!notVisibleMeasures.contains(measures[i].getName())) continue;
                measures[i].setVisible(false);
            }
        }
        return schema;
    }

    public static CUBADatabase buildDatabase(BuildContext buildContext, SchemaImpl schema, SchemaDef def, CUBAConfig config) throws CUBAException, SQLException {
        CUBADatabase dataSet = new CUBADatabase(schema);
        for (int i = 0; i < def.cubes.length; ++i) {
            ICubeData cubeData = CubaBuilder.buildCubeData(buildContext, schema, schema.cubes[i], def.cubes[i], config);
            dataSet.setData(def.cubes[i].name, cubeData);
        }
        return dataSet;
    }

    private static ICubeData buildCubeData(BuildContext buildContext, SchemaImpl schema, CubeImpl cube, CubeDef cubeDef, CUBAConfig config) throws CUBAException, SQLException {
        int i;
        long time0;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("building cube '" + cubeDef.name + "'..."));
        }
        ICubeData data = CubeDataFactory.createCubeData(cube, config);
        Table table = buildContext.getTableManager().getTable(cubeDef.table);
        int dimCount = cube.dims.length;
        DimensionFetch[] cdfs = new DimensionFetch[dimCount];
        for (int i2 = 0; i2 < dimCount; ++i2) {
            AbstractCubeDimensionDef cd = cubeDef.dimensions[i2];
            if (!(cd instanceof DimensionUsageDef)) continue;
            DimensionImpl dim2 = (DimensionImpl)cube.getDimension(cube.dims[i2].getName());
            cube.dims[i2].memberCount = dim2.memberCount;
            cube.dims[i2].mapOrderToMember = dim2.mapOrderToMember;
            DimensionBuildResult dbr = buildContext.getDimensionResult(cd.name);
            cdfs[i2] = new DimensionUsageFetch(dbr, cube.dims[i2], (DimensionUsageDef)cd, buildContext.config);
        }
        int measureCount = cube.measures.length;
        MeasureFetch[] mfs = new MeasureFetch[measureCount];
        for (int i3 = 0; i3 < measureCount; ++i3) {
            mfs[i3] = new MeasureFetch(cube.measures[i3], cubeDef.measures[i3]);
        }
        RecordAdd ra = new RecordAdd(cube, data);
        logger.debug((Object)"fetching cube data...");
        int recordCount = 0;
        int errorCount = 0;
        long time = time0 = System.currentTimeMillis();
        block2: while (table.next()) {
            ++recordCount;
            for (i = 0; i < dimCount; ++i) {
                MemberImpl[] members = cdfs[i].fetch(table);
                for (int j = 0; j < members.length; ++j) {
                    if (members[j] != null) continue;
                    ++errorCount;
                    continue block2;
                }
                ra.setMembers(i, members);
            }
            Object[] values = new Object[measureCount];
            for (int i4 = 0; i4 < measureCount; ++i4) {
                values[i4] = mfs[i4].fetch(table);
            }
            ra.addRecord(values);
        }
        data.finishAddRecord();
        time = System.currentTimeMillis() - time;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("fetch collpase " + time + "ms."));
            logger.debug((Object)(" " + recordCount + "records fetched."));
            if (errorCount > 0) {
                logger.debug((Object)("Found " + errorCount + " error records"));
            }
        }
        table.close();
        buildContext.getTableManager().releaseTable(cubeDef.table);
        for (i = 0; i < dimCount; ++i) {
            cdfs[i].finish();
        }
        time = System.currentTimeMillis();
        data.buildData();
        data.finishBuildData();
        time = System.currentTimeMillis() - time;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("build collpase " + time + "ms."));
        }
        return data;
    }
}

