/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.cuba.impl;

import com.kingdee.bos.streamwork.cuba.Aggregator;
import com.kingdee.bos.streamwork.cuba.CUBAConfig;
import com.kingdee.bos.streamwork.cuba.CUBAException;
import com.kingdee.bos.streamwork.cuba.Cube;
import com.kingdee.bos.streamwork.cuba.CubeData;
import com.kingdee.bos.streamwork.cuba.Member;
import com.kingdee.bos.streamwork.cuba.impl.HierarchyImpl;
import com.kingdee.bos.streamwork.cuba.impl.MemberImpl;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class MemCubeData
extends CubeData {
    private HashMap data = new HashMap();
    private HashMap selfData = new HashMap();
    private int records = 0;
    private CUBAConfig config;
    private static Object NULL = new Object();

    public MemCubeData(Cube _cube, CUBAConfig config) throws CUBAException {
        super(_cube);
        this.config = config;
        this.measures = this.cube.getMeasures();
        this.aggs = new Aggregator[this.measures.length];
        for (int i = 0; i < this.aggs.length; ++i) {
            String aggName = (String)this.measures[i].getProperty("aggregator");
            if (aggName == null) continue;
            this.aggs[i] = Aggregator.getAggregator(aggName);
        }
    }

    private Point makePoint(Member[] members) {
        return new Point(members);
    }

    @Override
    public void addRecord(Member[] members, Object[] values) throws CUBAException {
        boolean isLeaf = true;
        for (int i = 0; i < members.length; ++i) {
            if (members[i].isLeaf()) continue;
            isLeaf = false;
            break;
        }
        if (!isLeaf && !this.config.supportSelfData) {
            return;
        }
        ++this.records;
        Point p = this.makePoint(members);
        HashMap datamap = isLeaf ? this.data : this.selfData;
        Object[] vs = (Object[])datamap.get(p);
        vs = this.appendValue(vs, values);
        datamap.put(p, vs);
    }

    @Override
    public void finishAddRecord() throws CUBAException {
        if (this.config.supportSelfData && this.selfData.size() > 0) {
            System.out.println("self data size:" + this.selfData.size());
            System.out.println("begin rollup self data");
            HashSet keySet = new HashSet();
            keySet.addAll(this.selfData.entrySet());
            for (Map.Entry entry : keySet) {
                Member[] members = ((Point)entry.getKey()).members;
                Object[] values = (Object[])entry.getValue();
                this.rollupParent(members, values);
            }
            System.out.println("self data size after rollup:" + this.selfData.size());
        }
    }

    private void rollupParent(Member[] members, Object[] values) throws CUBAException {
        HashMap excludeMap = new HashMap();
        for (int i = 0; i < members.length; ++i) {
            if (members[i].getParentMember() == null) continue;
            Member[] tempMembers = new Member[members.length];
            System.arraycopy(members, 0, tempMembers, 0, members.length);
            tempMembers[i] = members[i].getParentMember();
            this._rollupParent(tempMembers, values, excludeMap);
        }
    }

    private void _rollupParent(Member[] members, Object[] values, HashMap excludeMap) throws CUBAException {
        Point point = this.makePoint(members);
        if (excludeMap.containsKey(point)) {
            return;
        }
        Object[] vs = (Object[])this.selfData.get(point);
        vs = this.appendValue(vs, values);
        this.selfData.put(point, vs);
        excludeMap.put(point, point);
        for (int i = 0; i < members.length; ++i) {
            if (members[i].getParentMember() == null) continue;
            Member[] tempMembers = new Member[members.length];
            System.arraycopy(members, 0, tempMembers, 0, members.length);
            tempMembers[i] = members[i].getParentMember();
            this._rollupParent(tempMembers, values, excludeMap);
        }
    }

    @Override
    public Object[] getData(Member[] point) throws CUBAException {
        return this.getData(point, null);
    }

    @Override
    public Object[] getData(Member[] members, Map pinCache) throws CUBAException {
        Point point = this.makePoint(members);
        Object[] values = this._getData(members, point, pinCache);
        if (this.config.supportSelfData && this.selfData.size() > 0) {
            Object[] vs = (Object[])this.selfData.get(point);
            if (values != null) {
                vs = this.appendValue(vs, values);
            }
            return vs;
        }
        return values;
    }

    private Object[] _getData(Member[] members, Map pinCache) throws CUBAException {
        Point point = this.makePoint(members);
        Object[] values = this._getData(members, point, pinCache);
        return values;
    }

    private Object[] _getData(Member[] members, Point point, Map pinCache) throws CUBAException {
        for (int i = 0; i < members.length; ++i) {
            if (members[i].hasData()) continue;
            return null;
        }
        Object[] values = null;
        if (pinCache != null) {
            Object o = pinCache.get(point);
            if (o == NULL) {
                return null;
            }
            values = (Object[])o;
            if (values != null) {
                return values;
            }
        }
        if ((values = (Object[])this.data.get(point)) != null) {
            return values;
        }
        boolean allLeaf = true;
        for (int i = 0; i < members.length; ++i) {
            if (!members[i].isLeaf()) {
                allLeaf = false;
            }
            if (!members[i].isInner() || !members[i].isAll()) continue;
            allLeaf = false;
        }
        if (allLeaf) {
            if (pinCache != null) {
                pinCache.put(point, NULL);
            }
            return null;
        }
        values = null;
        Member[] ms = new Member[members.length];
        System.arraycopy(members, 0, ms, 0, ms.length);
        for (int i = 0; i < members.length; ++i) {
            MemberImpl[] children = null;
            children = members[i].isInner() && members[i].isAll() ? ((HierarchyImpl)members[i].getHierarchy()).getRootMembers() : ((MemberImpl)members[i]).getChildren();
            if (children == null || children.length <= 0) continue;
            for (int j = 0; j < children.length; ++j) {
                Object[] vs;
                ms[i] = children[j];
                if (!ms[i].hasData() || (vs = this._getData(ms, pinCache)) == null) continue;
                if (values == null) {
                    values = new Object[this.aggs.length];
                }
                for (int k = 0; k < this.measures.length; ++k) {
                    if (this.aggs[k] == null) continue;
                    values[k] = this.aggs[k].appendAggregator(values[k], vs[k]);
                }
            }
            break;
        }
        if (pinCache != null) {
            pinCache.put(point, values);
        }
        return values;
    }

    public Object[] appendAggregator(Object[] v1, Object[] v2) throws CUBAException {
        if (v1 == null && v2 == null) {
            return null;
        }
        if (v2 == null) {
            return v1;
        }
        if (v1 == null) {
            v1 = new Object[this.measures.length];
            for (int i = 0; i < this.measures.length; ++i) {
                v1[i] = this.aggs[i] == null ? v2[i] : this.aggs[i].appendAggregator(v1[i], v2[i]);
            }
            return v1;
        }
        Object[] result = new Object[v1.length];
        for (int i = 0; i < v1.length; ++i) {
            if (this.aggs[i] == null) {
                if (v2[i] == null) continue;
                if (v1[i] != null) {
                    throw new CUBAException("Measure '" + this.measures[i].getName() + "' no aggregator defined.");
                }
                result[i] = v2[i];
                continue;
            }
            result[i] = this.aggs[i].appendAggregator(v1[i], v2[i]);
        }
        return result;
    }

    public Object[] appendValue(Object[] v1, Object[] v2) throws CUBAException {
        if (v1 == null && v2 == null) {
            return null;
        }
        if (v2 == null) {
            return v1;
        }
        if (v1 == null) {
            v1 = new Object[v2.length];
            for (int i = 0; i < v1.length; ++i) {
                v1[i] = this.aggs[i] == null ? v2[i] : this.aggs[i].appendValue(v1[i], v2[i]);
            }
            return v1;
        }
        Object[] result = new Object[v1.length];
        for (int i = 0; i < v1.length; ++i) {
            if (this.aggs[i] == null) {
                if (v2[i] == null) continue;
                if (v1[i] != null) {
                    throw new CUBAException("Measure '" + this.measures[i].getName() + "' no aggregator defined.");
                }
                result[i] = v2[i];
                continue;
            }
            result[i] = this.aggs[i].appendValue(v1[i], v2[i]);
        }
        return result;
    }

    @Override
    public void finishBuildData() throws CUBAException {
        System.out.println("CubaData size:" + (this.data.size() + this.selfData.size()));
        if (this.selfData.size() > 0) {
            System.out.println("    --leaf data size:" + this.data.size());
            System.out.println("    --non leaf data size:" + this.selfData.size());
        }
    }

    @Override
    public void release() {
        this.data.clear();
    }

    private static class Point
    implements Serializable {
        private Member[] members;
        private int[] keys;
        private transient int h = 0;

        public Point(Member[] members) {
            this.members = new Member[members.length];
            System.arraycopy(members, 0, this.members, 0, members.length);
            this.keys = new int[members.length];
            for (int i = 0; i < this.keys.length; ++i) {
                this.keys[i] = ((MemberImpl)members[i]).globalOrder;
            }
        }

        public int hashCode() {
            if (this.h == 0) {
                for (int i = 0; i < this.keys.length; ++i) {
                    this.h += this.h << 2 ^ this.keys[i];
                }
            }
            return this.h;
        }

        public boolean equals(Object x) {
            int[] keys1 = this.keys;
            int[] keys2 = ((Point)x).keys;
            for (int i = 0; i < keys2.length; ++i) {
                if (keys1[i] == keys2[i]) continue;
                return false;
            }
            return true;
        }
    }
}

