/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.cuba.impl;

import com.kingdee.bos.streamwork.cuba.CUBAException;
import com.kingdee.bos.streamwork.cuba.ICubeData;
import com.kingdee.bos.streamwork.cuba.impl.CubeImpl;
import com.kingdee.bos.streamwork.cuba.impl.MemberImpl;

class RecordAdd {
    int dimCount;
    MemberImpl[] point;
    Object[] members;
    int[] indexs;
    int[] maxs;
    ICubeData data;

    RecordAdd(CubeImpl cube, ICubeData _data) {
        this.data = _data;
        this.dimCount = cube.dims.length;
        this.point = new MemberImpl[this.dimCount];
        this.members = new Object[this.dimCount];
        this.indexs = new int[this.dimCount];
        this.maxs = new int[this.dimCount];
        for (int i = 0; i < this.dimCount; ++i) {
            this.maxs[i] = cube.dims[i].hies.length;
        }
    }

    void setMembers(int index, MemberImpl[] ms) {
        this.members[index] = ms;
    }

    void addRecord(Object[] values) throws CUBAException {
        this.addRecord(0, values);
    }

    private void addRecord(int start, Object[] values) throws CUBAException {
        if (start == this.dimCount) {
            for (int i = 0; i < this.dimCount; ++i) {
                this.point[i] = ((MemberImpl[])this.members[i])[this.indexs[i]];
                this.point[i].setHasData(true);
                this.point[i].setHasSelfData(true);
            }
            this.data.addRecord(this.point, values);
        } else {
            int max = this.maxs[start];
            int i = 0;
            while (i < max) {
                this.indexs[start] = i++;
                this.addRecord(start + 1, values);
            }
        }
    }
}

