/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.cuba.impl;

import com.kingdee.bos.streamwork.cuba.Aggregator;
import com.kingdee.bos.streamwork.cuba.CUBAConfig;
import com.kingdee.bos.streamwork.cuba.CUBAException;
import com.kingdee.bos.streamwork.cuba.Cube;
import com.kingdee.bos.streamwork.cuba.CubeData;
import com.kingdee.bos.streamwork.cuba.Member;
import com.kingdee.bos.streamwork.cuba.RollupPolicy;
import com.kingdee.bos.streamwork.cuba.impl.MemberImpl;
import com.kingdee.bos.streamwork.cuba.impl.RollupManager;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class RollupMemCubeData
extends CubeData {
    private HashMap data = new HashMap();
    private int records = 0;
    private RollupPolicy rollupPolicy;
    private RollupManager rollupManager;
    private CUBAConfig config;
    private static Object NULL = new Object();

    public RollupMemCubeData(Cube _cube, RollupPolicy rollupPolicy, CUBAConfig config) throws CUBAException {
        super(_cube);
        this.config = config;
        this.measures = this.cube.getMeasures();
        this.aggs = new Aggregator[this.measures.length];
        for (int i = 0; i < this.aggs.length; ++i) {
            String aggName = (String)this.measures[i].getProperty("aggregator");
            if (aggName == null) continue;
            this.aggs[i] = Aggregator.getAggregator(aggName);
        }
        this.rollupManager = new RollupManager(rollupPolicy, this);
    }

    private Point makePoint(Member[] members) {
        return new Point(members);
    }

    @Override
    public void addRecord(Member[] members, Object[] values) throws CUBAException {
        for (int i = 0; i < members.length; ++i) {
            if (members[i].isLeaf()) continue;
            return;
        }
        ++this.records;
        Point p = this.makePoint(members);
        p.detail = true;
        Object[] vs = (Object[])this.data.get(p);
        vs = this.appendValue(vs, values);
        this.data.put(p, vs);
        this.rollupManager.addRecord(members, values);
    }

    @Override
    public Object[] getData(Member[] point) throws CUBAException {
        return this.getData(point, null);
    }

    @Override
    public Object[] getData(Member[] members, Map pinCache1) throws CUBAException {
        boolean hasData = true;
        boolean isAll = false;
        for (int i = 0; i < members.length; ++i) {
            if (members[i].isInner() && members[i].isAll()) {
                members[i] = null;
                isAll = true;
                continue;
            }
            if (members[i].hasData()) continue;
            hasData = false;
        }
        if (isAll) {
            return this.rollupManager.getData(members);
        }
        if (!hasData) {
            return null;
        }
        Point point = this.makePoint(members);
        Object[] values = null;
        values = (Object[])this.data.get(point);
        return values;
    }

    public Object[] appendAggregator(Object[] v1, Object[] v2) throws CUBAException {
        if (v1 == null && v2 == null) {
            return null;
        }
        if (v2 == null) {
            return v1;
        }
        if (v1 == null) {
            v1 = new Object[this.measures.length];
            for (int i = 0; i < this.measures.length; ++i) {
                v1[i] = this.aggs[i] == null ? v2[i] : this.aggs[i].appendAggregator(v1[i], v2[i]);
            }
            return v1;
        }
        Object[] result = new Object[v1.length];
        for (int i = 0; i < v1.length; ++i) {
            if (this.aggs[i] == null) {
                if (v2[i] == null) continue;
                if (v1[i] != null) {
                    throw new CUBAException("Measure '" + this.measures[i].getName() + "' no aggregator defined.");
                }
                result[i] = v2[i];
                continue;
            }
            result[i] = this.aggs[i].appendAggregator(v1[i], v2[i]);
        }
        return result;
    }

    public Object[] appendValue(Object[] v1, Object[] v2) throws CUBAException {
        if (v1 == null && v2 == null) {
            return null;
        }
        if (v1 == null) {
            v1 = new Object[v2.length];
            for (int i = 0; i < v1.length; ++i) {
                v1[i] = this.aggs[i] == null ? v2[i] : this.aggs[i].appendValue(v1[i], v2[i]);
            }
            return v1;
        }
        Object[] result = new Object[v1.length];
        for (int i = 0; i < v1.length; ++i) {
            if (this.aggs[i] == null) {
                if (v2[i] == null) continue;
                if (v1[i] != null) {
                    throw new CUBAException("Measure '" + this.measures[i].getName() + "' no aggregator defined.");
                }
                result[i] = v2[i];
                continue;
            }
            result[i] = this.aggs[i].appendValue(v1[i], v2[i]);
        }
        return result;
    }

    @Override
    public void finishBuildData() throws CUBAException {
        System.out.println("CubaData size:" + this.data.size());
    }

    @Override
    public void release() {
        this.data.clear();
    }

    private static class Point
    implements Serializable {
        private int[] keys;
        private boolean detail = true;
        private transient int h = 0;

        public Point(Member[] members) {
            this.keys = new int[members.length];
            for (int i = 0; i < this.keys.length; ++i) {
                this.keys[i] = ((MemberImpl)members[i]).globalOrder;
            }
        }

        public Point(int[] _keys) {
            this.keys = _keys;
        }

        public int hashCode() {
            if (this.h == 0) {
                for (int i = 0; i < this.keys.length; ++i) {
                    this.h += this.h << 2 ^ this.keys[i];
                }
            }
            return this.h;
        }

        public boolean equals(Object x) {
            int[] keys1 = this.keys;
            int[] keys2 = ((Point)x).keys;
            for (int i = 0; i < keys2.length; ++i) {
                if (keys1[i] == keys2[i]) continue;
                return false;
            }
            return true;
        }
    }
}

