/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.cuba.impl;

import com.kingdee.bos.streamwork.cuba.CUBAException;
import com.kingdee.bos.streamwork.cuba.Dimension;
import com.kingdee.bos.streamwork.cuba.def.CalculatedMemberDef;
import com.kingdee.bos.streamwork.cuba.def.CubeDef;
import com.kingdee.bos.streamwork.cuba.def.DimensionUsageDef;
import com.kingdee.bos.streamwork.cuba.def.HierarchyDef;
import com.kingdee.bos.streamwork.cuba.def.LevelDef;
import com.kingdee.bos.streamwork.cuba.def.MeasureDef;
import com.kingdee.bos.streamwork.cuba.def.PropertyDef;
import com.kingdee.bos.streamwork.cuba.def.SchemaDef;
import com.kingdee.bos.streamwork.cuba.def.SharedDimensionDef;
import com.kingdee.bos.streamwork.cuba.impl.CalculatedMemberImpl;
import com.kingdee.bos.streamwork.cuba.impl.CubeImpl;
import com.kingdee.bos.streamwork.cuba.impl.DimensionImpl;
import com.kingdee.bos.streamwork.cuba.impl.HierarchyImpl;
import com.kingdee.bos.streamwork.cuba.impl.LevelImpl;
import com.kingdee.bos.streamwork.cuba.impl.MemberImpl;
import com.kingdee.bos.streamwork.cuba.impl.PropertyImpl;
import com.kingdee.bos.streamwork.cuba.impl.SchemaImpl;
import com.kingdee.bos.streamwork.cuba.mdx.Exp;
import com.kingdee.bos.streamwork.cuba.mdx.Formula;
import com.kingdee.bos.streamwork.cuba.mdx.Literal;
import com.kingdee.bos.streamwork.cuba.mdx.MemberProperty;
import com.kingdee.bos.streamwork.cuba.mdx.ParserHelp;
import com.kingdee.bos.streamwork.cuba.util.Util;
import java.util.ArrayList;

public class SchemaBuilder {
    public static SchemaImpl buildSchema(SchemaDef def) throws CUBAException {
        int i;
        SchemaImpl schema = new SchemaImpl();
        schema.setProperty("name", def.name);
        schema.setProperty("caption", def.caption);
        schema.setProperty("description", def.description);
        schema.dims = null;
        schema.dims = def.dimensions == null ? new DimensionImpl[0] : new DimensionImpl[def.dimensions.length];
        for (i = 0; i < schema.dims.length; ++i) {
            schema.dims[i] = SchemaBuilder.buildSharedDimension(schema, def.dimensions[i]);
        }
        for (i = 0; i < schema.dims.length; ++i) {
            String dependon = (String)schema.dims[i].getProperty("dependOnDimension");
            if (dependon == null) continue;
            schema.dims[i].setProperty("dependOnDimension", schema.getDimension(dependon));
        }
        schema.cubes = new CubeImpl[def.cubes.length];
        for (i = 0; i < schema.cubes.length; ++i) {
            schema.cubes[i] = SchemaBuilder.buildCube(schema, def.cubes[i]);
        }
        return schema;
    }

    private static DimensionImpl buildSharedDimension(SchemaImpl schema, SharedDimensionDef x) throws CUBAException {
        DimensionImpl dim = new DimensionImpl();
        dim.setProperty("name", x.name);
        dim.setProperty("caption", x.caption);
        dim.setProperty("description", x.description);
        dim.setProperty("table", x.table);
        dim.setProperty("type", x.type);
        dim.setProperty("primaryKey", x.primaryKey);
        dim.dimensionType = x.type != null && x.type.equalsIgnoreCase("Time") ? (byte)1 : 0;
        dim.hies = new HierarchyImpl[x.hierarchies.length];
        for (int i = 0; i < dim.hies.length; ++i) {
            dim.hies[i] = SchemaBuilder.buildHierarchy(i, dim, x.hierarchies[i]);
        }
        dim.setProperty("Permission", x.permission);
        dim.setProperty("dependOnDimension", x.dependOnDimension);
        return dim;
    }

    private static HierarchyImpl buildHierarchy(int ordinal, DimensionImpl dim, HierarchyDef x) throws CUBAException {
        int i;
        HierarchyImpl hie = new HierarchyImpl(dim, x.name, x.caption);
        hie.ordinal = ordinal;
        hie.setProperty("description", x.description);
        hie.setProperty("hasAll", x.hasAll);
        hie.setProperty("allMemberName", x.allMemberName);
        hie.setProperty("allMemberCaption", x.allMemberCaption);
        hie.setProperty("virtualAllMemberCaption", x.v$AllMemberCaption);
        hie.levels = new LevelImpl[x.levels.length];
        for (i = 0; i < hie.levels.length; ++i) {
            hie.levels[i] = SchemaBuilder.buildLevel(hie, x.levels[i]);
        }
        for (i = 0; i < hie.levels.length; ++i) {
            if (i > 0) {
                hie.levels[i].parent = hie.levels[i - 1];
            }
            if (i < hie.levels.length - 1) {
                hie.levels[i].child = hie.levels[i + 1];
            }
            hie.levels[i].depth = x.hasAll ? (byte)(i + 1) : (byte)i;
        }
        return hie;
    }

    private static LevelImpl buildLevel(HierarchyImpl hie, LevelDef x) throws CUBAException {
        LevelImpl level = new LevelImpl();
        level.hie = hie;
        level.setProperty("name", x.name);
        level.setProperty("caption", x.caption);
        level.setProperty("description", x.description);
        level.setProperty("type", x.type);
        level.levelType = x.type == null ? (byte)0 : Util.getLevelType(x.type);
        level.setProperty("column", x.column);
        level.setProperty("orderBy", x.orderBy);
        level.setProperty("parentColumn", x.parentColumn);
        level.setProperty("childColumn", x.childColumn);
        level.setProperty("dataType", x.dataType);
        level.setProperty("closureDataType", x.closureDataType);
        level.setProperty("rule", x.rule);
        level.props = new PropertyImpl[x.properties.length];
        for (int i = 0; i < level.props.length; ++i) {
            level.props[i] = SchemaBuilder.buildProperty(x.properties[i]);
        }
        if (x.parentColumn != null) {
            hie.dim.isParentChildren = true;
        }
        return level;
    }

    private static PropertyImpl buildProperty(PropertyDef x) {
        PropertyImpl p = new PropertyImpl();
        p.setProperty("name", x.name);
        p.setProperty("caption", x.caption);
        p.setProperty("description", x.description);
        p.setProperty("column", x.column);
        p.setProperty("dataType", x.dataType);
        return p;
    }

    private static CubeImpl buildCube(SchemaImpl schema, CubeDef x) throws CUBAException {
        int i;
        CubeImpl cube = new CubeImpl();
        cube.setProperty("name", x.name);
        cube.setProperty("caption", x.caption);
        cube.setProperty("description", x.description);
        cube.setProperty("table", x.table);
        cube.initMeasures(x);
        cube.dims = new DimensionImpl[x.dimensions.length];
        for (i = 0; i < cube.dims.length; ++i) {
            if (!(x.dimensions[i] instanceof DimensionUsageDef)) continue;
            cube.dims[i] = SchemaBuilder.buildDimensionUsage((DimensionImpl)schema.getDimension(x.dimensions[i].name), (DimensionUsageDef)x.dimensions[i]);
        }
        cube.measures = new MemberImpl[x.measures.length];
        for (i = 0; i < cube.measures.length; ++i) {
            cube.measures[i] = SchemaBuilder.buildMeasure(cube, x.measures[i]);
        }
        cube.measureHierarchy.setMembers(cube.measures);
        if (x.calculatedMembers == null) {
            cube.calculatedMembers = new CalculatedMemberImpl[0];
        } else {
            cube.calculatedMembers = new CalculatedMemberImpl[x.calculatedMembers.length];
            for (i = 0; i < x.calculatedMembers.length; ++i) {
                cube.calculatedMembers[i] = SchemaBuilder.buildCalculatedMember(cube, x.calculatedMembers[i]);
            }
        }
        return cube;
    }

    private static CalculatedMemberImpl buildCalculatedMember(CubeImpl cube, CalculatedMemberDef def) throws CUBAException {
        String[] uniqueName = new String[]{def.dimension, def.name};
        Exp exp = ParserHelp.parseExpression(def.formula);
        ArrayList<MemberProperty> jlist = new ArrayList<MemberProperty>();
        if (def.formatString != null) {
            jlist.add(new MemberProperty("formatString", Literal.createString(def.formatString)));
        }
        if (def.color != null) {
            jlist.add(new MemberProperty("color", Literal.createString(def.color)));
        }
        if (def.bgColor != null) {
            jlist.add(new MemberProperty("bgColor", Literal.createString(def.bgColor)));
        }
        if (def.trend != null) {
            jlist.add(new MemberProperty("trend", Literal.createString(def.trend)));
        }
        if (def.status != null) {
            jlist.add(new MemberProperty("status", Literal.createString(def.status)));
        }
        if (def.solveOrder != null) {
            jlist.add(new MemberProperty("SOLVE_ORDER", Literal.create(new Integer(def.solveOrder))));
        }
        if (def.caption != null) {
            jlist.add(new MemberProperty("caption", Literal.createString(def.caption)));
        }
        if (!def.visible) {
            jlist.add(new MemberProperty("visible", Literal.createString("false")));
        }
        if (def.properties != null) {
            for (int i = 0; i < def.properties.length; ++i) {
                jlist.add(new MemberProperty(def.properties[i].name, Literal.createString(def.properties[i].value)));
            }
        }
        MemberProperty[] properties = new MemberProperty[jlist.size()];
        jlist.toArray(properties);
        Formula formula = new Formula(uniqueName, exp, properties, null);
        Dimension dim = cube.getDimension(def.dimension);
        CalculatedMemberImpl m = (CalculatedMemberImpl)dim.getDefaultHierarchy().createMember(def.name, def.caption, formula, true);
        formula.setMember(m);
        return m;
    }

    private static DimensionImpl buildDimensionUsage(DimensionImpl source, DimensionUsageDef x) throws CUBAException {
        source.setProperty("foreignKey", x.foreignKey);
        return source;
    }

    private static MemberImpl buildMeasure(CubeImpl cube, MeasureDef x) {
        MemberImpl measure = new MemberImpl();
        if (x.name.equals("V$COUNTMEASURE")) {
            measure = (MemberImpl)cube.measureHierarchy.lookupInnerMember(x.name);
            measure.setProperty("caption", x.caption);
            return measure;
        }
        measure.memberType = (byte)2;
        measure.level = cube.measureLevel;
        measure.setProperty("name", x.name);
        measure.setProperty("caption", x.caption);
        measure.setProperty("description", x.description);
        measure.setProperty("column", x.column);
        measure.setProperty("aggregator", x.aggregator);
        measure.setProperty("formatString", x.formatString);
        measure.setProperty("color", x.color);
        measure.setProperty("bgColor", x.bgColor);
        measure.setProperty("trend", x.trend);
        measure.setProperty("status", x.status);
        measure.setProperty("visible", x.visible);
        if (x.properties != null) {
            for (int i = 0; i < x.properties.length; ++i) {
                measure.setProperty(x.properties[i].name, x.properties[i].value);
            }
        }
        return measure;
    }
}

