/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.cuba.mdx.calc.impl;

import com.kingdee.bos.streamwork.cuba.CUBAException;
import com.kingdee.bos.streamwork.cuba.Member;
import com.kingdee.bos.streamwork.cuba.collection.IList;
import com.kingdee.bos.streamwork.cuba.mdx.Evaluator;
import com.kingdee.bos.streamwork.cuba.mdx.Exp;
import com.kingdee.bos.streamwork.cuba.mdx.ExpResolver;
import com.kingdee.bos.streamwork.cuba.mdx.calc.Calc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.DimensionCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.DummyExp;
import com.kingdee.bos.streamwork.cuba.mdx.calc.ExpCompiler;
import com.kingdee.bos.streamwork.cuba.mdx.calc.HierarchyCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.LevelCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.ListCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.MemberCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.StringCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.TupleCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.AbstractListCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.AbstractMemberCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.AbstractStringCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.AbstractTupleCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.MemberValueCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.TupleValueCalc;
import com.kingdee.bos.streamwork.cuba.mdx.func.DimensionCurrentMemberFunDef;
import com.kingdee.bos.streamwork.cuba.mdx.func.HierarchyCurrentMemberFunDef;
import com.kingdee.bos.streamwork.cuba.mdx.func.HierarchyDimensionFunDef;
import com.kingdee.bos.streamwork.cuba.mdx.func.LevelHierarchyFunDef;
import com.kingdee.bos.streamwork.cuba.mdx.func.MemberHierarchyFunDef;
import com.kingdee.bos.streamwork.cuba.mdx.func.MemberLevelFunDef;
import com.kingdee.bos.streamwork.cuba.mdx.type.BooleanType;
import com.kingdee.bos.streamwork.cuba.mdx.type.DimensionType;
import com.kingdee.bos.streamwork.cuba.mdx.type.HierarchyType;
import com.kingdee.bos.streamwork.cuba.mdx.type.LevelType;
import com.kingdee.bos.streamwork.cuba.mdx.type.MemberType;
import com.kingdee.bos.streamwork.cuba.mdx.type.NumericType;
import com.kingdee.bos.streamwork.cuba.mdx.type.ScalarType;
import com.kingdee.bos.streamwork.cuba.mdx.type.StringType;
import com.kingdee.bos.streamwork.cuba.mdx.type.TupleType;
import com.kingdee.bos.streamwork.cuba.mdx.type.Type;
import com.kingdee.bos.streamwork.cuba.mdx.type.TypeUtil;
import com.kingdee.bos.streamwork.cuba.util.Util;

public abstract class AbstractExpCompiler
implements ExpCompiler {
    private final ExpResolver resolver;

    public AbstractExpCompiler(ExpResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public Calc compile(Exp exp) throws CUBAException {
        if (exp == null) {
            return null;
        }
        return exp.compile(this);
    }

    @Override
    public MemberCalc compileMember(Exp exp) throws CUBAException {
        Type type = exp.getType();
        if (type instanceof DimensionType) {
            DimensionCalc dimensionCalc = this.compileDimension(exp);
            return new DimensionCurrentMemberFunDef.CalcImpl((Exp)new DummyExp(TypeUtil.toMemberType(type)), dimensionCalc);
        }
        if (type instanceof HierarchyType) {
            HierarchyCalc hierarchyCalc = this.compileHierarchy(exp);
            return new HierarchyCurrentMemberFunDef.CalcImpl((Exp)new DummyExp(TypeUtil.toMemberType(type)), hierarchyCalc);
        }
        if (type instanceof MemberType) {
            final Calc calc = this.compile(exp);
            if (calc instanceof MemberCalc) {
                return (MemberCalc)calc;
            }
            return new AbstractMemberCalc(exp, new Calc[]{calc}){

                @Override
                public Member evaluateMember(Evaluator evaluator) throws CUBAException {
                    Object o = calc.evaluate(evaluator);
                    if (o == null || o instanceof Member) {
                        return (Member)o;
                    }
                    throw new CUBAException("Can't cast " + this.exp.toMdx() + " to Member.");
                }
            };
        }
        throw new CUBAException("Can't cast " + exp.toMdx() + " to Member.");
    }

    @Override
    public LevelCalc compileLevel(Exp exp) throws CUBAException {
        Type type = exp.getType();
        if (type instanceof MemberType) {
            MemberCalc memberCalc = this.compileMember(exp);
            return new MemberLevelFunDef.CalcImpl((Exp)new DummyExp(LevelType.forType(type)), memberCalc);
        }
        assert (type instanceof LevelType);
        return (LevelCalc)this.compile(exp);
    }

    @Override
    public DimensionCalc compileDimension(Exp exp) throws CUBAException {
        Type type = exp.getType();
        if (type instanceof HierarchyType) {
            HierarchyCalc hierarchyCalc = this.compileHierarchy(exp);
            return new HierarchyDimensionFunDef.CalcImpl(exp, hierarchyCalc);
        }
        return (DimensionCalc)this.compile(exp);
    }

    @Override
    public HierarchyCalc compileHierarchy(Exp exp) throws CUBAException {
        Type type = exp.getType();
        if (type instanceof DimensionType || type instanceof MemberType) {
            MemberCalc memberCalc = this.compileMember(exp);
            return new MemberHierarchyFunDef.CalcImpl((Exp)new DummyExp(HierarchyType.forType(type)), memberCalc);
        }
        if (type instanceof LevelType) {
            LevelCalc levelCalc = this.compileLevel(exp);
            return new LevelHierarchyFunDef.CalcImpl((Exp)new DummyExp(HierarchyType.forType(type)), levelCalc);
        }
        assert (type instanceof HierarchyType);
        return (HierarchyCalc)this.compile(exp);
    }

    @Override
    public StringCalc compileString(Exp exp) throws CUBAException {
        final Calc calc = this.compile(exp);
        if (calc instanceof StringCalc) {
            return (StringCalc)calc;
        }
        return new AbstractStringCalc(exp, new Calc[]{calc}){

            @Override
            public String evaluateString(Evaluator evaluator) throws CUBAException {
                Object value = calc.evaluate(evaluator);
                if (value == null || value == Util.nullValue) {
                    return "";
                }
                return value.toString();
            }
        };
    }

    @Override
    public ListCalc compileList(Exp exp) throws CUBAException {
        final Calc calc = this.compile(exp);
        if (calc instanceof ListCalc) {
            return (ListCalc)calc;
        }
        return new AbstractListCalc(exp, new Calc[]{calc}){

            @Override
            public IList evaluateList(Evaluator evaluator) throws CUBAException {
                IList list = evaluator.getQuery().getListFactory().createArrayList();
                Object value = calc.evaluate(evaluator);
                if (!(value instanceof Member) && !(value instanceof Member[])) {
                    throw new CUBAException("can't cast " + this.exp.toMdx() + " to List.");
                }
                list.add(value);
                return list;
            }
        };
    }

    @Override
    public TupleCalc compileTuple(Exp exp) throws CUBAException {
        final Calc calc = this.compile(exp);
        if (calc instanceof TupleCalc) {
            return (TupleCalc)calc;
        }
        return new AbstractTupleCalc(exp, new Calc[]{calc}){

            @Override
            public Member[] evaluateTuple(Evaluator evaluator) throws CUBAException {
                Object value = calc.evaluate(evaluator);
                if (value instanceof Member) {
                    return new Member[]{(Member)value};
                }
                throw new CUBAException("can't cast " + this.exp.toMdx() + " to Tuple.");
            }
        };
    }

    @Override
    public Calc compileScalar(Exp exp, boolean convert) throws CUBAException {
        Type type = exp.getType();
        if (type instanceof MemberType) {
            MemberType memberType = (MemberType)type;
            MemberCalc calc = this.compileMember(exp);
            return new MemberValueCalc(new DummyExp(memberType.getValueType()), new MemberCalc[]{calc});
        }
        if (type instanceof DimensionType) {
            DimensionCalc dimensionCalc = this.compileDimension(exp);
            MemberType memberType = MemberType.forType(type);
            DimensionCurrentMemberFunDef.CalcImpl dimensionCurrentMemberCalc = new DimensionCurrentMemberFunDef.CalcImpl((Exp)new DummyExp(memberType), dimensionCalc);
            return new MemberValueCalc(new DummyExp(memberType.getValueType()), new MemberCalc[]{dimensionCurrentMemberCalc});
        }
        if (type instanceof HierarchyType) {
            HierarchyType hierarchyType = (HierarchyType)type;
            MemberType memberType = MemberType.forHierarchy(hierarchyType.getHierarchy());
            HierarchyCalc hierarchyCalc = this.compileHierarchy(exp);
            HierarchyCurrentMemberFunDef.CalcImpl hierarchyCurrentMemberCalc = new HierarchyCurrentMemberFunDef.CalcImpl((Exp)new DummyExp(type), hierarchyCalc);
            return new MemberValueCalc(new DummyExp(memberType.getValueType()), new MemberCalc[]{hierarchyCurrentMemberCalc});
        }
        if (type instanceof TupleType) {
            TupleType tupleType = (TupleType)type;
            TupleCalc tupleCalc = this.compileTuple(exp);
            TupleValueCalc scalarCalc = new TupleValueCalc(new DummyExp(tupleType.getValueType()), tupleCalc);
            return scalarCalc;
        }
        if (type instanceof ScalarType) {
            if (convert) {
                if (type instanceof BooleanType) {
                    return this.compileBoolean(exp);
                }
                if (type instanceof NumericType) {
                    return this.compileBigDecimal(exp);
                }
                if (type instanceof StringType) {
                    return this.compileString(exp);
                }
                return this.compile(exp);
            }
            return this.compile(exp);
        }
        return this.compile(exp);
    }

    @Override
    public ExpResolver getResolver() {
        return this.resolver;
    }
}

