/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func;

import com.kingdee.bos.streamwork.cuba.CUBAException;
import com.kingdee.bos.streamwork.cuba.Member;
import com.kingdee.bos.streamwork.cuba.collection.IList;
import com.kingdee.bos.streamwork.cuba.mdx.Evaluator;
import com.kingdee.bos.streamwork.cuba.mdx.FunCall;
import com.kingdee.bos.streamwork.cuba.mdx.calc.Calc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.DoubleCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.ListCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.AbstractListCalc;
import com.kingdee.bos.streamwork.cuba.mdx.func.FuncUtil2;
import com.kingdee.bos.streamwork.cuba.util.Util;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TopBottomPercentSumCalc
extends AbstractListCalc {
    private final ListCalc listCalc;
    private final DoubleCalc doubleCalc;
    private final Calc calc;
    private final boolean top;
    private final boolean percent;

    public TopBottomPercentSumCalc(FunCall call, ListCalc listCalc, DoubleCalc doubleCalc, Calc calc, boolean top, boolean percent) {
        super(call, new Calc[]{listCalc, doubleCalc, calc});
        this.listCalc = listCalc;
        this.doubleCalc = doubleCalc;
        this.calc = calc;
        this.top = top;
        this.percent = percent;
    }

    @Override
    public IList evaluateList(Evaluator evaluator) throws CUBAException {
        IList list = this.listCalc.evaluateList(evaluator);
        double target = this.doubleCalc.evaluateDouble(evaluator);
        if (list.isEmpty()) {
            return list;
        }
        Object first = list.getFirst();
        Map mapMemberToValue = first instanceof Member ? FuncUtil2.evaluateMembers(evaluator, this.calc, list, false) : this.evaluateTuples(evaluator, this.calc, list);
        FuncUtil2.sort(evaluator, list, this.calc, this.top, true);
        if (this.percent) {
            this.toPercent(list, mapMemberToValue);
        }
        double runningTotal = 0.0;
        int nullCount = 0;
        int i = 0;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object o;
            if (runningTotal >= target) {
                list = list.subList(0, i);
                break;
            }
            Object key = iter.next();
            if (key instanceof Member[]) {
                key = new TupleKey((Member[])key);
            }
            if ((o = mapMemberToValue.get(key)) == Util.nullValue) {
                ++nullCount;
            } else if (o instanceof Number) {
                runningTotal += ((Number)o).doubleValue();
            }
            ++i;
        }
        return list;
    }

    private Map evaluateTuples(Evaluator evaluator, Calc exp, IList members) throws CUBAException {
        HashMap<TupleKey, Object> mapMemberToValue = new HashMap<TupleKey, Object>();
        Iterator iter = members.iterator();
        while (iter.hasNext()) {
            Member[] tuples = (Member[])iter.next();
            evaluator.setContext(tuples);
            Object result = exp.evaluate(evaluator);
            if (result == null) {
                result = Util.nullValue;
            }
            mapMemberToValue.put(new TupleKey(tuples), result);
        }
        return mapMemberToValue;
    }

    private void toPercent(IList members, Map mapMemberToValue) {
        Object o;
        Object key;
        double total = 0.0;
        Iterator iter = members.iterator();
        while (iter.hasNext()) {
            key = iter.next();
            if (key instanceof Member[]) {
                key = new TupleKey((Member[])key);
            }
            if (!((o = mapMemberToValue.get(key)) instanceof Number)) continue;
            total += ((Number)o).doubleValue();
        }
        iter = members.iterator();
        while (iter.hasNext()) {
            key = iter.next();
            if (key instanceof Member[]) {
                key = new TupleKey((Member[])key);
            }
            if (!((o = mapMemberToValue.get(key)) instanceof Number)) continue;
            double d = ((Number)o).doubleValue();
            mapMemberToValue.put(key, new Double(d / total * 100.0));
        }
    }

    private class TupleKey {
        Member[] tuples;

        TupleKey(Member[] tuples) {
            this.tuples = tuples;
        }

        public boolean equals(Object a) {
            TupleKey b = (TupleKey)a;
            for (int i = 0; i < this.tuples.length; ++i) {
                if (this.tuples[i].equals(b.tuples[i])) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int x = 0;
            for (int i = 0; i < this.tuples.length; ++i) {
                x ^= this.tuples[i].hashCode();
            }
            return x;
        }
    }
}

