/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.cuba.mdx.func;

import com.kingdee.bos.streamwork.cuba.CUBAException;
import com.kingdee.bos.streamwork.cuba.Cube;
import com.kingdee.bos.streamwork.cuba.Dimension;
import com.kingdee.bos.streamwork.cuba.Formatter;
import com.kingdee.bos.streamwork.cuba.Hierarchy;
import com.kingdee.bos.streamwork.cuba.Level;
import com.kingdee.bos.streamwork.cuba.Member;
import com.kingdee.bos.streamwork.cuba.mdx.Evaluator;
import com.kingdee.bos.streamwork.cuba.mdx.Exp;
import com.kingdee.bos.streamwork.cuba.mdx.ExpBase;
import com.kingdee.bos.streamwork.cuba.mdx.ExpResolver;
import com.kingdee.bos.streamwork.cuba.mdx.FunCall;
import com.kingdee.bos.streamwork.cuba.mdx.FunDef;
import com.kingdee.bos.streamwork.cuba.mdx.FunDefBase;
import com.kingdee.bos.streamwork.cuba.mdx.FunFactory;
import com.kingdee.bos.streamwork.cuba.mdx.FunTable;
import com.kingdee.bos.streamwork.cuba.mdx.FuncResolverBase;
import com.kingdee.bos.streamwork.cuba.mdx.Literal;
import com.kingdee.bos.streamwork.cuba.mdx.MultiFuncResolver;
import com.kingdee.bos.streamwork.cuba.mdx.SchemaReader;
import com.kingdee.bos.streamwork.cuba.mdx.Syntax;
import com.kingdee.bos.streamwork.cuba.mdx.TypeConvertUtil;
import com.kingdee.bos.streamwork.cuba.mdx.calc.BigDecimalCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.BooleanCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.Calc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.DimensionCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.ExpCompiler;
import com.kingdee.bos.streamwork.cuba.mdx.calc.HierarchyCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.IntegerCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.LevelCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.ListCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.MemberCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.StringCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.TupleCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.AbstractBigDecimalCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.AbstractBooleanCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.AbstractCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.AbstractDimensionCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.AbstractMemberCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.AbstractNumberCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.AbstractStringCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.ConstantCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.DimensionCurrentMemberCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.GenericCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.ValueCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.AggregateCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.AncestorLevelCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.AncestorNCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.AscendantsCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.AvgCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.ChidrenCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.CountCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.DimensionFirstMemberCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.DimensionMembersCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.DistinctCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.ExceptCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.FirstChildCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.FirstSiblingCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.GenerateCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.GenerateStringCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.HeadCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.HierarchizeCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.HierarchyMembersAboveLevelCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.HierarchyMembersCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.IIfNumberCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.IIfStringCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.LastChildCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.LastSiblingCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.LevelFirstMemberCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.LevelLastMemberCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.LevelMembersCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.LevelOrdinalCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.LevelsCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.MaxCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.MemberRangeCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.MinCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.NonEmpty2Calc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.NonEmptyCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.OpeningClosingCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.ParallelPeriodCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.PeriodsToDateCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.SiblingsCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.SubsetCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.SumCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.TailCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.UnionCalc;
import com.kingdee.bos.streamwork.cuba.mdx.elementexp.MemberExpr;
import com.kingdee.bos.streamwork.cuba.mdx.func.CoalesceEmptyFunDef;
import com.kingdee.bos.streamwork.cuba.mdx.func.CrossJoinFunDef;
import com.kingdee.bos.streamwork.cuba.mdx.func.DescendantsFunDef;
import com.kingdee.bos.streamwork.cuba.mdx.func.DimensionCurrentMemberFunDef;
import com.kingdee.bos.streamwork.cuba.mdx.func.FilterFunDef;
import com.kingdee.bos.streamwork.cuba.mdx.func.FuncUtil2;
import com.kingdee.bos.streamwork.cuba.mdx.func.HierarchyCurrentMemberFunDef;
import com.kingdee.bos.streamwork.cuba.mdx.func.HierarchyDimensionFunDef;
import com.kingdee.bos.streamwork.cuba.mdx.func.IntersectFunDef;
import com.kingdee.bos.streamwork.cuba.mdx.func.LevelHierarchyFunDef;
import com.kingdee.bos.streamwork.cuba.mdx.func.MemberHierarchyFunDef;
import com.kingdee.bos.streamwork.cuba.mdx.func.MemberLevelFunDef;
import com.kingdee.bos.streamwork.cuba.mdx.func.OrderFunDef;
import com.kingdee.bos.streamwork.cuba.mdx.func.ParenthesesFunDef;
import com.kingdee.bos.streamwork.cuba.mdx.func.PropertiesFunDef;
import com.kingdee.bos.streamwork.cuba.mdx.func.SetFunDef;
import com.kingdee.bos.streamwork.cuba.mdx.func.SetItemFunDef;
import com.kingdee.bos.streamwork.cuba.mdx.func.TopBottomCountFunDef;
import com.kingdee.bos.streamwork.cuba.mdx.func.TopBottomPercentSumFunDef;
import com.kingdee.bos.streamwork.cuba.mdx.func.TupleFunDef;
import com.kingdee.bos.streamwork.cuba.mdx.func.TupleItemFunDef;
import com.kingdee.bos.streamwork.cuba.mdx.func.ValueFunDef;
import com.kingdee.bos.streamwork.cuba.mdx.func.XtdFunDef;
import com.kingdee.bos.streamwork.cuba.mdx.type.DimensionType;
import com.kingdee.bos.streamwork.cuba.mdx.type.LevelType;
import com.kingdee.bos.streamwork.cuba.mdx.type.MemberType;
import com.kingdee.bos.streamwork.cuba.mdx.type.NumericType;
import com.kingdee.bos.streamwork.cuba.mdx.type.SetType;
import com.kingdee.bos.streamwork.cuba.mdx.type.Type;
import com.kingdee.bos.streamwork.cuba.util.IntHolder;
import com.kingdee.bos.streamwork.cuba.util.UniqueNameUtil;
import com.kingdee.bos.streamwork.cuba.util.Util;
import com.kingdee.bos.streamwork.cuba.util.ValueNotReady;
import java.math.BigDecimal;
import java.util.LinkedList;

public class BaseFunFactory
extends FunFactory {
    public BaseFunFactory(FunTable funTable) {
        super(funTable);
    }

    @Override
    public void defineFunctions() {
        this.define(HierarchyDimensionFunDef.instance);
        this.define(new FunDefBase("Dimension", "<Dimension>.Dimension", "Returns the dimension that contains a specified hierarchy.", "pdd"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) {
                Dimension dimension = ((Dimension)((Object)call.getArg(0))).getDimension();
                return new ConstantCalc(DimensionType.forDimension(dimension), dimension);
            }
        });
        this.define(new FunDefBase("Dimension", "<Level>.Dimension", "Returns the dimension that contains a specified level.", "pdl"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final LevelCalc levelCalc = compiler.compileLevel(call.getArg(0));
                return new AbstractDimensionCalc(call, new Calc[]{levelCalc}){

                    @Override
                    public Dimension evaluateDimension(Evaluator evaluator) throws CUBAException {
                        Level level = levelCalc.evaluateLevel(evaluator);
                        return level.getDimension();
                    }
                };
            }
        });
        this.define(new FunDefBase("Dimension", "<Member>.Dimension", "Returns the dimension that contains a specified member.", "pdm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractDimensionCalc(call, new Calc[]{memberCalc}){

                    @Override
                    public Dimension evaluateDimension(Evaluator evaluator) throws CUBAException {
                        Member member = memberCalc.evaluateMember(evaluator);
                        return member.getDimension();
                    }
                };
            }
        });
        this.define(LevelHierarchyFunDef.instance);
        this.define(MemberHierarchyFunDef.instance);
        this.define(MemberLevelFunDef.instance);
        this.define(new FunDefBase("Levels", "<Hierarchy>.Levels(<Numeric Expression>)", "Returns the level whose position in a hierarchy is specified by a numeric expression.", "mlhn"){

            @Override
            public Type getResultType(ExpResolver resolver, Exp[] args) {
                Type argType = args[0].getType();
                return new LevelType(argType.getHierarchy(), argType.getLevel());
            }

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                HierarchyCalc hierarchyCalc = compiler.compileHierarchy(call.getArg(0));
                IntegerCalc ordinalCalc = compiler.compileInteger(call.getArg(1));
                return new LevelsCalc(call, hierarchyCalc, ordinalCalc);
            }
        });
        this.define(new MultiFuncResolver("IsEmpty", "IsEmpty(<Value Expression>)", "Determines if an expression evaluates to the empty cell value.", new String[]{"fbS", "fbn"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                        final Calc calc = compiler.compileScalar(call.getArg(0), true);
                        return new AbstractBooleanCalc(call, new Calc[]{calc}){

                            @Override
                            public boolean evaluateBoolean(Evaluator evaluator) throws CUBAException {
                                Object o = calc.evaluate(evaluator);
                                return o == null || o == Util.nullValue;
                            }
                        };
                    }
                };
            }
        });
        this.define(new FunDefBase("IS NULL", "<Member> IS NULL", "Returns whether a member is null.", "pbm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractBooleanCalc(call, new Calc[]{memberCalc}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws CUBAException {
                        Member member = memberCalc.evaluateMember(evaluator);
                        if (member == null) {
                            return true;
                        }
                        return member.isNull();
                    }
                };
            }
        });
        this.define(new FunDefBase("IsNull", "IsNull(<Member>)", "Determines if a member is null.", "fbm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractBooleanCalc(call, new Calc[]{memberCalc}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws CUBAException {
                        Member member = memberCalc.evaluateMember(evaluator);
                        if (member == null) {
                            return true;
                        }
                        return member.isNull();
                    }
                };
            }
        });
        this.define(new FunDefBase("IsLeaf", "IsLeaf(<Member>)", "Determines if a member is leaf.", "fbm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractBooleanCalc(call, new Calc[]{memberCalc}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws CUBAException {
                        Member member = memberCalc.evaluateMember(evaluator);
                        return member.isLeaf();
                    }
                };
            }
        });
        this.define(DimensionCurrentMemberFunDef.instance);
        this.define(HierarchyCurrentMemberFunDef.instance);
        this.define(new FunDefBase("DefaultMember", "<Dimension>.DefaultMember", "Returns the default member of a dimension.", "pmd"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final DimensionCalc dimensionCalc = compiler.compileDimension(call.getArg(0));
                return new AbstractMemberCalc(call, new Calc[]{dimensionCalc}){

                    @Override
                    public Member evaluateMember(Evaluator evaluator) throws CUBAException {
                        Dimension dimension = dimensionCalc.evaluateDimension(evaluator);
                        return evaluator.getSchemaReader().getHierarchyDefaultMember(dimension.getDefaultHierarchy());
                    }
                };
            }
        });
        this.define(new FunDefBase("FirstMember", "<Dimension>.FirstMember", "Returns the first member of a dimension.", "pmd"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                DimensionCalc dimensionCalc = compiler.compileDimension(call.getArg(0));
                return new DimensionFirstMemberCalc((Exp)call, dimensionCalc);
            }
        });
        this.define(new FunDefBase("FirstChild", "<Member>.FirstChild", "Returns the first child of a member.", "pmm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new FirstChildCalc((Exp)call, memberCalc);
            }
        });
        this.define(new FunDefBase("FirstSibling", "<Member>.FirstSibling", "Returns the first child of the parent of a member.", "pmm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new FirstSiblingCalc((Exp)call, memberCalc);
            }
        });
        this.define(new FunDefBase("LastChild", "<Member>.LastChild", "Returns the last child of a member.", "pmm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new LastChildCalc((Exp)call, memberCalc);
            }
        });
        this.define(new FunDefBase("LastSibling", "<Member>.LastSibling", "Returns the last child of the parent of a member.", "pmm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new LastSiblingCalc((Exp)call, memberCalc);
            }
        });
        this.define(new FunDefBase("Lead", "<Member>.Lead(<Numeric Expression>)", "Returns a member further along the specified member's dimension.", "mmmn"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                final IntegerCalc integerCalc = compiler.compileInteger(call.getArg(1));
                return new AbstractMemberCalc(call, new Calc[]{memberCalc, integerCalc}){

                    @Override
                    public Member evaluateMember(Evaluator evaluator) throws CUBAException {
                        Member member = memberCalc.evaluateMember(evaluator);
                        int n = integerCalc.evaluateInteger(evaluator);
                        return evaluator.getSchemaReader().getLeadMember(member, n);
                    }
                };
            }
        });
        this.define(new FunDefBase("Lag", "<Member>.Lag(<Numeric Expression>)", "Returns a member further along the specified member's dimension.", "mmmn"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                final IntegerCalc integerCalc = compiler.compileInteger(call.getArg(1));
                return new AbstractMemberCalc(call, new Calc[]{memberCalc, integerCalc}){

                    @Override
                    public Member evaluateMember(Evaluator evaluator) throws CUBAException {
                        Member member = memberCalc.evaluateMember(evaluator);
                        int n = integerCalc.evaluateInteger(evaluator);
                        return evaluator.getSchemaReader().getLeadMember(member, -n);
                    }
                };
            }
        });
        this.define(new FunDefBase("NextMember", "<Member>.NextMember", "Returns the next member in the level that contains a specified member.", "pmm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractMemberCalc(call, new Calc[]{memberCalc}){

                    @Override
                    public Member evaluateMember(Evaluator evaluator) throws CUBAException {
                        Member member = memberCalc.evaluateMember(evaluator);
                        return evaluator.getSchemaReader().getLeadMember(member, 1);
                    }
                };
            }
        });
        this.define(new MultiFuncResolver("OpeningPeriod", "OpeningPeriod([<Level>[, <Member>]])", "Returns the first descendant of a member at a level.", new String[]{"fm", "fml", "fmlm"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Type getResultType(ExpResolver resolver, Exp[] args) throws CUBAException {
                        if (args.length == 0) {
                            Dimension timeDimension = resolver.getQuery().getCube().getTimeDimension();
                            if (timeDimension == null) {
                                throw new CUBAException("OpeningPeriod with no arguments must apply to Time Dimension,but the cube has no TimeDimension.");
                            }
                            Hierarchy hierarchy = timeDimension.getDefaultHierarchy();
                            return new MemberType(hierarchy, null, null);
                        }
                        return super.getResultType(resolver, args);
                    }

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                        Dimension levelDimension;
                        Dimension memberDimension;
                        LevelCalc levelCalc;
                        MemberCalc memberCalc;
                        Exp[] args = call.getArgs();
                        Dimension defaultTimeDimension = null;
                        switch (args.length) {
                            case 0: {
                                defaultTimeDimension = compiler.getResolver().getQuery().getCube().getTimeDimension();
                                if (defaultTimeDimension == null) {
                                    throw new CUBAException("OpeningPeriod with no arguments must apply to Time Dimension,but the cube has no TimeDimension.");
                                }
                                memberCalc = new DimensionCurrentMemberCalc(defaultTimeDimension);
                                levelCalc = null;
                                break;
                            }
                            case 1: {
                                defaultTimeDimension = compiler.getResolver().getQuery().getCube().getTimeDimension();
                                if (defaultTimeDimension == null) {
                                    throw new CUBAException("OpeningPeriod with no arguments must apply to Time Dimension,but the cube has no TimeDimension.");
                                }
                                levelCalc = compiler.compileLevel(call.getArg(0));
                                memberCalc = new DimensionCurrentMemberCalc(defaultTimeDimension);
                                break;
                            }
                            default: {
                                levelCalc = compiler.compileLevel(call.getArg(0));
                                memberCalc = compiler.compileMember(call.getArg(1));
                            }
                        }
                        if (levelCalc != null && !(memberDimension = memberCalc.getType().getHierarchy().getDimension()).equals(levelDimension = levelCalc.getType().getHierarchy().getDimension())) {
                            throw new CUBAException("OpeningPeriod level and member must in same dimension.");
                        }
                        return new OpeningClosingCalc(call, levelCalc, memberCalc, true);
                    }
                };
            }
        });
        this.define(new MultiFuncResolver("ClosingPeriod", "ClosingPeriod([<Level>[, <Member>]])", "Returns the last descendant of a member at a level.", new String[]{"fm", "fml", "fmlm", "fmm"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Type getResultType(ExpResolver resolver, Exp[] args) throws CUBAException {
                        if (args.length == 0) {
                            Dimension timeDimension = resolver.getQuery().getCube().getTimeDimension();
                            if (timeDimension == null) {
                                throw new CUBAException("ClosingPeriod with no arguments must apply to Time Dimension,but the cube has no TimeDimension.");
                            }
                            Hierarchy hierarchy = resolver.getQuery().getCube().getTimeDimension().getDefaultHierarchy();
                            return new MemberType(hierarchy, null, null);
                        }
                        return super.getResultType(resolver, args);
                    }

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                        Dimension levelDimension;
                        Dimension memberDimension;
                        LevelCalc levelCalc;
                        MemberCalc memberCalc;
                        Exp[] args = call.getArgs();
                        Dimension defaultTimeDimension = null;
                        switch (args.length) {
                            case 0: {
                                defaultTimeDimension = compiler.getResolver().getQuery().getCube().getTimeDimension();
                                if (defaultTimeDimension == null) {
                                    throw new CUBAException("ClosingPeriod with no arguments must apply to Time Dimension,but the cube has no TimeDimension.");
                                }
                                memberCalc = new DimensionCurrentMemberCalc(defaultTimeDimension);
                                levelCalc = null;
                                break;
                            }
                            case 1: {
                                defaultTimeDimension = compiler.getResolver().getQuery().getCube().getTimeDimension();
                                if (defaultTimeDimension == null) {
                                    throw new CUBAException("ClosingPeriod with no arguments must apply to Time Dimension,but the cube has no TimeDimension.");
                                }
                                levelCalc = compiler.compileLevel(call.getArg(0));
                                memberCalc = new DimensionCurrentMemberCalc(defaultTimeDimension);
                                break;
                            }
                            default: {
                                levelCalc = compiler.compileLevel(call.getArg(0));
                                memberCalc = compiler.compileMember(call.getArg(1));
                            }
                        }
                        if (levelCalc != null && !(memberDimension = memberCalc.getType().getHierarchy().getDimension()).equals(levelDimension = levelCalc.getType().getHierarchy().getDimension())) {
                            throw new CUBAException("ClosingPeriod level and member must in same dimension.");
                        }
                        return new OpeningClosingCalc(call, levelCalc, memberCalc, false);
                    }
                };
            }
        });
        this.define(new MultiFuncResolver("ParallelPeriod", "ParallelPeriod([<Level>[, <Numeric Expression>[, <Member>]]])", "Returns a member from a prior period in the same relative position as a specified member.", new String[]{"fm", "fml", "fmln", "fmlnm"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Type getResultType(ExpResolver resolver, Exp[] args) throws CUBAException {
                        if (args.length == 0) {
                            Hierarchy hierarchy = resolver.getQuery().getCube().getTimeDimension().getDefaultHierarchy();
                            return new MemberType(hierarchy, null, null);
                        }
                        return super.getResultType(resolver, args);
                    }

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                        MemberCalc memberCalc;
                        Exp[] args = call.getArgs();
                        switch (args.length) {
                            case 3: {
                                memberCalc = compiler.compileMember(args[2]);
                                break;
                            }
                            case 1: {
                                Dimension dimension = args[0].getType().getHierarchy().getDimension();
                                memberCalc = new DimensionCurrentMemberCalc(dimension);
                                break;
                            }
                            default: {
                                Dimension timeDimension = compiler.getResolver().getQuery().getCube().getTimeDimension();
                                memberCalc = new DimensionCurrentMemberCalc(timeDimension);
                            }
                        }
                        IntegerCalc lagValueCalc = args.length >= 2 ? compiler.compileInteger(args[1]) : ConstantCalc.constantInteger(1);
                        LevelCalc ancestorLevelCalc = args.length >= 1 ? compiler.compileLevel(args[0]) : null;
                        return new ParallelPeriodCalc(call, memberCalc, lagValueCalc, ancestorLevelCalc);
                    }
                };
            }
        });
        this.define(new FunDefBase("Parent", "<Member>.Parent", "Returns the parent of a member.", "pmm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractMemberCalc(call, new Calc[]{memberCalc}){

                    @Override
                    public Member evaluateMember(Evaluator evaluator) throws CUBAException {
                        Member member = memberCalc.evaluateMember(evaluator);
                        Member parent = evaluator.getSchemaReader().getMemberParent(member);
                        if (parent == null) {
                            parent = member.getHierarchy().getNullMember();
                        }
                        return parent;
                    }
                };
            }
        });
        this.define(new FunDefBase("PrevMember", "<Member>.PrevMember", "Returns the previous member in the level that contains a specified member.", "pmm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractMemberCalc(call, new Calc[]{memberCalc}){

                    @Override
                    public Member evaluateMember(Evaluator evaluator) throws CUBAException {
                        Member member = memberCalc.evaluateMember(evaluator);
                        return evaluator.getSchemaReader().getLeadMember(member, -1);
                    }
                };
            }
        });
        this.define(new FunDefBase("StrToMember", "StrToMember(<String Expression>)", "Returns a member from a unique name String in MDX format.", "fmS"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final StringCalc memberNameCalc = compiler.compileString(call.getArg(0));
                return new AbstractMemberCalc(call, new Calc[]{memberNameCalc}){

                    @Override
                    public Member evaluateMember(Evaluator evaluator) throws CUBAException {
                        String mname = memberNameCalc.evaluateString(evaluator);
                        Cube cube = evaluator.getCube();
                        SchemaReader schemaReader = evaluator.getSchemaReader();
                        String[] uniqueNameParts = UniqueNameUtil.explode(mname);
                        Member member = (Member)schemaReader.lookupCompound(cube, uniqueNameParts, 6);
                        return member;
                    }
                };
            }
        });
        this.define(new MultiFuncResolver("Aggregate", "Aggregate(<Set>[, <Numeric Expression>])", "Returns a calculated value using the appropriate aggregate function, based on the context of the query.", new String[]{"fnx", "fnxn"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                        ListCalc listCalc = compiler.compileList(call.getArg(0));
                        ValueCalc calc = call.getArgCount() > 1 ? compiler.compileScalar(call.getArg(1), true) : new ValueCalc(call);
                        return new AggregateCalc(call, listCalc, calc);
                    }
                };
            }
        });
        this.define(new MultiFuncResolver("Avg", "Avg(<Set>[, <Numeric Expression>])", "Returns the average value of a numeric expression evaluated over a set.", new String[]{"fnx", "fnxn"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                        ListCalc listCalc = compiler.compileList(call.getArg(0));
                        ValueCalc calc = call.getArgCount() > 1 ? compiler.compileScalar(call.getArg(1), true) : new ValueCalc(call);
                        return new AvgCalc(call, listCalc, calc);
                    }
                };
            }
        });
        final String[] resWords = new String[]{"INCLUDEEMPTY", "EXCLUDEEMPTY"};
        this.define(new MultiFuncResolver("Count", "Count(<Set>[, EXCLUDEEMPTY | INCLUDEEMPTY])", "Returns the number of tuples in a set, empty cells included unless the optional EXCLUDEEMPTY flag is used.", new String[]{"fnx", "fnxy"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                        ListCalc memberListCalc = compiler.compileList(call.getArg(0));
                        boolean includeEmpty = call.getArgCount() < 2 || ((Literal)call.getArg(1)).getValueObject().equals("INCLUDEEMPTY");
                        return new CountCalc(call, memberListCalc, includeEmpty);
                    }
                };
            }

            @Override
            public String[] getReservedWords() {
                return resWords;
            }
        });
        this.define(new FunDefBase("Count", "<Set>.Count", "Returns the number of tuples in a set including empty cells.", "pnx"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                ListCalc memberListCalc = compiler.compileList(call.getArg(0));
                return new CountCalc(call, memberListCalc, true);
            }
        });
        this.define(new FunDefBase("IIf", "IIf(<Logical Expression>, <String Expression1>, <String Expression2>)", "Returns one of two string values determined by a logical test.", "fSbSS"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                BooleanCalc booleanCalc = compiler.compileBoolean(call.getArg(0));
                StringCalc calc1 = compiler.compileString(call.getArg(1));
                StringCalc calc2 = compiler.compileString(call.getArg(2));
                return new IIfStringCalc(call, booleanCalc, calc1, calc2);
            }
        });
        this.define(new FunDefBase("IIf", "IIf(<Logical Expression>, <Numeric Expression1>, <Numeric Expression2>)", "Returns one of two numeric values determined by a logical test.", "fnbnn"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                BooleanCalc booleanCalc = compiler.compileBoolean(call.getArg(0));
                Calc calc1 = compiler.compileScalar(call.getArg(1), true);
                Calc calc2 = compiler.compileScalar(call.getArg(2), true);
                return new IIfNumberCalc(call, booleanCalc, calc1, calc2);
            }
        });
        this.define(new MultiFuncResolver("Max", "Max(<Set>[, <Numeric Expression>])", "Returns the maximum value of a numeric expression evaluated over a set.", new String[]{"fnx", "fnxn"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                        ListCalc listCalc = compiler.compileList(call.getArg(0));
                        ValueCalc calc = call.getArgCount() > 1 ? compiler.compileScalar(call.getArg(1), true) : new ValueCalc(call);
                        return new MaxCalc(call, listCalc, calc);
                    }
                };
            }
        });
        this.define(new MultiFuncResolver("Min", "Min(<Set>[, <Numeric Expression>])", "Returns the minimum value of a numeric expression evaluated over a set.", new String[]{"fnx", "fnxn"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                        ListCalc listCalc = compiler.compileList(call.getArg(0));
                        ValueCalc calc = call.getArgCount() > 1 ? compiler.compileScalar(call.getArg(1), true) : new ValueCalc(call);
                        return new MinCalc(call, listCalc, calc);
                    }
                };
            }
        });
        this.define(new FunDefBase("Ordinal", "<Level>.Ordinal", "Returns the zero-based ordinal value associated with a level.", "pnl"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                LevelCalc levelCalc = compiler.compileLevel(call.getArg(0));
                return new LevelOrdinalCalc((Exp)call, levelCalc);
            }
        });
        this.define(new MultiFuncResolver("Sum", "Sum(<Set>[, <Numeric Expression>])", "Returns the sum of a numeric expression evaluated over a set.", new String[]{"fnx", "fnxn"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                        ListCalc listCalc = compiler.compileList(call.getArg(0));
                        ValueCalc calc = call.getArgCount() > 1 ? compiler.compileScalar(call.getArg(1), true) : new ValueCalc(call);
                        return new SumCalc(call, listCalc, calc);
                    }
                };
            }
        });
        this.define(new FunDefBase("Value", "<Measure>.Value", "Returns the value of a measure.", "pnm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                Calc[] calcs = new Calc[]{memberCalc};
                return new AbstractNumberCalc(call, calcs){

                    @Override
                    public Number evaluateNumber(Evaluator evaluator) throws CUBAException {
                        Member member = memberCalc.evaluateMember(evaluator);
                        Member old = evaluator.setContext(member);
                        Object value = evaluator.evaluateCurrent();
                        evaluator.setContext(old);
                        if (value == Util.nullValue) {
                            return null;
                        }
                        return (Number)value;
                    }

                    @Override
                    public Calc[] getCalcs() {
                        return new Calc[]{memberCalc};
                    }
                };
            }
        });
        this.define(new FunDefBase("_Value", "_Value(<Tuple>)", "Returns the value of the current measure within the context of a tuple.", "fnt"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final TupleCalc tupleCalc = compiler.compileTuple(call.getArg(0));
                return new AbstractCalc(call){

                    @Override
                    public Object evaluate(Evaluator evaluator) throws CUBAException {
                        Member[] tuple = tupleCalc.evaluateTuple(evaluator);
                        Evaluator evaluator2 = evaluator.push(tuple);
                        Object value = evaluator2.evaluateCurrent();
                        if (value == Util.nullValue) {
                            return null;
                        }
                        return value;
                    }

                    @Override
                    public Calc[] getCalcs() {
                        return new Calc[]{tupleCalc};
                    }
                };
            }
        });
        this.define(new FunDefBase("Value", "Value(<Tuple>)", "Returns the value of the current measure within the context of a tuple.", "fnt"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final TupleCalc tupleCalc = compiler.compileTuple(call.getArg(0));
                return new AbstractNumberCalc(call, new Calc[]{tupleCalc}){

                    @Override
                    public Number evaluateNumber(Evaluator evaluator) throws CUBAException {
                        Member[] tuple = tupleCalc.evaluateTuple(evaluator);
                        Evaluator evaluator2 = evaluator.push(tuple);
                        Object value = evaluator2.evaluateCurrent();
                        if (value == Util.nullValue) {
                            return null;
                        }
                        return (Number)value;
                    }
                };
            }
        });
        this.define(new FuncResolverBase("Value", null, null, Syntax.Function){

            @Override
            public FunDef resolve(Exp[] args, IntHolder conversionCount) {
                if (args.length == 1 && args[0].getCategory() == 10) {
                    return null;
                }
                return new ValueFunDef(ExpBase.getCategorys(args));
            }
        });
        this.define(new FunDefBase("_Value", "_Value()", "Returns the value of the current measure.", "fn"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                return new AbstractNumberCalc(call, new Calc[0]){

                    @Override
                    public Number evaluateNumber(Evaluator evaluator) throws CUBAException {
                        return (Number)evaluator.evaluateCurrent();
                    }
                };
            }
        });
        this.define(new MultiFuncResolver("Ancestor", "Ancestor(<Member>, {<Level>|<Numeric Expression>})", "Returns the ancestor of a member at a specified level.", new String[]{"fmml", "fmmn"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                        MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                        Type type1 = call.getArg(1).getType();
                        if (type1 instanceof LevelType) {
                            LevelCalc levelCalc = compiler.compileLevel(call.getArg(1));
                            return new AncestorLevelCalc(call, memberCalc, levelCalc);
                        }
                        IntegerCalc distanceCalc = compiler.compileInteger(call.getArg(1));
                        return new AncestorNCalc(call, memberCalc, distanceCalc);
                    }
                };
            }
        });
        this.define(new FunDefBase("Ascendants", "Ascendants(<Member>)", "Returns the set of the ascendants of a specified member.", "fxm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AscendantsCalc((Exp)call, memberCalc);
            }
        });
        this.define(TopBottomCountFunDef.TopCountResolver);
        this.define(TopBottomCountFunDef.BottomCountResolver);
        this.define(TopBottomPercentSumFunDef.BottomPercentResolver);
        this.define(TopBottomPercentSumFunDef.BottomSumResolver);
        this.define(TopBottomPercentSumFunDef.TopPercentResolver);
        this.define(TopBottomPercentSumFunDef.TopSumResolver);
        this.define(new FunDefBase("Children", "<Member>.Children", "Returns the children of a member.", "pxm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new ChidrenCalc((Exp)call, memberCalc);
            }
        });
        this.define(new MultiFuncResolver("Crossjoin", "Crossjoin(<Set1>, <Set2>)", "Returns the cross product of two sets.", new String[]{"fxxx"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new CrossJoinFunDef(this, returnType, parameterTypes);
            }
        });
        this.define(new MultiFuncResolver("*", "<Set1> * <Set2>", "Returns the cross product of two sets.", new String[]{"ixxx", "ixmx", "ixxm", "ixmm"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                Dimension[] dims = new Dimension[2];
                for (int i = 0; i < 2; ++i) {
                    if (args[i] instanceof MemberExpr) {
                        dims[i] = ((MemberExpr)args[i]).getMember().getDimension();
                        continue;
                    }
                    if (args[i] instanceof FunCall) {
                        FunCall call = (FunCall)args[i];
                        if (!(call.getType() instanceof MemberType)) continue;
                        dims[i] = ((MemberType)call.getType()).getHierarchy().getDimension();
                        continue;
                    }
                    dims[i] = null;
                }
                if (dims[0] == dims[1] && dims[0] != null) {
                    return null;
                }
                return new CrossJoinFunDef(this, returnType, parameterTypes);
            }
        });
        this.define(new DescendantsFunDef.Resolver());
        this.define(new FunDefBase("Distinct", "Distinct(<Set>)", "Eliminates duplicate tuples from a set.", "fxx"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                ListCalc listCalc = compiler.compileList(call.getArg(0));
                return new DistinctCalc((Exp)call, listCalc);
            }
        });
        this.define(new FunDefBase("NonEmpty", "NonEmpty(<Set>)", "Eliminates empty tuples from a set.", "fxx"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                ListCalc listCalc = compiler.compileList(call.getArg(0));
                return new NonEmptyCalc((Exp)call, listCalc);
            }
        });
        this.define(new FunDefBase("NonEmpty", "NonEmpty(<Set1>,<Set2>)", "Returns the set of tuples that are not empty from a specified set, based on the cross product of the specified set with a second set.", "fxxx"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                ListCalc listCalc1 = compiler.compileList(call.getArg(0));
                ListCalc listCalc2 = compiler.compileList(call.getArg(1));
                return new NonEmpty2Calc(call, listCalc1, listCalc2);
            }
        });
        this.define(new MultiFuncResolver("Except", "Except(<Set1>, <Set2>)", "Finds the difference between two sets, optionally retaining duplicates.", new String[]{"fxxx"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                        ListCalc listCalc0 = compiler.compileList(call.getArg(0));
                        ListCalc listCalc1 = compiler.compileList(call.getArg(1));
                        return new ExceptCalc(call, listCalc0, listCalc1);
                    }
                };
            }
        });
        this.define(FilterFunDef.instance);
        this.define(new MultiFuncResolver("Generate", "Generate(<Set1>, <Set2>[, ALL])", "Applies a set to each member of another set and joins the resulting sets by union.", new String[]{"fxxx", "fxxxy"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) throws CUBAException {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                        ListCalc listCalc1 = compiler.compileList(call.getArg(0));
                        ListCalc listCalc2 = compiler.compileList(call.getArg(1));
                        String literalArg = FuncUtil2.getLiteralArg(call.getArgs(), 2, "", new String[]{"ALL"});
                        boolean all = literalArg.equalsIgnoreCase("ALL");
                        return new GenerateCalc(call, listCalc1, listCalc2, all);
                    }
                };
            }
        });
        this.define(new MultiFuncResolver("Generate", "Generate(<Set>, <String Expression>[, <Delimiter>])", "Applies a string expression to each member of set and joins each result as string,with delimiter if assigned.", new String[]{"fSxS", "fSxSS"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                        ListCalc listCalc1 = compiler.compileList(call.getArg(0));
                        StringCalc stringCalc2 = compiler.compileString(call.getArg(1));
                        StringCalc delCalc = compiler.compileString(call.getArg(2));
                        return new GenerateStringCalc(call, listCalc1, stringCalc2, delCalc);
                    }
                };
            }
        });
        this.define(new MultiFuncResolver("Head", "Head(<Set>[, < Numeric Expression >])", "Returns the first specified number of elements in a set.", new String[]{"fxx", "fxxn"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                        ListCalc listCalc = compiler.compileList(call.getArg(0));
                        IntegerCalc intCalc = call.getArgCount() > 0 ? compiler.compileInteger(call.getArg(1)) : null;
                        return new HeadCalc(call, listCalc, intCalc);
                    }
                };
            }
        });
        final String[] prePost = new String[]{"PRE", "POST"};
        this.define(new MultiFuncResolver("Hierarchize", "Hierarchize(<Set>[, POST])", "Orders the members of a set in a hierarchy.", new String[]{"fxx", "fxxy"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) throws CUBAException {
                String order = FuncUtil2.getLiteralArg(args, 1, "PRE", prePost);
                final boolean post = order.equals("POST");
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                        ListCalc listCalc = compiler.compileList(call.getArg(0));
                        return new HierarchizeCalc(call, listCalc, post);
                    }
                };
            }

            @Override
            public String[] getReservedWords() {
                return prePost;
            }
        });
        this.define(new MultiFuncResolver("Intersect", "Intersect(<Set1>, <Set2>[, ALL])", "Returns the intersection of two input sets, optionally retaining duplicates.", new String[]{"fxxxy", "fxxx"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) throws CUBAException {
                boolean all = FuncUtil2.getLiteralArg(args, 2, "", new String[]{"ALL"}).equalsIgnoreCase("ALL");
                return new IntersectFunDef(this, returnType, parameterTypes, all);
            }
        });
        this.define(new FunDefBase("Members", "<Dimension>.Members", "Returns the set of all members in a dimension.", "pxd"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                DimensionCalc dimensionCalc = compiler.compileDimension(call.getArg(0));
                return new DimensionMembersCalc((Exp)call, dimensionCalc);
            }
        });
        this.define(new FunDefBase("Members", "<Level>.Members", "Returns the set of all members in a level.", "pxl"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                LevelCalc calc = compiler.compileLevel(call.getArg(0));
                return new LevelMembersCalc((Exp)call, calc);
            }
        });
        this.define(new FunDefBase("Members", "<Hierarchy>.Members", "Returns the set of all members in a hierarchy.", "pxh"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                HierarchyCalc calc = compiler.compileHierarchy(call.getArg(0));
                return new HierarchyMembersCalc((Exp)call, calc);
            }
        });
        this.define(new FunDefBase("MembersAboveLevel", "<Hierarchy>.MembersAboveLevel(<Numeric Expression>)", "Returns the set of all members above level based on level ordinal in a hierarchy.", "mxhn"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                HierarchyCalc calc = compiler.compileHierarchy(call.getArg(0));
                IntegerCalc calc2 = compiler.compileInteger(call.getArg(1));
                return new HierarchyMembersAboveLevelCalc(call, calc, calc2);
            }
        });
        this.define(new FunDefBase("FirstMember", "<Level>.FirstMember", "Returns the first member in a level.", "pml"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                LevelCalc calc = compiler.compileLevel(call.getArg(0));
                return new LevelFirstMemberCalc((Exp)call, calc);
            }
        });
        this.define(new FunDefBase("LastMember", "<Level>.LastMember", "Returns the last member in a level.", "pml"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                LevelCalc calc = compiler.compileLevel(call.getArg(0));
                return new LevelLastMemberCalc((Exp)call, calc);
            }
        });
        this.define(new OrderFunDef.OrderFuncResolver());
        this.define(new XtdFunDef.Resolver("Mtd", "Mtd([<Member>])", "A shortcut function for the PeriodsToDate function that specifies the level to be Month.", new String[]{"fx", "fxm"}, 4));
        this.define(new XtdFunDef.Resolver("Qtd", "Qtd([<Member>])", "A shortcut function for the PeriodsToDate function that specifies the level to be Quarter.", new String[]{"fx", "fxm"}, 3));
        this.define(new XtdFunDef.Resolver("Wtd", "Wtd([<Member>])", "A shortcut function for the PeriodsToDate function that specifies the level to be Week.", new String[]{"fx", "fxm"}, 5));
        this.define(new XtdFunDef.Resolver("Ytd", "Ytd([<Member>])", "A shortcut function for the PeriodsToDate function that specifies the level to be Year.", new String[]{"fx", "fxm"}, 2));
        this.define(new MultiFuncResolver("PeriodsToDate", "PeriodsToDate([<Level>[, <Member>]])", "Returns a set of periods (members) from a specified level starting with the first period and ending with a specified member.", new String[]{"fx", "fxl", "fxlm"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Type getResultType(ExpResolver resolver, Exp[] args) throws CUBAException {
                        if (args.length == 0) {
                            Dimension timeDimension = resolver.getQuery().getCube().getTimeDimension();
                            if (timeDimension == null) {
                                throw new CUBAException("PeriodsToDate with no arguments must apply to Time Dimension,but the cube has no Time Dimension.");
                            }
                            Hierarchy hierarchy = timeDimension.getHierarchy();
                            return new SetType(new MemberType(hierarchy, null, null));
                        }
                        return super.getResultType(resolver, args);
                    }

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                        LevelCalc levelCalc = call.getArgCount() > 0 ? compiler.compileLevel(call.getArg(0)) : null;
                        MemberCalc memberCalc = call.getArgCount() > 1 ? compiler.compileMember(call.getArg(1)) : null;
                        Dimension timeDimension = compiler.getResolver().getQuery().getCube().getTimeDimension();
                        return new PeriodsToDateCalc(call, levelCalc, memberCalc, timeDimension);
                    }
                };
            }
        });
        this.define(new FunDefBase("Siblings", "<Member>.Siblings", "Returns the set of siblings of the specified member.", "pxm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                MemberCalc calc = compiler.compileMember(call.getArg(0));
                return new SiblingsCalc((Exp)call, calc);
            }
        });
        this.define(new MultiFuncResolver("Subset", "Subset(<Set>, <Start>[, <Count>])", "Returns a subset of elements from a set.", new String[]{"fxxn", "fxxnn"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                        ListCalc listCalc = compiler.compileList(call.getArg(0));
                        IntegerCalc startCalc = compiler.compileInteger(call.getArg(1));
                        IntegerCalc countCalc = call.getArgCount() > 2 ? compiler.compileInteger(call.getArg(2)) : null;
                        return new SubsetCalc(call, listCalc, startCalc, countCalc);
                    }
                };
            }
        });
        this.define(new MultiFuncResolver("-", "<Set1> - <Set2>", "Subtracts two set.", new String[]{"ixxx", "ixxm"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnCategory, int[] argCategorys) {
                return new FunDefBase(this, returnCategory, argCategorys){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                        ListCalc listCalc0 = compiler.compileList(call.getArg(0));
                        ListCalc listCalc1 = compiler.compileList(call.getArg(1));
                        return new ExceptCalc(call, listCalc0, listCalc1);
                    }
                };
            }
        });
        this.define(new MultiFuncResolver("Tail", "Tail(<Set>[, <Count>])", "Returns a subset from the end of a set.", new String[]{"fxx", "fxxn"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                        ListCalc listCalc = compiler.compileList(call.getArg(0));
                        IntegerCalc intCalc = call.getArgCount() > 0 ? compiler.compileInteger(call.getArg(1)) : null;
                        return new TailCalc(call, listCalc, intCalc);
                    }
                };
            }
        });
        final String[] allDistinct = new String[]{"ALL", "DISTINCT"};
        this.define(new MultiFuncResolver("Union", "Union(<Set1>, <Set2>[, ALL])", "Returns the union of two sets, optionally retaining duplicates.", new String[]{"fxxx", "fxxxy"}){

            @Override
            public String[] getReservedWords() {
                return allDistinct;
            }

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) throws CUBAException {
                String allString = FuncUtil2.getLiteralArg(args, 2, "DISTINCT", allDistinct);
                final boolean all = allString.equalsIgnoreCase("ALL");
                FuncUtil2.checkCompatible(args[0], args[1], this.getName());
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                        ListCalc listCalc0 = compiler.compileList(call.getArg(0));
                        ListCalc listCalc1 = compiler.compileList(call.getArg(1));
                        return new UnionCalc(call, listCalc0, listCalc1, all);
                    }
                };
            }
        });
        this.define(new FunDefBase(":", "<Member>:<Member>", "Infix colon operator returns the set of members between a given pair of members.", "ixmm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                MemberCalc memberCalc0 = compiler.compileMember(call.getArg(0));
                MemberCalc memberCalc1 = compiler.compileMember(call.getArg(1));
                return new MemberRangeCalc(call, memberCalc0, memberCalc1);
            }
        });
        this.define(new FuncResolverBase("{}", "{<Member> [, <Member>]...}", "Brace operator constructs a set.", Syntax.Braces){

            @Override
            public FunDef resolve(Exp[] args, IntHolder conversionCount) {
                int[] parameterTypes = new int[args.length];
                for (int i = 0; i < args.length; ++i) {
                    if (TypeConvertUtil.canConvert(args[i], 6, conversionCount)) {
                        parameterTypes[i] = 6;
                        continue;
                    }
                    if (TypeConvertUtil.canConvert(args[i], 8, conversionCount)) {
                        parameterTypes[i] = 8;
                        continue;
                    }
                    if (TypeConvertUtil.canConvert(args[i], 10, conversionCount)) {
                        parameterTypes[i] = 10;
                        continue;
                    }
                    return null;
                }
                return new SetFunDef(this, parameterTypes);
            }
        });
        this.define(new MultiFuncResolver("Format", "Format(<Numeric Expression>, <String Expression>)", "Formats a number to string.", new String[]{"fSmS", "fSnS"}){

            @Override
            protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
                if (args[1] instanceof Literal) {
                    return new FunDefBase(this, returnType, parameterTypes){

                        @Override
                        public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                            Exp[] args = call.getArgs();
                            final Calc calc = compiler.compileScalar(call.getArg(0), true);
                            String formatString = ((Literal)args[1]).stringValue();
                            final Formatter format = new Formatter(formatString);
                            return new AbstractStringCalc(call, new Calc[]{calc}){

                                @Override
                                public String evaluateString(Evaluator evaluator) throws CUBAException {
                                    Object o = calc.evaluate(evaluator);
                                    return format.format(o);
                                }
                            };
                        }
                    };
                }
                return new FunDefBase(this, returnType, parameterTypes){

                    @Override
                    public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                        final Calc calc = compiler.compileScalar(call.getArg(0), true);
                        final StringCalc stringCalc = compiler.compileString(call.getArg(1));
                        return new AbstractStringCalc(call, new Calc[]{calc, stringCalc}){

                            @Override
                            public String evaluateString(Evaluator evaluator) throws CUBAException {
                                Object o = calc.evaluate(evaluator);
                                String formatString = stringCalc.evaluateString(evaluator);
                                Formatter format = new Formatter(formatString);
                                return format.format(o);
                            }
                        };
                    }
                };
            }
        });
        this.define(new FunDefBase("Caption", "<Dimension>.Caption", "Returns the caption of a dimension.", "pSd"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final DimensionCalc calc = compiler.compileDimension(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{calc}){

                    @Override
                    public String evaluateString(Evaluator evaluator) throws CUBAException {
                        Dimension dimension = calc.evaluateDimension(evaluator);
                        return dimension.getCaption();
                    }
                };
            }
        });
        this.define(new FunDefBase("Caption", "<Hierarchy>.Caption", "Returns the caption of a hierarchy.", "pSh"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final HierarchyCalc calc = compiler.compileHierarchy(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{calc}){

                    @Override
                    public String evaluateString(Evaluator evaluator) throws CUBAException {
                        Hierarchy hierarchy = calc.evaluateHierarchy(evaluator);
                        return hierarchy.getCaption();
                    }
                };
            }
        });
        this.define(new FunDefBase("Caption", "<Level>.Caption", "Returns the caption of a level.", "pSl"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final LevelCalc calc = compiler.compileLevel(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{calc}){

                    @Override
                    public String evaluateString(Evaluator evaluator) throws CUBAException {
                        Level level = calc.evaluateLevel(evaluator);
                        return level.getCaption();
                    }
                };
            }
        });
        this.define(new FunDefBase("Caption", "<Member>.Caption", "Returns the caption of a member.", "pSm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final MemberCalc calc = compiler.compileMember(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{calc}){

                    @Override
                    public String evaluateString(Evaluator evaluator) throws CUBAException {
                        Member member = calc.evaluateMember(evaluator);
                        return member.getCaption();
                    }
                };
            }
        });
        this.define(new FunDefBase("Name", "<Dimension>.Name", "Returns the name of a dimension.", "pSd"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final DimensionCalc calc = compiler.compileDimension(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{calc}){

                    @Override
                    public String evaluateString(Evaluator evaluator) throws CUBAException {
                        Dimension dimension = calc.evaluateDimension(evaluator);
                        return dimension.getName();
                    }
                };
            }
        });
        this.define(new FunDefBase("Name", "<Hierarchy>.Name", "Returns the name of a hierarchy.", "pSh"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final HierarchyCalc calc = compiler.compileHierarchy(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{calc}){

                    @Override
                    public String evaluateString(Evaluator evaluator) throws CUBAException {
                        Hierarchy hierarchy = calc.evaluateHierarchy(evaluator);
                        return hierarchy.getName();
                    }
                };
            }
        });
        this.define(new FunDefBase("Name", "<Level>.Name", "Returns the name of a level.", "pSl"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final LevelCalc calc = compiler.compileLevel(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{calc}){

                    @Override
                    public String evaluateString(Evaluator evaluator) throws CUBAException {
                        Level level = calc.evaluateLevel(evaluator);
                        return level.getName();
                    }
                };
            }
        });
        this.define(new FunDefBase("Name", "<Member>.Name", "Returns the name of a member.", "pSm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final MemberCalc calc = compiler.compileMember(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{calc}){

                    @Override
                    public String evaluateString(Evaluator evaluator) throws CUBAException {
                        Member member = calc.evaluateMember(evaluator);
                        return member.getName();
                    }
                };
            }
        });
        this.define(new FunDefBase("Key", "<Member>.Key", "Returns the key of a member.", "pSm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final MemberCalc calc = compiler.compileMember(call.getArg(0));
                return new GenericCalc(call){

                    @Override
                    public Object evaluate(Evaluator evaluator) throws CUBAException {
                        Member member = calc.evaluateMember(evaluator);
                        return member.getKey();
                    }

                    @Override
                    public Calc[] getCalcs() {
                        return new Calc[]{calc};
                    }
                };
            }
        });
        this.define(new FunDefBase("UniqueName", "<Dimension>.UniqueName", "Returns the unique name of a dimension.", "pSd"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final DimensionCalc calc = compiler.compileDimension(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{calc}){

                    @Override
                    public String evaluateString(Evaluator evaluator) throws CUBAException {
                        Dimension dimension = calc.evaluateDimension(evaluator);
                        return dimension.getUniqueName();
                    }
                };
            }
        });
        this.define(new FunDefBase("UniqueName", "<Hierarchy>.UniqueName", "Returns the unique name of a hierarchy.", "pSh"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final HierarchyCalc calc = compiler.compileHierarchy(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{calc}){

                    @Override
                    public String evaluateString(Evaluator evaluator) throws CUBAException {
                        Hierarchy hierarchy = calc.evaluateHierarchy(evaluator);
                        return hierarchy.getUniqueName();
                    }
                };
            }
        });
        this.define(new FunDefBase("UniqueName", "<Level>.UniqueName", "Returns the unique name of a level.", "pSl"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final LevelCalc calc = compiler.compileLevel(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{calc}){

                    @Override
                    public String evaluateString(Evaluator evaluator) throws CUBAException {
                        Level level = calc.evaluateLevel(evaluator);
                        return level.getUniqueName();
                    }
                };
            }
        });
        this.define(new FunDefBase("UniqueName", "<Member>.UniqueName", "Returns the unique name of a member.", "pSm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final MemberCalc calc = compiler.compileMember(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{calc}){

                    @Override
                    public String evaluateString(Evaluator evaluator) throws CUBAException {
                        Member member = calc.evaluateMember(evaluator);
                        return member.getUniqueName();
                    }
                };
            }
        });
        this.define(SetItemFunDef.instance);
        this.define(TupleItemFunDef.instance);
        this.define(new FuncResolverBase("()", null, null, Syntax.Parentheses){

            @Override
            public FunDef resolve(Exp[] args, IntHolder conversionCount) {
                if (args.length == 1) {
                    return new ParenthesesFunDef(args[0].getCategory());
                }
                return new TupleFunDef(ExpBase.getCategorys(args));
            }
        });
        this.define(new FuncResolverBase("CoalesceEmpty", "CoalesceEmpty(<Value Expression>[, <Value Expression>]...)", "Coalesces an empty cell value to a different value. All of the expressions must be of the same type (number or string).", Syntax.Function){

            @Override
            public FunDef resolve(Exp[] args, IntHolder conversionCount) {
                if (args.length < 1) {
                    return null;
                }
                int[] types = new int[]{7, 9};
                for (int j = 0; j < types.length; ++j) {
                    int type = types[j];
                    int matchingArgs = 0;
                    conversionCount.value = 0;
                    for (int i = 0; i < args.length; ++i) {
                        if (!TypeConvertUtil.canConvert(args[i], type, conversionCount)) continue;
                        ++matchingArgs;
                    }
                    if (matchingArgs != args.length) continue;
                    return new CoalesceEmptyFunDef(this, type, ExpBase.getCategorys(args));
                }
                return null;
            }

            @Override
            public boolean requireScalarExpression(int k) {
                return true;
            }
        });
        this.define(new FuncResolverBase("_CaseTest", "Case When <Logical Expression> Then <Expression> [Else <Expression>] End", "Evaluates various conditions, and returns the corresponding expression for the first which evaluates to true.", Syntax.Case){

            @Override
            public FunDef resolve(Exp[] args, IntHolder conversionCount) {
                if (args.length < 1) {
                    return null;
                }
                int j = 0;
                int clauseCount = args.length / 2;
                int mismatchingArgs = 0;
                int returnType = args[1].getCategory();
                for (int i = 0; i < clauseCount; ++i) {
                    if (!TypeConvertUtil.canConvert(args[j++], 5, conversionCount)) {
                        ++mismatchingArgs;
                    }
                    if (TypeConvertUtil.canConvert(args[j++], returnType, conversionCount)) continue;
                    ++mismatchingArgs;
                }
                if (j < args.length && !TypeConvertUtil.canConvert(args[j++], returnType, conversionCount)) {
                    ++mismatchingArgs;
                }
                Util.assertTrue(j == args.length);
                if (mismatchingArgs == 0) {
                    return new FunDefBase(this, returnType, ExpBase.getCategorys(args)){

                        @Override
                        public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                            Exp[] args = call.getArgs();
                            final BooleanCalc[] conditionCalcs = new BooleanCalc[args.length / 2];
                            final Calc[] exprCalcs = new Calc[args.length / 2];
                            LinkedList<Calc> calcList = new LinkedList<Calc>();
                            int j = 0;
                            for (int i = 0; i < exprCalcs.length; ++i) {
                                conditionCalcs[i] = compiler.compileBoolean(args[j++]);
                                calcList.add(conditionCalcs[i]);
                                exprCalcs[i] = compiler.compile(args[j++]);
                                calcList.add(exprCalcs[i]);
                            }
                            final ConstantCalc defaultCalc = args.length % 2 == 1 ? compiler.compile(args[args.length - 1]) : ConstantCalc.constantNull(call.getType());
                            calcList.add(defaultCalc);
                            final Calc[] calcs = calcList.toArray(new Calc[calcList.size()]);
                            return new AbstractCalc(call){

                                @Override
                                public Object evaluate(Evaluator evaluator) throws CUBAException {
                                    for (int i = 0; i < conditionCalcs.length; ++i) {
                                        if (!conditionCalcs[i].evaluateBoolean(evaluator)) continue;
                                        return exprCalcs[i].evaluate(evaluator);
                                    }
                                    return defaultCalc.evaluate(evaluator);
                                }

                                @Override
                                public Calc[] getCalcs() {
                                    return calcs;
                                }
                            };
                        }
                    };
                }
                return null;
            }

            @Override
            public boolean requireScalarExpression(int k) {
                return true;
            }
        });
        this.define(new FuncResolverBase("_CaseMatch", "Case <Expression> When <Expression> Then <Expression> [...] [Else <Expression>] End", "Evaluates various expressions, and returns the corresponding expression for the first which matches a particular value.", Syntax.Case){

            @Override
            public FunDef resolve(Exp[] args, IntHolder conversionCount) {
                if (args.length < 3) {
                    return null;
                }
                int valueType = args[0].getCategory();
                int returnType = args[2].getCategory();
                int j = 0;
                int clauseCount = (args.length - 1) / 2;
                int mismatchingArgs = 0;
                if (!TypeConvertUtil.canConvert(args[j++], valueType, conversionCount)) {
                    ++mismatchingArgs;
                }
                for (int i = 0; i < clauseCount; ++i) {
                    if (!TypeConvertUtil.canConvert(args[j++], valueType, conversionCount)) {
                        ++mismatchingArgs;
                    }
                    if (TypeConvertUtil.canConvert(args[j++], returnType, conversionCount)) continue;
                    ++mismatchingArgs;
                }
                if (j < args.length && !TypeConvertUtil.canConvert(args[j++], returnType, conversionCount)) {
                    ++mismatchingArgs;
                }
                if (mismatchingArgs == 0) {
                    return new FunDefBase(this, returnType, ExpBase.getCategorys(args)){

                        @Override
                        public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                            Exp[] args = call.getArgs();
                            LinkedList<Calc> calcList = new LinkedList<Calc>();
                            final Calc valueCalc = compiler.compile(args[0]);
                            calcList.add(valueCalc);
                            int matchCount = (args.length - 1) / 2;
                            final Calc[] matchCalcs = new Calc[matchCount];
                            final Calc[] exprCalcs = new Calc[matchCount];
                            int j = 1;
                            for (int i = 0; i < exprCalcs.length; ++i) {
                                matchCalcs[i] = compiler.compile(args[j++]);
                                calcList.add(matchCalcs[i]);
                                exprCalcs[i] = call.getType() instanceof NumericType ? compiler.compileBigDecimal(args[j++]) : compiler.compile(args[j++]);
                                calcList.add(exprCalcs[i]);
                            }
                            Calc lastCalc = null;
                            lastCalc = args.length % 2 == 0 ? (call.getType() instanceof NumericType ? compiler.compileBigDecimal(args[args.length - 1]) : compiler.compile(args[args.length - 1])) : ConstantCalc.constantNull(call.getType());
                            final ConstantCalc defaultCalc = lastCalc;
                            calcList.add(defaultCalc);
                            final Calc[] calcs = calcList.toArray(new Calc[calcList.size()]);
                            return new AbstractCalc(call){

                                @Override
                                public Object evaluate(Evaluator evaluator) throws CUBAException {
                                    Object value = valueCalc.evaluate(evaluator);
                                    for (int i = 0; i < matchCalcs.length; ++i) {
                                        Object match = matchCalcs[i].evaluate(evaluator);
                                        if (!Util.equals(match, value)) continue;
                                        return exprCalcs[i].evaluate(evaluator);
                                    }
                                    return defaultCalc.evaluate(evaluator);
                                }

                                @Override
                                public Calc[] getCalcs() {
                                    return calcs;
                                }
                            };
                        }
                    };
                }
                return null;
            }

            @Override
            public boolean requireScalarExpression(int k) {
                return true;
            }
        });
        this.define(new PropertiesFunDef.Resolver());
        this.define(new FunDefBase("+", "<Numeric Expression> + <Numeric Expression>", "Adds two numbers.", "innn"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final BigDecimalCalc calc0 = compiler.compileBigDecimal(call.getArg(0));
                final BigDecimalCalc calc1 = compiler.compileBigDecimal(call.getArg(1));
                return new AbstractBigDecimalCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public BigDecimal evaluateBigDecimal(Evaluator evaluator) throws CUBAException {
                        BigDecimal o0 = calc0.evaluateBigDecimal(evaluator);
                        BigDecimal o1 = calc1.evaluateBigDecimal(evaluator);
                        if (o0 == null && o1 == null) {
                            return null;
                        }
                        if (o0 == null) {
                            return o1;
                        }
                        if (o1 == null) {
                            return o0;
                        }
                        return o0.add(o1);
                    }
                };
            }
        });
        this.define(new FunDefBase("-", "<Numeric Expression> - <Numeric Expression>", "Subtracts two numbers.", "innn"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final BigDecimalCalc calc0 = compiler.compileBigDecimal(call.getArg(0));
                final BigDecimalCalc calc1 = compiler.compileBigDecimal(call.getArg(1));
                return new AbstractBigDecimalCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public BigDecimal evaluateBigDecimal(Evaluator evaluator) throws CUBAException {
                        BigDecimal o0 = calc0.evaluateBigDecimal(evaluator);
                        BigDecimal o1 = calc1.evaluateBigDecimal(evaluator);
                        if (o0 == null && o1 == null) {
                            return null;
                        }
                        if (o0 == null) {
                            return o1.multiply(Util.negOneDecimal);
                        }
                        if (o1 == null) {
                            return o0;
                        }
                        return o0.subtract(o1);
                    }
                };
            }
        });
        this.define(new FunDefBase("*", "<Numeric Expression> * <Numeric Expression>", "Multiplies two numbers.", "innn"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final BigDecimalCalc calc0 = compiler.compileBigDecimal(call.getArg(0));
                final BigDecimalCalc calc1 = compiler.compileBigDecimal(call.getArg(1));
                return new AbstractBigDecimalCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public BigDecimal evaluateBigDecimal(Evaluator evaluator) throws CUBAException {
                        BigDecimal o0 = calc0.evaluateBigDecimal(evaluator);
                        BigDecimal o1 = calc1.evaluateBigDecimal(evaluator);
                        if (o0 == null || o1 == null) {
                            return null;
                        }
                        return o0.multiply(o1);
                    }
                };
            }
        });
        this.define(new FunDefBase("/", "<Numeric Expression> / <Numeric Expression>", "Divides two numbers.", "innn"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final BigDecimalCalc calc0 = compiler.compileBigDecimal(call.getArg(0));
                final BigDecimalCalc calc1 = compiler.compileBigDecimal(call.getArg(1));
                return new AbstractBigDecimalCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public BigDecimal evaluateBigDecimal(Evaluator evaluator) throws CUBAException {
                        BigDecimal o0 = calc0.evaluateBigDecimal(evaluator);
                        BigDecimal o1 = calc1.evaluateBigDecimal(evaluator);
                        if (o0 == (BigDecimal)ValueNotReady.instance || o1 == (BigDecimal)ValueNotReady.instance) {
                            return (BigDecimal)ValueNotReady.instance;
                        }
                        if (o0 == null || o1 == null || Util.zeroDecimal.compareTo(o1) == 0) {
                            return null;
                        }
                        return o0.divide(o1, 10, 4);
                    }
                };
            }
        });
        this.define(new FunDefBase("-", "- <Numeric Expression>", "Returns the negative of a number.", "Pnn"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final BigDecimalCalc calc0 = compiler.compileBigDecimal(call.getArg(0));
                return new AbstractBigDecimalCalc(call, new Calc[]{calc0}){

                    @Override
                    public BigDecimal evaluateBigDecimal(Evaluator evaluator) throws CUBAException {
                        BigDecimal o0 = calc0.evaluateBigDecimal(evaluator);
                        if (o0 == null) {
                            return null;
                        }
                        return o0.multiply(Util.negOneDecimal);
                    }
                };
            }
        });
        this.define(new FunDefBase("||", "<String Expression> || <String Expression>", "Concatenates two strings.", "iSSS"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final StringCalc calc0 = compiler.compileString(call.getArg(0));
                final StringCalc calc1 = compiler.compileString(call.getArg(1));
                return new AbstractStringCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public String evaluateString(Evaluator evaluator) throws CUBAException {
                        String o0 = calc0.evaluateString(evaluator);
                        String o1 = calc1.evaluateString(evaluator);
                        if (o0 == null && o1 == null) {
                            return null;
                        }
                        return (o0 == null ? "" : o0) + (o1 == null ? "" : o1);
                    }
                };
            }
        });
        this.define(new FunDefBase("+", "<String Expression> + <String Expression>", "Concatenates two strings.", "iSSS"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final StringCalc calc0 = compiler.compileString(call.getArg(0));
                final StringCalc calc1 = compiler.compileString(call.getArg(1));
                return new AbstractStringCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public String evaluateString(Evaluator evaluator) throws CUBAException {
                        String o0 = calc0.evaluateString(evaluator);
                        String o1 = calc1.evaluateString(evaluator);
                        if (o0 == null && o1 == null) {
                            return null;
                        }
                        return (o0 == null ? "" : o0) + (o1 == null ? "" : o1);
                    }
                };
            }
        });
        this.define(new FunDefBase("AND", "<Logical Expression> AND <Logical Expression>", "Returns the conjunction of two conditions.", "ibbb"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final BooleanCalc calc0 = compiler.compileBoolean(call.getArg(0));
                final BooleanCalc calc1 = compiler.compileBoolean(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws CUBAException {
                        boolean o0 = calc0.evaluateBoolean(evaluator);
                        boolean o1 = calc1.evaluateBoolean(evaluator);
                        return o0 && o1;
                    }
                };
            }
        });
        this.define(new FunDefBase("OR", "<Logical Expression> OR <Logical Expression>", "Returns the disjunction of two conditions.", "ibbb"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final BooleanCalc calc0 = compiler.compileBoolean(call.getArg(0));
                final BooleanCalc calc1 = compiler.compileBoolean(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws CUBAException {
                        boolean o0 = calc0.evaluateBoolean(evaluator);
                        boolean o1 = calc1.evaluateBoolean(evaluator);
                        return o0 || o1;
                    }
                };
            }
        });
        this.define(new FunDefBase("XOR", "<Logical Expression> XOR <Logical Expression>", "Returns whether two conditions are mutually exclusive.", "ibbb"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final BooleanCalc calc0 = compiler.compileBoolean(call.getArg(0));
                final BooleanCalc calc1 = compiler.compileBoolean(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws CUBAException {
                        boolean o1;
                        boolean o0 = calc0.evaluateBoolean(evaluator);
                        return o0 != (o1 = calc1.evaluateBoolean(evaluator));
                    }
                };
            }
        });
        this.define(new FunDefBase("NOT", "NOT <Logical Expression>", "Returns the negation of a condition.", "Pbb"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final BooleanCalc calc0 = compiler.compileBoolean(call.getArg(0));
                return new AbstractBooleanCalc(call, new Calc[]{calc0}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws CUBAException {
                        boolean o0 = calc0.evaluateBoolean(evaluator);
                        return !o0;
                    }
                };
            }
        });
        this.define(new FunDefBase("=", "<String Expression> = <String Expression>", "Returns whether two expressions are equal.", "ibSS"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final StringCalc calc0 = compiler.compileString(call.getArg(0));
                final StringCalc calc1 = compiler.compileString(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws CUBAException {
                        String o0 = calc0.evaluateString(evaluator);
                        String o1 = calc1.evaluateString(evaluator);
                        if (o0 == null && o1 == null) {
                            return true;
                        }
                        if (o0 == null) {
                            return false;
                        }
                        if (o1 == null) {
                            return false;
                        }
                        return o0.equals(o1);
                    }
                };
            }
        });
        this.define(new FunDefBase("=", "<Numeric Expression> = <Numeric Expression>", "Returns whether two expressions are equal.", "ibnn"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final BigDecimalCalc calc0 = compiler.compileBigDecimal(call.getArg(0));
                final BigDecimalCalc calc1 = compiler.compileBigDecimal(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws CUBAException {
                        BigDecimal o0 = calc0.evaluateBigDecimal(evaluator);
                        BigDecimal o1 = calc1.evaluateBigDecimal(evaluator);
                        if (o0 == null && o1 == null) {
                            return true;
                        }
                        if (o0 == null || o1 == null) {
                            return false;
                        }
                        return o0.compareTo(o1) == 0;
                    }
                };
            }
        });
        this.define(new FunDefBase("=", "<Member> = <Member>", "Returns whether two members are equal.", "ibmm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final MemberCalc calc0 = compiler.compileMember(call.getArg(0));
                final MemberCalc calc1 = compiler.compileMember(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws CUBAException {
                        Member o0 = calc0.evaluateMember(evaluator);
                        Member o1 = calc1.evaluateMember(evaluator);
                        if (o0 == null && o1 == null) {
                            return true;
                        }
                        if (o0 == null && o1.isNull()) {
                            return true;
                        }
                        if (o1 == null && o0.isNull()) {
                            return true;
                        }
                        return o0.equals(o1);
                    }
                };
            }
        });
        this.define(new FunDefBase("<>", "<String Expression> <> <String Expression>", "Returns whether two expressions are not equal.", "ibSS"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final StringCalc calc0 = compiler.compileString(call.getArg(0));
                final StringCalc calc1 = compiler.compileString(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws CUBAException {
                        String o0 = calc0.evaluateString(evaluator);
                        String o1 = calc1.evaluateString(evaluator);
                        if (o0 == null && o1 == null) {
                            return false;
                        }
                        if (o0 == null) {
                            return true;
                        }
                        if (o1 == null) {
                            return true;
                        }
                        return !o0.equals(o1);
                    }
                };
            }
        });
        this.define(new FunDefBase("<>", "<Numeric Expression> <> <Numeric Expression>", "Returns whether two expressions are not equal.", "ibnn"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final BigDecimalCalc calc0 = compiler.compileBigDecimal(call.getArg(0));
                final BigDecimalCalc calc1 = compiler.compileBigDecimal(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws CUBAException {
                        BigDecimal o0 = calc0.evaluateBigDecimal(evaluator);
                        BigDecimal o1 = calc1.evaluateBigDecimal(evaluator);
                        if (o0 == null && o1 == null) {
                            return false;
                        }
                        if (o0 == null || o1 == null) {
                            return true;
                        }
                        return o0.compareTo(o1) != 0;
                    }
                };
            }
        });
        this.define(new FunDefBase("<>", "<Member> <> <Member>", "Returns whether two members are not equal.", "ibmm"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final MemberCalc calc0 = compiler.compileMember(call.getArg(0));
                final MemberCalc calc1 = compiler.compileMember(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws CUBAException {
                        Member o0 = calc0.evaluateMember(evaluator);
                        Member o1 = calc1.evaluateMember(evaluator);
                        if (o0 == null && o1 == null) {
                            return false;
                        }
                        if (o0 == null && o1.isNull()) {
                            return false;
                        }
                        if (o1 == null && o0.isNull()) {
                            return false;
                        }
                        return !o0.equals(o1);
                    }
                };
            }
        });
        this.define(new FunDefBase("<", "<Numeric Expression> < <Numeric Expression>", "Returns whether an expression is less than another.", "ibnn"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final BigDecimalCalc calc0 = compiler.compileBigDecimal(call.getArg(0));
                final BigDecimalCalc calc1 = compiler.compileBigDecimal(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws CUBAException {
                        BigDecimal o0 = calc0.evaluateBigDecimal(evaluator);
                        BigDecimal o1 = calc1.evaluateBigDecimal(evaluator);
                        if (o0 == null && o1 == null) {
                            return false;
                        }
                        if (o0 == null) {
                            return true;
                        }
                        if (o1 == null) {
                            return false;
                        }
                        return o0.compareTo(o1) < 0;
                    }
                };
            }
        });
        this.define(new FunDefBase("<", "<String Expression> < <String Expression>", "Returns whether an expression is less than another.", "ibSS"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final StringCalc calc0 = compiler.compileString(call.getArg(0));
                final StringCalc calc1 = compiler.compileString(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws CUBAException {
                        String o0 = calc0.evaluateString(evaluator);
                        String o1 = calc1.evaluateString(evaluator);
                        if (o0 == null && o1 == null) {
                            return false;
                        }
                        if (o0 == null) {
                            return true;
                        }
                        if (o1 == null) {
                            return false;
                        }
                        return o0.compareTo(o1) < 0;
                    }
                };
            }
        });
        this.define(new FunDefBase("<=", "<Numeric Expression> <= <Numeric Expression>", "Returns whether an expression is less than or equal to another.", "ibnn"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final BigDecimalCalc calc0 = compiler.compileBigDecimal(call.getArg(0));
                final BigDecimalCalc calc1 = compiler.compileBigDecimal(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws CUBAException {
                        BigDecimal o0 = calc0.evaluateBigDecimal(evaluator);
                        BigDecimal o1 = calc1.evaluateBigDecimal(evaluator);
                        if (o0 == null && o1 == null) {
                            return true;
                        }
                        if (o0 == null) {
                            return true;
                        }
                        if (o1 == null) {
                            return false;
                        }
                        return o0.compareTo(o1) <= 0;
                    }
                };
            }
        });
        this.define(new FunDefBase("<=", "<String Expression> <= <String Expression>", "Returns whether an expression is less than or equal to another.", "ibSS"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final StringCalc calc0 = compiler.compileString(call.getArg(0));
                final StringCalc calc1 = compiler.compileString(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws CUBAException {
                        String o0 = calc0.evaluateString(evaluator);
                        String o1 = calc1.evaluateString(evaluator);
                        if (o0 == null && o1 == null) {
                            return true;
                        }
                        if (o0 == null) {
                            return true;
                        }
                        if (o1 == null) {
                            return false;
                        }
                        return o0.compareTo(o1) <= 0;
                    }
                };
            }
        });
        this.define(new FunDefBase(">", "<Numeric Expression> > <Numeric Expression>", "Returns whether an expression is greater than another.", "ibnn"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final BigDecimalCalc calc0 = compiler.compileBigDecimal(call.getArg(0));
                final BigDecimalCalc calc1 = compiler.compileBigDecimal(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws CUBAException {
                        BigDecimal o0 = calc0.evaluateBigDecimal(evaluator);
                        BigDecimal o1 = calc1.evaluateBigDecimal(evaluator);
                        if (o0 == null && o1 == null) {
                            return false;
                        }
                        if (o0 == null) {
                            return false;
                        }
                        if (o1 == null) {
                            return true;
                        }
                        return o0.compareTo(o1) > 0;
                    }
                };
            }
        });
        this.define(new FunDefBase(">", "<String Expression> > <String Expression>", "Returns whether an expression is greater than another.", "ibSS"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final StringCalc calc0 = compiler.compileString(call.getArg(0));
                final StringCalc calc1 = compiler.compileString(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws CUBAException {
                        String o0 = calc0.evaluateString(evaluator);
                        String o1 = calc1.evaluateString(evaluator);
                        if (o0 == null && o1 == null) {
                            return true;
                        }
                        if (o0 == null) {
                            return false;
                        }
                        if (o1 == null) {
                            return true;
                        }
                        return o0.compareTo(o1) > 0;
                    }
                };
            }
        });
        this.define(new FunDefBase(">=", "<Numeric Expression> >= <Numeric Expression>", "Returns whether an expression is greater than or equal to another.", "ibnn"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final BigDecimalCalc calc0 = compiler.compileBigDecimal(call.getArg(0));
                final BigDecimalCalc calc1 = compiler.compileBigDecimal(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws CUBAException {
                        BigDecimal o0 = calc0.evaluateBigDecimal(evaluator);
                        BigDecimal o1 = calc1.evaluateBigDecimal(evaluator);
                        if (o0 == null && o1 == null) {
                            return true;
                        }
                        if (o0 == null) {
                            return false;
                        }
                        if (o1 == null) {
                            return true;
                        }
                        return o0.compareTo(o1) >= 0;
                    }
                };
            }
        });
        this.define(new FunDefBase(">=", "<String Expression> >= <String Expression>", "Returns whether an expression is greater than or equal to another.", "ibSS"){

            @Override
            public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
                final StringCalc calc0 = compiler.compileString(call.getArg(0));
                final StringCalc calc1 = compiler.compileString(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) throws CUBAException {
                        String o0 = calc0.evaluateString(evaluator);
                        String o1 = calc1.evaluateString(evaluator);
                        if (o0 == null && o1 == null) {
                            return true;
                        }
                        if (o0 == null) {
                            return false;
                        }
                        if (o1 == null) {
                            return true;
                        }
                        return o0.compareTo(o1) >= 0;
                    }
                };
            }
        });
    }
}

