/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.cuba.mdx.func;

import com.kingdee.bos.streamwork.cuba.CUBAException;
import com.kingdee.bos.streamwork.cuba.Dimension;
import com.kingdee.bos.streamwork.cuba.Hierarchy;
import com.kingdee.bos.streamwork.cuba.mdx.Evaluator;
import com.kingdee.bos.streamwork.cuba.mdx.Exp;
import com.kingdee.bos.streamwork.cuba.mdx.FunCall;
import com.kingdee.bos.streamwork.cuba.mdx.FunDefBase;
import com.kingdee.bos.streamwork.cuba.mdx.calc.Calc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.ExpCompiler;
import com.kingdee.bos.streamwork.cuba.mdx.calc.HierarchyCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.AbstractDimensionCalc;

public class HierarchyDimensionFunDef
extends FunDefBase {
    static final HierarchyDimensionFunDef instance = new HierarchyDimensionFunDef();

    private HierarchyDimensionFunDef() {
        super("Dimension", "<Hierarchy>.Dimension", "Returns the dimension that contains a specified hierarchy.", "pdh");
    }

    @Override
    public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
        HierarchyCalc hierarchyCalc = compiler.compileHierarchy(call.getArg(0));
        return new CalcImpl((Exp)call, hierarchyCalc);
    }

    public static class CalcImpl
    extends AbstractDimensionCalc {
        private final HierarchyCalc hierarchyCalc;

        public CalcImpl(Exp exp, HierarchyCalc hierarchyCalc) {
            super(exp, new Calc[]{hierarchyCalc});
            this.hierarchyCalc = hierarchyCalc;
        }

        @Override
        public Dimension evaluateDimension(Evaluator evaluator) throws CUBAException {
            Hierarchy hierarchy = this.hierarchyCalc.evaluateHierarchy(evaluator);
            return hierarchy.getDimension();
        }
    }
}

