/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.cuba.mdx.type;

import com.kingdee.bos.streamwork.cuba.Hierarchy;
import com.kingdee.bos.streamwork.cuba.Level;
import com.kingdee.bos.streamwork.cuba.mdx.type.DimensionType;
import com.kingdee.bos.streamwork.cuba.mdx.type.HierarchyType;
import com.kingdee.bos.streamwork.cuba.mdx.type.LevelType;
import com.kingdee.bos.streamwork.cuba.mdx.type.MemberType;
import com.kingdee.bos.streamwork.cuba.mdx.type.SetType;
import com.kingdee.bos.streamwork.cuba.mdx.type.TupleType;
import com.kingdee.bos.streamwork.cuba.mdx.type.Type;
import com.kingdee.bos.streamwork.cuba.util.Util;

public class TypeUtil {
    public static Hierarchy typeToHierarchy(Type type) {
        if (type instanceof MemberType) {
            return ((MemberType)type).getHierarchy();
        }
        if (type instanceof LevelType) {
            return ((LevelType)type).getHierarchy();
        }
        if (type instanceof HierarchyType) {
            return ((HierarchyType)type).getHierarchy();
        }
        if (type instanceof DimensionType) {
            return ((DimensionType)type).getHierarchy();
        }
        throw Util.newInternal("not an mdx object");
    }

    public static Level typeToLevel(Type type) {
        if (type instanceof LevelType) {
            return ((LevelType)type).getLevel();
        }
        throw Util.newInternal("not an mdx object");
    }

    public static Type stripSetType(Type type) {
        while (type instanceof SetType) {
            type = ((SetType)type).getElementType();
        }
        return type;
    }

    public static Type toMemberType(Type type) {
        if ((type = TypeUtil.stripSetType(type)) instanceof MemberType || type instanceof TupleType) {
            return type;
        }
        if (type instanceof DimensionType) {
            DimensionType dimensionType = (DimensionType)type;
            return new MemberType(dimensionType.getHierarchy(), dimensionType.getLevel(), null);
        }
        if (type instanceof HierarchyType) {
            HierarchyType hierarchyType = (HierarchyType)type;
            return new MemberType(hierarchyType.getHierarchy(), hierarchyType.getLevel(), null);
        }
        if (type instanceof LevelType) {
            LevelType levelType = (LevelType)type;
            return new MemberType(levelType.getHierarchy(), levelType.getLevel(), null);
        }
        return null;
    }

    public static boolean isUnionCompatible(Type type1, Type type2) {
        if (type1 instanceof MemberType) {
            MemberType memberType1 = (MemberType)type1;
            if (type2 instanceof MemberType) {
                MemberType memberType2 = (MemberType)type2;
                Hierarchy hierarchy1 = memberType1.getHierarchy();
                Hierarchy hierarchy2 = memberType2.getHierarchy();
                if (hierarchy1 == null || hierarchy2 == null || hierarchy2.getName().equals(hierarchy1.getName())) {
                    return true;
                }
            }
            return false;
        }
        if (type1 instanceof TupleType) {
            TupleType tupleType1 = (TupleType)type1;
            if (type2 instanceof TupleType) {
                TupleType tupleType2 = (TupleType)type2;
                if (tupleType1.elementTypes.length == tupleType2.elementTypes.length) {
                    for (int i = 0; i < tupleType1.elementTypes.length; ++i) {
                        if (TypeUtil.isUnionCompatible(tupleType1.elementTypes[i], tupleType2.elementTypes[i])) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }
        if (type1 instanceof SetType && type2 instanceof SetType) {
            return TypeUtil.isUnionCompatible(((SetType)type1).getElementType(), ((SetType)type2).getElementType());
        }
        if (type1 instanceof MemberType && type2 instanceof SetType) {
            return TypeUtil.isUnionCompatible((MemberType)type1, ((SetType)type2).getElementType());
        }
        if (type1 instanceof SetType && type2 instanceof MemberType) {
            return TypeUtil.isUnionCompatible(((SetType)type1).getElementType(), (MemberType)type2);
        }
        return false;
    }

    public static boolean couldBeMember(Type type) {
        return type instanceof MemberType || type instanceof HierarchyType || type instanceof DimensionType;
    }
}

