/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.datasource;

import com.kingdee.bos.streamwork.datasource.ColumnBasedDataSource;
import com.kingdee.bos.streamwork.datasource.DataSource;
import com.kingdee.bos.streamwork.datasource.DataSourceWithCachedPage;
import com.kingdee.bos.streamwork.datasource.MultiDataSource;
import com.kingdee.bos.streamwork.datasource.ResultSetDataSource;
import com.kingdee.bos.streamwork.xls.IXlsReader;
import java.sql.ResultSet;
import java.util.ArrayList;

public class DataSourceBuilder {
    public static DataSource buildDataSource(ResultSet rs, boolean columnBased) {
        if (columnBased) {
            return new ColumnBasedDataSource(rs);
        }
        return new ResultSetDataSource(rs);
    }

    private static DataSource buildDataSource(ResultSet rs, int limit, boolean columnBased) {
        if (columnBased) {
            return new ColumnBasedDataSource(rs, limit);
        }
        return new ResultSetDataSource(rs, limit);
    }

    public static DataSource buildPagedDataSource(ResultSet rs, boolean columnBased, int pageRows, boolean cache, int cacheTimeout) {
        DataSourceWithCachedPage ds;
        int rowCount;
        if (pageRows <= 0) {
            return DataSourceBuilder.buildDataSource(rs, columnBased);
        }
        ArrayList<DataSource> dataSources = new ArrayList<DataSource>();
        while ((rowCount = (ds = (DataSourceWithCachedPage)DataSourceBuilder.buildDataSource(rs, pageRows, columnBased)).getRowCount()) > 0) {
            dataSources.add(ds);
            if (rowCount >= pageRows) continue;
            break;
        }
        if (dataSources.isEmpty()) {
            return null;
        }
        return new MultiDataSource(dataSources, cache, cacheTimeout);
    }

    public static DataSource buildPagedDataSource(IXlsReader rs, boolean columnBased, int pageRows, boolean cache, int cacheTimeout) {
        ColumnBasedDataSource ds;
        int rowCount;
        if (pageRows <= 0) {
            return new ColumnBasedDataSource(rs);
        }
        ArrayList<DataSource> dataSources = new ArrayList<DataSource>();
        while ((rowCount = (ds = new ColumnBasedDataSource(rs, pageRows)).getRowCount()) > 0) {
            dataSources.add(ds);
            if (rowCount >= pageRows) continue;
            break;
        }
        if (dataSources.isEmpty()) {
            return null;
        }
        if (dataSources.size() == 1) {
            return (DataSource)dataSources.get(0);
        }
        return new MultiDataSource(dataSources, cache, cacheTimeout);
    }
}

