/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.datasource;

import com.kingdee.bos.streamwork.calculator.CalculatedField;
import com.kingdee.bos.streamwork.calculator.MapExecuteContext;
import com.kingdee.bos.streamwork.calculator.VerifyVisitor;
import com.kingdee.bos.streamwork.datasource.DataSource;
import java.util.ArrayList;
import java.util.List;

public class DataSourceWithCalculate
implements DataSource {
    private static final long serialVersionUID = -8137415314265159560L;
    private DataSource inner;
    private ArrayList<CalculatedField> calculatedList = new ArrayList();

    public DataSourceWithCalculate(DataSource datasource) {
        this.inner = datasource;
    }

    public List<CalculatedField> getAllCalculatedFields() {
        return this.calculatedList;
    }

    public void addCalculatedField(CalculatedField field) {
        this.calculatedList.add(field);
    }

    public CalculatedField getCalculatedField(String fieldName) {
        for (int i = 0; i < this.calculatedList.size(); ++i) {
            CalculatedField field = this.calculatedList.get(i);
            if (!field.name.equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    public List<CalculatedField> getReferenceFields(String fieldName) {
        CalculatedField me = null;
        ArrayList<CalculatedField> others = new ArrayList<CalculatedField>();
        for (int i = 0; i < this.calculatedList.size(); ++i) {
            CalculatedField field = this.calculatedList.get(i);
            if (field.name.equals(fieldName)) {
                me = field;
                continue;
            }
            others.add(field);
        }
        MapExecuteContext ctx = new MapExecuteContext();
        String[] columnNames = this.inner.getColumnNames();
        ctx.putValue(me.name, null);
        int size0 = 0;
        ArrayList<CalculatedField> result = new ArrayList<CalculatedField>();
        do {
            size0 = ctx.size();
            ArrayList<CalculatedField> toRemove = new ArrayList<CalculatedField>();
            block2: for (int i = 0; i < others.size(); ++i) {
                CalculatedField field = (CalculatedField)others.get(i);
                VerifyVisitor visitor = new VerifyVisitor(ctx);
                field.expr.accept(visitor);
                for (String s : visitor.getValidSymboList()) {
                    if (!ctx.contains(s)) continue;
                    result.add(field);
                    ctx.putValue(field.name, null);
                    toRemove.add(field);
                    continue block2;
                }
            }
            others.removeAll(toRemove);
        } while (ctx.size() > size0);
        return result;
    }

    public void removeCalculatedField(CalculatedField field) {
        this.calculatedList.remove(field);
    }

    public void removeCalculatedField(String name) {
        for (int i = 0; i < this.calculatedList.size(); ++i) {
            CalculatedField field = this.calculatedList.get(i);
            if (!name.equals(field.name)) continue;
            this.calculatedList.remove(i);
            return;
        }
    }

    @Override
    public int[] getColumnTypes() {
        if (this.calculatedList.isEmpty()) {
            return this.inner.getColumnTypes();
        }
        int[] innerTypes = this.inner.getColumnTypes();
        int[] types = new int[innerTypes.length + this.calculatedList.size()];
        System.arraycopy(innerTypes, 0, types, 0, innerTypes.length);
        for (int i = innerTypes.length; i < types.length; ++i) {
            types[i] = this.calculatedList.get((int)(i - innerTypes.length)).type;
        }
        return types;
    }

    @Override
    public String[] getColumnNames() {
        if (this.calculatedList.isEmpty()) {
            return this.inner.getColumnNames();
        }
        String[] innerNames = this.inner.getColumnNames();
        String[] names = new String[innerNames.length + this.calculatedList.size()];
        System.arraycopy(innerNames, 0, names, 0, innerNames.length);
        for (int i = innerNames.length; i < names.length; ++i) {
            names[i] = this.calculatedList.get((int)(i - innerNames.length)).name;
        }
        return names;
    }

    @Override
    public int getRowCount() {
        return this.inner.getRowCount();
    }

    @Override
    public Object getCell(int columnIndex, int rowIndex) {
        if (columnIndex < this.inner.getColumnTypes().length) {
            return this.inner.getCell(columnIndex, rowIndex);
        }
        MapExecuteContext ctx = new MapExecuteContext();
        String[] names = this.inner.getColumnNames();
        for (int i = 0; i < names.length; ++i) {
            ctx.putValue(names[i], this.getCell(i, rowIndex));
        }
        int index = columnIndex - this.inner.getColumnNames().length;
        for (int i = 0; i < index; ++i) {
            CalculatedField field = this.calculatedList.get(i);
            ctx.putValue(field.name, field.expr.execute(ctx));
        }
        CalculatedField field = this.calculatedList.get(index);
        return field.expr.execute(ctx);
    }

    @Override
    public Object getProperty(Object key) {
        return this.inner.getProperty(key);
    }

    @Override
    public void setProperty(Object key, Object value) {
        this.inner.setProperty(key, value);
    }
}

